/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channel;
import org.codehaus.plexus.util.BaseIOUtil;

public final class IOUtil
extends BaseIOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    private IOUtil() {
    }

    public static void copy(InputStream input2, OutputStream output2) throws IOException {
        BaseIOUtil.copy(input2, output2);
    }

    public static void copy(InputStream input2, OutputStream output2, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while (0 <= (n = input2.read(buffer))) {
            output2.write(buffer, 0, n);
        }
    }

    public static void copy(Reader input2, Writer output2) throws IOException {
        BaseIOUtil.copy(input2, output2);
    }

    public static void copy(Reader input2, Writer output2, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (0 <= (n = input2.read(buffer))) {
            output2.write(buffer, 0, n);
        }
        output2.flush();
    }

    public static void copy(InputStream input2, Writer output2) throws IOException {
        IOUtil.copy(input2, output2, 16384);
    }

    public static void copy(InputStream input2, Writer output2, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input2);
        IOUtil.copy((Reader)in, output2, bufferSize);
    }

    public static void copy(InputStream input2, Writer output2, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input2, encoding);
        IOUtil.copy((Reader)in, output2);
    }

    public static void copy(InputStream input2, Writer output2, String encoding, int bufferSize) throws IOException {
        InputStreamReader in = new InputStreamReader(input2, encoding);
        IOUtil.copy((Reader)in, output2, bufferSize);
    }

    public static String toString(InputStream input2) throws IOException {
        return IOUtil.toString(input2, 16384);
    }

    public static String toString(InputStream input2, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input2, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(InputStream input2, String encoding) throws IOException {
        return IOUtil.toString(input2, encoding, 16384);
    }

    public static String toString(InputStream input2, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input2, (Writer)sw, encoding, bufferSize);
        return sw.toString();
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        return IOUtil.toByteArray(input2, 16384);
    }

    public static byte[] toByteArray(InputStream input2, int bufferSize) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        IOUtil.copy(input2, (OutputStream)output2, bufferSize);
        return output2.toByteArray();
    }

    public static void copy(Reader input2, OutputStream output2) throws IOException {
        IOUtil.copy(input2, output2, 16384);
    }

    public static void copy(Reader input2, OutputStream output2, int bufferSize) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output2);
        IOUtil.copy(input2, (Writer)out, bufferSize);
        out.flush();
    }

    public static String toString(Reader input2) throws IOException {
        return IOUtil.toString(input2, 16384);
    }

    public static String toString(Reader input2, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input2, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static byte[] toByteArray(Reader input2) throws IOException {
        return IOUtil.toByteArray(input2, 16384);
    }

    public static byte[] toByteArray(Reader input2, int bufferSize) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        IOUtil.copy(input2, (OutputStream)output2, bufferSize);
        return output2.toByteArray();
    }

    public static void copy(String input2, OutputStream output2) throws IOException {
        IOUtil.copy(input2, output2, 16384);
    }

    public static void copy(String input2, OutputStream output2, int bufferSize) throws IOException {
        StringReader in = new StringReader(input2);
        OutputStreamWriter out = new OutputStreamWriter(output2);
        IOUtil.copy((Reader)in, (Writer)out, bufferSize);
        out.flush();
    }

    public static void copy(String input2, Writer output2) throws IOException {
        output2.write(input2);
    }

    @Deprecated
    public static void bufferedCopy(InputStream input2, OutputStream output2) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input2);
        BufferedOutputStream out = new BufferedOutputStream(output2);
        IOUtil.copy((InputStream)in, (OutputStream)out);
        out.flush();
    }

    public static byte[] toByteArray(String input2) throws IOException {
        return IOUtil.toByteArray(input2, 16384);
    }

    public static byte[] toByteArray(String input2, int bufferSize) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        IOUtil.copy(input2, (OutputStream)output2, bufferSize);
        return output2.toByteArray();
    }

    public static void copy(byte[] input2, Writer output2) throws IOException {
        IOUtil.copy(input2, output2, 16384);
    }

    public static void copy(byte[] input2, Writer output2, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input2);
        IOUtil.copy((InputStream)in, output2, bufferSize);
    }

    public static void copy(byte[] input2, Writer output2, String encoding) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input2);
        IOUtil.copy((InputStream)in, output2, encoding);
    }

    public static void copy(byte[] input2, Writer output2, String encoding, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input2);
        IOUtil.copy(in, output2, encoding, bufferSize);
    }

    public static String toString(byte[] input2) throws IOException {
        return IOUtil.toString(input2, 16384);
    }

    public static String toString(byte[] input2, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input2, (Writer)sw, bufferSize);
        return sw.toString();
    }

    public static String toString(byte[] input2, String encoding) throws IOException {
        return IOUtil.toString(input2, encoding, 16384);
    }

    public static String toString(byte[] input2, String encoding, int bufferSize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input2, (Writer)sw, encoding, bufferSize);
        return sw.toString();
    }

    public static void copy(byte[] input2, OutputStream output2) throws IOException {
        IOUtil.copy(input2, output2, 16384);
    }

    public static void copy(byte[] input2, OutputStream output2, int bufferSize) throws IOException {
        output2.write(input2);
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        BufferedInputStream bufferedInput1 = new BufferedInputStream(input1);
        BufferedInputStream bufferedInput2 = new BufferedInputStream(input2);
        int ch = ((InputStream)bufferedInput1).read();
        while (0 <= ch) {
            ch2 = ((InputStream)bufferedInput2).read();
            if (ch != ch2) {
                return false;
            }
            ch = ((InputStream)bufferedInput1).read();
        }
        ch2 = ((InputStream)bufferedInput2).read();
        return 0 > ch2;
    }

    @Deprecated
    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void close(Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

