/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;

public class MavenBuildTimestamp {
    public static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String BUILD_TIMESTAMP_FORMAT_PROPERTY = "maven.build.timestamp.format";
    public static final TimeZone DEFAULT_BUILD_TIME_ZONE = TimeZone.getTimeZone("Etc/UTC");
    private String formattedTimestamp;

    public MavenBuildTimestamp() {
        this(new Date());
    }

    public MavenBuildTimestamp(Date time2) {
        this(time2, DEFAULT_BUILD_TIMESTAMP_FORMAT);
    }

    public MavenBuildTimestamp(Date time2, Properties properties2) {
        this(time2, properties2 != null ? properties2.getProperty(BUILD_TIMESTAMP_FORMAT_PROPERTY) : null);
    }

    public MavenBuildTimestamp(Date time2, String timestampFormat) {
        if (timestampFormat == null) {
            timestampFormat = DEFAULT_BUILD_TIMESTAMP_FORMAT;
        }
        if (time2 == null) {
            time2 = new Date();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(timestampFormat);
        dateFormat.setCalendar(new GregorianCalendar());
        dateFormat.setTimeZone(DEFAULT_BUILD_TIME_ZONE);
        this.formattedTimestamp = dateFormat.format(time2);
    }

    public String formattedTimestamp() {
        return this.formattedTimestamp;
    }
}

