/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.function.Predicate;

public class ComparableUtils {
    public static <A extends Comparable<A>> Predicate<A> between(A b2, A c) {
        return a2 -> ComparableUtils.is(a2).between(b2, c);
    }

    public static <A extends Comparable<A>> Predicate<A> betweenExclusive(A b2, A c) {
        return a2 -> ComparableUtils.is(a2).betweenExclusive(b2, c);
    }

    public static <A extends Comparable<A>> Predicate<A> ge(A b2) {
        return a2 -> ComparableUtils.is(a2).greaterThanOrEqualTo(b2);
    }

    public static <A extends Comparable<A>> Predicate<A> gt(A b2) {
        return a2 -> ComparableUtils.is(a2).greaterThan(b2);
    }

    public static <A extends Comparable<A>> ComparableCheckBuilder<A> is(A a2) {
        return new ComparableCheckBuilder(a2, null);
    }

    public static <A extends Comparable<A>> Predicate<A> le(A b2) {
        return a2 -> ComparableUtils.is(a2).lessThanOrEqualTo(b2);
    }

    public static <A extends Comparable<A>> Predicate<A> lt(A b2) {
        return a2 -> ComparableUtils.is(a2).lessThan(b2);
    }

    private ComparableUtils() {
    }

    public static class ComparableCheckBuilder<A extends Comparable<A>> {
        private final A a;

        private ComparableCheckBuilder(A a2) {
            this.a = a2;
        }

        public boolean between(A b2, A c) {
            return this.betweenOrdered(b2, c) || this.betweenOrdered(c, b2);
        }

        public boolean betweenExclusive(A b2, A c) {
            return this.betweenOrderedExclusive(b2, c) || this.betweenOrderedExclusive(c, b2);
        }

        private boolean betweenOrdered(A b2, A c) {
            return this.greaterThanOrEqualTo(b2) && this.lessThanOrEqualTo(c);
        }

        private boolean betweenOrderedExclusive(A b2, A c) {
            return this.greaterThan(b2) && this.lessThan(c);
        }

        public boolean equalTo(A b2) {
            return this.a.compareTo(b2) == 0;
        }

        public boolean greaterThan(A b2) {
            return this.a.compareTo(b2) > 0;
        }

        public boolean greaterThanOrEqualTo(A b2) {
            return this.a.compareTo(b2) >= 0;
        }

        public boolean lessThan(A b2) {
            return this.a.compareTo(b2) < 0;
        }

        public boolean lessThanOrEqualTo(A b2) {
            return this.a.compareTo(b2) <= 0;
        }

        /* synthetic */ ComparableCheckBuilder(Comparable x0, 1 x1) {
            this(x0);
        }
    }
}

