/*
 * Decompiled with CFR 0.152.
 */
package jtermios.macosx;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static int IOSSIOSPEED = -2147199998;
    private static String DEVICE_DIR_PATH = "/dev/";
    static MacOSX_C_lib m_Clib = Native.loadLibrary("c", MacOSX_C_lib.class);

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        MacOSX_C_lib.termios termios3 = new MacOSX_C_lib.termios(termios2);
        m_Clib.cfmakeraw(termios3);
        termios3.update(termios2);
    }

    @Override
    public int fcntl(int n, int n2, int n3) {
        return m_Clib.fcntl(n, n2, n3);
    }

    @Override
    public int tcdrain(int n) {
        return m_Clib.tcdrain(n);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new MacOSX_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new MacOSX_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int n) {
        MacOSX_C_lib.termios termios3 = new MacOSX_C_lib.termios(termios2);
        int n2 = m_Clib.cfsetispeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int cfsetospeed(Termios termios2, int n) {
        MacOSX_C_lib.termios termios3 = new MacOSX_C_lib.termios(termios2);
        int n2 = m_Clib.cfsetospeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int open(String string, int n) {
        if (string != null && !string.startsWith("/")) {
            string = DEVICE_DIR_PATH + string;
        }
        return m_Clib.open(string, n);
    }

    @Override
    public int read(int n, byte[] byArray, int n2) {
        return m_Clib.read(n, ByteBuffer.wrap(byArray), new NativeLong((long)n2)).intValue();
    }

    @Override
    public int write(int n, byte[] byArray, int n2) {
        return m_Clib.write(n, ByteBuffer.wrap(byArray), new NativeLong((long)n2)).intValue();
    }

    @Override
    public int close(int n) {
        return m_Clib.close(n);
    }

    @Override
    public int tcflush(int n, int n2) {
        return m_Clib.tcflush(n, n2);
    }

    @Override
    public int tcgetattr(int n, Termios termios2) {
        MacOSX_C_lib.termios termios3 = new MacOSX_C_lib.termios();
        int n2 = m_Clib.tcgetattr(n, termios3);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public void perror(String string) {
        m_Clib.perror(string);
    }

    @Override
    public int tcsendbreak(int n, int n2) {
        throw new IllegalArgumentException("Unimplemented function");
    }

    @Override
    public int tcsetattr(int n, int n2, Termios termios2) {
        return m_Clib.tcsetattr(n, n2, new MacOSX_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] & ~(1 << n % 32);
    }

    @Override
    public boolean FD_ISSET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return false;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        return (fDSetImpl.bits[n / 32] & 1 << n % 32) != 0;
    }

    @Override
    public void FD_SET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] | 1 << n % 32;
    }

    @Override
    public void FD_ZERO(FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        Arrays.fill(fDSetImpl.bits, 0);
    }

    @Override
    public int select(int n, FDSet fDSet, FDSet fDSet2, FDSet fDSet3, TimeVal timeVal) {
        MacOSX_C_lib.timeval timeval2 = null;
        if (timeVal != null) {
            timeval2 = new MacOSX_C_lib.timeval(timeVal);
        }
        int[] nArray = fDSet != null ? ((FDSetImpl)fDSet).bits : null;
        int[] nArray2 = fDSet2 != null ? ((FDSetImpl)fDSet2).bits : null;
        int[] nArray3 = fDSet3 != null ? ((FDSetImpl)fDSet3).bits : null;
        return m_Clib.select(n, nArray, nArray2, nArray3, timeval2);
    }

    @Override
    public int poll(Pollfd[] pollfdArray, int n, int n2) {
        int n3;
        MacOSX_C_lib.pollfd[] pollfdArray2 = new MacOSX_C_lib.pollfd[pollfdArray.length];
        for (n3 = 0; n3 < n; ++n3) {
            pollfdArray2[n3] = new MacOSX_C_lib.pollfd(pollfdArray[n3]);
        }
        n3 = m_Clib.poll(pollfdArray2, n, n2);
        for (int j = 0; j < n; ++j) {
            pollfdArray[j].revents = pollfdArray2[j].revents;
        }
        return n3;
    }

    @Override
    public int poll(int[] nArray, int n, int n2) {
        return m_Clib.poll(nArray, n, n2);
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int n, int n2, int[] nArray) {
        return m_Clib.ioctl(n, n2, nArray);
    }

    public int ioctl(int n, int n2, NativeLong[] nativeLongArray) {
        return m_Clib.ioctl(n, n2, nativeLongArray);
    }

    @Override
    public List<String> getPortList() {
        File file = new File(DEVICE_DIR_PATH);
        if (!file.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] stringArray = file.list();
        LinkedList<String> linkedList = new LinkedList<String>();
        Pattern pattern = JTermios.getPortNamePattern(this);
        if (stringArray != null) {
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                if (!pattern.matcher(string).matches()) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }

    @Override
    public String getPortNamePattern() {
        return "^(tty\\.|cu\\.).*";
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int n, Termios termios2, int n2) {
        int n3 = this.cfsetispeed(termios2, n2);
        if (n3 == 0) {
            n3 = this.cfsetospeed(termios2, n2);
        }
        if (n3 == 0) {
            n3 = this.tcsetattr(n, JTermios.TCSANOW, termios2);
        }
        if (n3 != 0 && this.cfsetispeed(termios2, JTermios.B9600) == 0 && this.cfsetospeed(termios2, JTermios.B9600) == 0 && this.tcsetattr(n, JTermios.TCSANOW, termios2) == 0) {
            NativeLong[] nativeLongArray = new NativeLong[]{new NativeLong((long)n2)};
            n3 = this.ioctl(n, IOSSIOSPEED, nativeLongArray);
        }
        return n3;
    }

    @Override
    public int pipe(int[] nArray) {
        return m_Clib.pipe(nArray);
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = 32;
        int[] bits = new int[32];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface MacOSX_C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int ioctl(int var1, int var2, NativeLong[] var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public NativeLong write(int var1, ByteBuffer var2, NativeLong var3);

        public NativeLong read(int var1, ByteBuffer var2, NativeLong var3);

        public int select(int var1, int[] var2, int[] var3, int[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public static class termios
        extends Structure {
            public NativeLong c_iflag = new NativeLong();
            public NativeLong c_oflag = new NativeLong();
            public NativeLong c_cflag = new NativeLong();
            public NativeLong c_lflag = new NativeLong();
            public byte[] c_cc = new byte[20];
            public NativeLong c_ispeed = new NativeLong();
            public NativeLong c_ospeed = new NativeLong();

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc", "c_ispeed", "c_ospeed");
            }

            public termios() {
            }

            public termios(Termios termios2) {
                this.c_iflag.setValue(termios2.c_iflag);
                this.c_oflag.setValue(termios2.c_oflag);
                this.c_cflag.setValue(termios2.c_cflag);
                this.c_lflag.setValue(termios2.c_lflag);
                System.arraycopy(termios2.c_cc, 0, this.c_cc, 0, termios2.c_cc.length);
                this.c_ispeed.setValue(termios2.c_ispeed);
                this.c_ospeed.setValue(termios2.c_ospeed);
            }

            public void update(Termios termios2) {
                termios2.c_iflag = this.c_iflag.intValue();
                termios2.c_oflag = this.c_oflag.intValue();
                termios2.c_cflag = this.c_cflag.intValue();
                termios2.c_lflag = this.c_lflag.intValue();
                System.arraycopy(this.c_cc, 0, termios2.c_cc, 0, termios2.c_cc.length);
                termios2.c_ispeed = this.c_ispeed.intValue();
                termios2.c_ospeed = this.c_ospeed.intValue();
            }
        }

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pollfd2) {
                this.fd = pollfd2.fd;
                this.events = pollfd2.events;
                this.revents = pollfd2.revents;
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeVal) {
                this.tv_sec = new NativeLong(timeVal.tv_sec);
                this.tv_usec = new NativeLong(timeVal.tv_usec);
            }
        }
    }
}

