/*
 * Decompiled with CFR 0.152.
 */
package jtermios;

import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.macosx.JTermiosImpl;

public class JTermios {
    public static int FIONREAD = 1074030207;
    public static int O_RDWR = 2;
    public static int O_NONBLOCK = 4;
    public static int O_NOCTTY = 131072;
    public static int O_NDELAY = 4;
    public static int O_CREAT = 512;
    public static int F_GETFL = 3;
    public static int F_SETFL = 4;
    public static int EAGAIN = 35;
    public static int EBADF = 9;
    public static int EACCES = 22;
    public static int EEXIST = 17;
    public static int EINTR = 4;
    public static int EINVAL = 22;
    public static int EIO = 5;
    public static int EISDIR = 21;
    public static int ELOOP = 62;
    public static int EMFILE = 24;
    public static int ENAMETOOLONG = 63;
    public static int ENFILE = 23;
    public static int ENOENT = 2;
    public static int ENOSR = 98;
    public static int ENOSPC = 28;
    public static int ENOTDIR = 20;
    public static int ENXIO = 6;
    public static int EOVERFLOW = 84;
    public static int EROFS = 30;
    public static int ENOTSUP = 45;
    public static int EBUSY = 16;
    public static int TIOCM_RNG = 128;
    public static int TIOCM_CAR = 64;
    public static int IGNBRK = 1;
    public static int BRKINT = 2;
    public static int IGNPAR = 4;
    public static int PARMRK = 8;
    public static int INLCR = 64;
    public static int IGNCR = 128;
    public static int ICRNL = 256;
    public static int ECHONL = 16;
    public static int IEXTEN = 1024;
    public static int CLOCAL = 32768;
    public static int OPOST = 1;
    public static int VSTART = 12;
    public static int TCSANOW = 0;
    public static int VSTOP = 13;
    public static int VMIN = 16;
    public static int VTIME = 17;
    public static int VEOF = 0;
    public static int TIOCMGET = 1074033770;
    public static int TIOCM_CTS = 32;
    public static int TIOCM_DSR = 256;
    public static int TIOCM_RI = 128;
    public static int TIOCM_CD = 64;
    public static int TIOCM_DTR = 2;
    public static int TIOCM_RTS = 4;
    public static int ICANON = 256;
    public static int ECHO = 8;
    public static int ECHOE = 2;
    public static int ISIG = 128;
    public static int TIOCMSET = -2147191699;
    public static int IXON = 512;
    public static int IXOFF = 1024;
    public static int IXANY = 2048;
    public static int CRTSCTS = 196608;
    public static int TCSADRAIN = 1;
    public static int INPCK = 16;
    public static int ISTRIP = 32;
    public static int CSIZE = 768;
    public static int TCIFLUSH = 1;
    public static int TCOFLUSH = 2;
    public static int TCIOFLUSH = 3;
    public static int CS5 = 0;
    public static int CS6 = 256;
    public static int CS7 = 512;
    public static int CS8 = 768;
    public static int CSTOPB = 1024;
    public static int CREAD = 2048;
    public static int PARENB = 4096;
    public static int PARODD = 8192;
    public static int CMSPAR = 0x40000000;
    public static int B0 = 0;
    public static int B50 = 50;
    public static int B75 = 75;
    public static int B110 = 110;
    public static int B134 = 134;
    public static int B150 = 150;
    public static int B200 = 200;
    public static int B300 = 300;
    public static int B600 = 600;
    public static int B1200 = 1200;
    public static int B1800 = 1800;
    public static int B2400 = 2400;
    public static int B4800 = 4800;
    public static int B9600 = 9600;
    public static int B19200 = 19200;
    public static int B38400 = 38400;
    public static int B7200 = 7200;
    public static int B14400 = 14400;
    public static int B28800 = 28800;
    public static int B57600 = 57600;
    public static int B76800 = 76800;
    public static int B115200 = 115200;
    public static int B230400 = 230400;
    public static short POLLIN = 1;
    public static int POLLIN_IN = 1;
    public static int POLLIN_OUT = 1;
    public static short POLLPRI = (short)2;
    public static short POLLOUT = (short)4;
    public static int POLLOUT_IN = 4;
    public static int POLLOUT_OUT = 4;
    public static short POLLERR = (short)8;
    public static short POLLERR_OUT = (short)8;
    public static short POLLNVAL = (short)32;
    public static int POLLNVAL_OUT = 32;
    public static int DC1 = 17;
    public static int DC3 = 19;
    private static JTermiosInterface m_Termios;

    public void shutdown() {
        if (m_Termios != null) {
            m_Termios.shutDown();
        }
    }

    public static int errno() {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> errno()\n", new Object[0]);
        int n = m_Termios.errno();
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< errno() => %d\n", n);
        return n;
    }

    public static int fcntl(int n, int n2, int n3) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> fcntl(%d, %d, %d)\n", n, n2, n3);
        int n4 = m_Termios.fcntl(n, n2, n3);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< fcntl(%d, %d, %d) => %d\n", n, n2, n3, n4);
        return n4;
    }

    public static int cfgetispeed(Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetispeed(%s)\n", termios2);
        int n = m_Termios.cfgetispeed(termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetispeed(%s) => %d\n", termios2, n);
        return n;
    }

    public static int cfgetospeed(Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetospeed(%s)\n", termios2);
        int n = m_Termios.cfgetospeed(termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetospeed(%s) => %d\n", termios2, n);
        return n;
    }

    public static int cfsetispeed(Termios termios2, int n) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetospeed(%s,%d)\n", termios2, n);
        int n2 = m_Termios.cfsetispeed(termios2, n);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetospeed(%s,%d) => %d\n", termios2, n, n2);
        return n2;
    }

    public static int cfsetospeed(Termios termios2, int n) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfgetospeed(%s,%d)\n", termios2, n);
        int n2 = m_Termios.cfsetospeed(termios2, n);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfgetospeed(%s,%d) => %d\n", termios2, n, n2);
        return n2;
    }

    public static int setspeed(int n, Termios termios2, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> setspeed(%d,%s,%d)\n", n, termios2, n2);
        int n3 = m_Termios.setspeed(n, termios2, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< setspeed(%d,%s,%d) => %d\n", n, termios2, n2, n3);
        return n3;
    }

    public static int tcflush(int n, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcflush(%d,%d)\n", n, n2);
        int n3 = m_Termios.tcflush(n, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcflush(%d,%d) => %d\n", n, n2, n3);
        return n3;
    }

    public static int tcdrain(int n) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcdrain(%d)\n", n);
        int n2 = m_Termios.tcdrain(n);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcdrain(%d) => %d\n", n, n2);
        return n2;
    }

    public static void cfmakeraw(int n, Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> cfmakeraw(%d,%s)\n", n, termios2);
        m_Termios.cfmakeraw(termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< cfmakeraw(%d,%s)\n", n, termios2);
    }

    public static int tcgetattr(int n, Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcgetattr(%d,%s)\n", n, termios2);
        int n2 = m_Termios.tcgetattr(n, termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcgetattr(%d,%s) => %d\n", n, termios2, n2);
        return n2;
    }

    public static int tcsetattr(int n, int n2, Termios termios2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcsetattr(%d,%d,%s)\n", n, n2, termios2);
        int n3 = m_Termios.tcsetattr(n, n2, termios2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcsetattr(%d,%d,%s) => %d\n", n, n2, termios2, n3);
        return n3;
    }

    public static int tcsendbreak(int n, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> tcsendbreak(%d,%d,%s)\n", n, n2);
        int n3 = m_Termios.tcsendbreak(n, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< tcsendbreak(%d,%d,%s) => %d\n", n, n2, n3);
        return n3;
    }

    public static int open(String string, int n) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> open('%s',%08X)\n", string, n);
        int n2 = m_Termios.open(string, n);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< open('%s',%08X) => %d\n", string, n, n2);
        return n2;
    }

    public static int close(int n) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> close(%d)\n", n);
        int n2 = m_Termios.close(n);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< close(%d) => %d\n", n, n2);
        return n2;
    }

    public static int write(int n, byte[] byArray, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> write(%d,%s,%d)\n", n, JTermiosLogging.log(byArray, 8), n2);
        int n3 = m_Termios.write(n, byArray, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< write(%d,%s,%d) => %d\n", n, JTermiosLogging.log(byArray, 8), n2, n3);
        return n3;
    }

    public static int read(int n, byte[] byArray, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> read(%d,%s,%d)\n", n, JTermiosLogging.log(byArray, 8), n2);
        int n3 = m_Termios.read(n, byArray, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< read(%d,%s,%d) => %d\n", n, JTermiosLogging.log(byArray, 8), n2, n3);
        return n3;
    }

    public static int ioctl(int n, int n2, int[] nArray) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> ioctl(%d,%d,[%08X])\n", n, n2, nArray[0]);
        int n3 = m_Termios.ioctl(n, n2, nArray);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< ioctl(%d,%d,[%08X]) => %d\n", n, n2, nArray[0], n3);
        return n3;
    }

    private static String toString(int n, FDSet fDSet) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int j = 0; j < n; ++j) {
            if (!JTermios.FD_ISSET(j, fDSet)) continue;
            stringBuffer.append(Integer.toString(j));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static int select(int n, FDSet fDSet, FDSet fDSet2, FDSet fDSet3, TimeVal timeVal) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> select(%d,%s,%s,%s,%s)\n", n, JTermios.toString(n, fDSet), JTermios.toString(n, fDSet2), JTermios.toString(n, fDSet3), timeVal);
        int n2 = m_Termios.select(n, fDSet, fDSet2, fDSet3, timeVal);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< select(%d,%s,%s,%s,%s) => %d\n", n, JTermios.toString(n, fDSet), JTermios.toString(n, fDSet2), JTermios.toString(n, fDSet3), timeVal, n2);
        return n2;
    }

    public static int poll(Pollfd[] pollfdArray, int n, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> poll(%s,%d,%d)\n", JTermiosLogging.log(pollfdArray, 8), n, n2);
        int n3 = m_Termios.poll(pollfdArray, n, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< poll(%s,%d,%d) => %d\n", JTermiosLogging.log(pollfdArray, 8), n, n2, n3);
        return n3;
    }

    public static int poll(int[] nArray, int n, int n2) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> poll(%s,%d,%d)\n", JTermiosLogging.log(nArray, 8), n, n2);
        int n3 = m_Termios.poll(nArray, n, n2);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< poll(%s,%d,%d) => %d\n", JTermiosLogging.log(nArray, 8), n, n2, n3);
        return n3;
    }

    public static int pipe(int[] nArray) {
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(5, "> pipe([%d,%d,%d])\n", nArray.length, nArray[0], nArray[1]);
        int n = m_Termios.pipe(nArray);
        JTermiosLogging.log = JTermiosLogging.log && JTermiosLogging.log(3, "< pipe([%d,%d,%d]) => %d\n", nArray.length, nArray[0], nArray[1], n);
        return n;
    }

    public static void perror(String string) {
        m_Termios.perror(string);
    }

    public static FDSet newFDSet() {
        return m_Termios.newFDSet();
    }

    public static void FD_SET(int n, FDSet fDSet) {
        m_Termios.FD_SET(n, fDSet);
    }

    public static void FD_CLR(int n, FDSet fDSet) {
        m_Termios.FD_CLR(n, fDSet);
    }

    public static boolean FD_ISSET(int n, FDSet fDSet) {
        return m_Termios.FD_ISSET(n, fDSet);
    }

    public static void FD_ZERO(FDSet fDSet) {
        m_Termios.FD_ZERO(fDSet);
    }

    public static List<String> getPortList() {
        return m_Termios.getPortList();
    }

    public static Pattern getPortNamePattern(JTermiosInterface jTermiosInterface) {
        String string = System.getProperty("purejavacomm.portnamepattern." + jTermiosInterface.getClass().getName());
        if (string == null) {
            string = System.getProperty("purejavacomm.portnamepattern");
        }
        if (string == null) {
            string = jTermiosInterface.getPortNamePattern();
        }
        return Pattern.compile(string);
    }

    static {
        if (Platform.isMac()) {
            m_Termios = new JTermiosImpl();
        } else if (Platform.isWindows()) {
            m_Termios = new jtermios.windows.JTermiosImpl();
        } else if (Platform.isLinux()) {
            m_Termios = new jtermios.linux.JTermiosImpl();
        } else if (Platform.isSolaris()) {
            m_Termios = new jtermios.solaris.JTermiosImpl();
        } else if (Platform.isFreeBSD()) {
            m_Termios = new jtermios.freebsd.JTermiosImpl();
        } else {
            JTermiosLogging.log(0, "JTermios has no support for OS %s\n", System.getProperty("os.name"));
        }
    }

    public static class JTermiosLogging {
        private static int LOG_MASK = 0;
        public static boolean log = false;
        private static StringBuffer buffer;

        public static String lineno() {
            return JTermiosLogging.lineno(0);
        }

        public static String lineno(int n) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2 + n];
            return String.format("class %s line% d", stackTraceElement.getClassName(), stackTraceElement.getLineNumber());
        }

        public static String ref(Structure structure) {
            if (structure == null) {
                return "null";
            }
            return structure.getPointer().toString();
        }

        public static String log(byte[] byArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n < 0 || n > byArray.length) {
                n = byArray.length;
            }
            stringBuffer.append(String.format("[%d", byArray.length));
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(String.format(",0x%02X", byArray[j]));
            }
            if (n < byArray.length) {
                stringBuffer.append("...");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public static String log(int[] nArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n < 0 || n > nArray.length) {
                n = nArray.length;
            }
            stringBuffer.append(String.format("[%d", nArray.length));
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(String.format(",0x%08X", nArray[j]));
            }
            if (n < nArray.length) {
                stringBuffer.append("...");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public static String log(char[] cArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n < 0 || n > cArray.length) {
                n = cArray.length;
            }
            stringBuffer.append(String.format("[%d", cArray.length));
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(String.format(",%c", Character.valueOf(cArray[j])));
            }
            if (n < cArray.length) {
                stringBuffer.append("...");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public static String log(Object[] objectArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n < 0 || n > objectArray.length) {
                n = objectArray.length;
            }
            stringBuffer.append(String.format("[%d", objectArray.length));
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(",");
                stringBuffer.append(objectArray[j] != null ? objectArray[j].toString() : "null");
            }
            if (n < objectArray.length) {
                stringBuffer.append("...");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean log(int n, String string, Object ... objectArray) {
            if (n == 0 || LOG_MASK != 0) {
                StringBuffer stringBuffer = buffer;
                synchronized (stringBuffer) {
                    buffer.setLength(0);
                    if ((LOG_MASK & 0x20) != 0) {
                        buffer.append(String.format("%06d,", System.currentTimeMillis() % 1000000L));
                    }
                    if ((LOG_MASK & 0x40) != 0) {
                        buffer.append(JTermiosLogging.lineno(2));
                        buffer.append(", ");
                    }
                    if ((LOG_MASK & 0x80) != 0) {
                        buffer.append("thread id ");
                        buffer.append(Thread.currentThread().getId());
                        buffer.append(", ");
                        buffer.append(Thread.currentThread().getName());
                        buffer.append(", ");
                    }
                    if (n == 0 || (LOG_MASK & 1 << n - 1) != 0) {
                        buffer.append(String.format(string, objectArray));
                    }
                    if (buffer.length() > 0) {
                        System.err.printf("log: " + buffer.toString(), new Object[0]);
                    }
                }
            }
            return true;
        }

        public static void setLogLevel(int n) {
            LOG_MASK = 0;
            for (int j = 0; j < n; ++j) {
                LOG_MASK = (LOG_MASK << 1) + 1;
            }
            log = LOG_MASK != 0;
        }

        public static void setLogMask(int n) {
            LOG_MASK = n;
            log = LOG_MASK != 0;
        }

        static {
            String string = System.getProperty("purejavacomm.loglevel");
            if (string != null) {
                JTermiosLogging.setLogLevel(Integer.parseInt(string));
            }
            buffer = new StringBuffer();
        }
    }

    public static interface JTermiosInterface {
        public int pipe(int[] var1);

        public void shutDown();

        public int errno();

        public int fcntl(int var1, int var2, int var3);

        public int setspeed(int var1, Termios var2, int var3);

        public int cfgetispeed(Termios var1);

        public int cfgetospeed(Termios var1);

        public int cfsetispeed(Termios var1, int var2);

        public int cfsetospeed(Termios var1, int var2);

        public int tcflush(int var1, int var2);

        public int tcdrain(int var1);

        public void cfmakeraw(Termios var1);

        public int tcgetattr(int var1, Termios var2);

        public int tcsetattr(int var1, int var2, Termios var3);

        public int tcsendbreak(int var1, int var2);

        public int open(String var1, int var2);

        public int close(int var1);

        public int write(int var1, byte[] var2, int var3);

        public int read(int var1, byte[] var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int select(int var1, FDSet var2, FDSet var3, FDSet var4, TimeVal var5);

        public int poll(Pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public void perror(String var1);

        public FDSet newFDSet();

        public void FD_SET(int var1, FDSet var2);

        public void FD_CLR(int var1, FDSet var2);

        public boolean FD_ISSET(int var1, FDSet var2);

        public void FD_ZERO(FDSet var1);

        public List<String> getPortList();

        public String getPortNamePattern();
    }
}

