/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    public static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;
    private static final int RADIXSORT_NO_REC = 1024;
    private static final int RADIXSORT_NO_REC_SMALL = 64;
    private static final int PARALLEL_RADIXSORT_NO_FORK = 1024;
    static final int RADIX_SORT_MIN_THRESHOLD = 2000;
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new ArrayHashStrategy();

    private IntArrays() {
    }

    public static int[] forceCapacity(int[] array, int length, int preserve) {
        int[] t = new int[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static int[] ensureCapacity(int[] array, int length) {
        return IntArrays.ensureCapacity(array, length, array.length);
    }

    public static int[] ensureCapacity(int[] array, int length, int preserve) {
        return length > array.length ? IntArrays.forceCapacity(array, length, preserve) : array;
    }

    public static int[] grow(int[] array, int length) {
        return IntArrays.grow(array, length, array.length);
    }

    public static int[] grow(int[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min((long)array.length + (long)(array.length >> 1), 0x7FFFFFF7L), (long)length);
            int[] t = new int[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static int[] trim(int[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        int[] t = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static int[] setLength(int[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return IntArrays.trim(array, length);
        }
        return IntArrays.ensureCapacity(array, length);
    }

    public static int[] copy(int[] array, int offset, int length) {
        IntArrays.ensureOffsetLength(array, offset, length);
        int[] a2 = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static int[] copy(int[] array) {
        return (int[])array.clone();
    }

    @Deprecated
    public static void fill(int[] array, int value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    @Deprecated
    public static void fill(int[] array, int from, int to, int value) {
        IntArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(int[] a1, int[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(int[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(int[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    public static void ensureSameLength(int[] a2, int[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a2.length + " != " + b2.length);
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    public static void swap(int[] x, int a2, int b2) {
        int t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(int[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            IntArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(int[] x, int a2, int b2, int c, IntComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(int[] a2, int from, int to, IntComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            int u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(int[] a2, int from, int to, IntComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            int t = a2[i2];
            int j = i2;
            int u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(int[] x, int from, int to, IntComparator comp) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            IntArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = IntArrays.med3(x, m - s, m, m + s, comp);
            n = IntArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = IntArrays.med3(x, l, m, n, comp);
        int v = x[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            IntArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static void quickSort(int[] x, IntComparator comp) {
        IntArrays.quickSort(x, 0, x.length, comp);
    }

    public static void parallelQuickSort(int[] x, int from, int to, IntComparator comp) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            IntArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(int[] x, IntComparator comp) {
        IntArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static int med3(int[] x, int a2, int b2, int c) {
        int ab = Integer.compare(x[a2], x[b2]);
        int ac = Integer.compare(x[a2], x[c]);
        int bc = Integer.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(int[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a2[j] >= a2[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            int u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(int[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = a2[i2];
            int j = i2;
            int u = a2[j - 1];
            while (t < u) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(int[] x, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            IntArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s);
            m = IntArrays.med3(x, m - s, m, m + s);
            n = IntArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = IntArrays.med3(x, l, m, n);
        int v = x[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Integer.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Integer.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            IntArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, to - s, to);
        }
    }

    public static void quickSort(int[] x) {
        IntArrays.quickSort(x, 0, x.length);
    }

    public static void parallelQuickSort(int[] x, int from, int to) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            IntArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(int[] x) {
        IntArrays.parallelQuickSort(x, 0, x.length);
    }

    private static int med3Indirect(int[] perm, int[] x, int a2, int b2, int c) {
        int aa = x[perm[a2]];
        int bb = x[perm[b2]];
        int cc = x[perm[c]];
        int ab = Integer.compare(aa, bb);
        int ac = Integer.compare(aa, cc);
        int bc = Integer.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void insertionSortIndirect(int[] perm, int[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (a2[t] < a2[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void quickSortIndirect(int[] perm, int[] x, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            IntArrays.insertionSortIndirect(perm, x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3Indirect(perm, x, l, l + s, l + 2 * s);
            m = IntArrays.med3Indirect(perm, x, m - s, m, m + s);
            n = IntArrays.med3Indirect(perm, x, n - 2 * s, n - s, n);
        }
        m = IntArrays.med3Indirect(perm, x, l, m, n);
        int v = x[perm[m]];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Integer.compare(x[perm[b2]], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Integer.compare(x[perm[c]], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(perm, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(perm, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(perm, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            IntArrays.quickSortIndirect(perm, x, from, from + s);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSortIndirect(perm, x, to - s, to);
        }
    }

    public static void quickSortIndirect(int[] perm, int[] x) {
        IntArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static void parallelQuickSortIndirect(int[] perm, int[] x, int from, int to) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            IntArrays.quickSortIndirect(perm, x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSortIndirect(perm, x, from, to));
        }
    }

    public static void parallelQuickSortIndirect(int[] perm, int[] x) {
        IntArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static void stabilize(int[] perm, int[] x, int from, int to) {
        int curr = from;
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (x[perm[i2]] == x[perm[curr]]) continue;
            if (i2 - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i2);
            }
            curr = i2;
        }
        if (to - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to);
        }
    }

    public static void stabilize(int[] perm, int[] x) {
        IntArrays.stabilize(perm, x, 0, perm.length);
    }

    private static int med3(int[] x, int[] y, int a2, int b2, int c) {
        int bc;
        int t = Integer.compare(x[a2], x[b2]);
        int ab = t == 0 ? Integer.compare(y[a2], y[b2]) : t;
        t = Integer.compare(x[a2], x[c]);
        int ac = t == 0 ? Integer.compare(y[a2], y[c]) : t;
        t = Integer.compare(x[b2], x[c]);
        int n = bc = t == 0 ? Integer.compare(y[b2], y[c]) : t;
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void swap(int[] x, int[] y, int a2, int b2) {
        int t = x[a2];
        int u = y[a2];
        x[a2] = x[b2];
        y[a2] = y[b2];
        x[b2] = t;
        y[b2] = u;
    }

    private static void swap(int[] x, int[] y, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            IntArrays.swap(x, y, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static void selectionSort(int[] a2, int[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                int u = Integer.compare(a2[j], a2[m]);
                if (u >= 0 && (u != 0 || b2[j] >= b2[m])) continue;
                m = j;
            }
            if (m == i2) continue;
            int t = a2[i2];
            a2[i2] = a2[m];
            a2[m] = t;
            t = b2[i2];
            b2[i2] = b2[m];
            b2[m] = t;
        }
    }

    public static void quickSort(int[] x, int[] y, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            IntArrays.selectionSort(x, y, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, y, l, l + s, l + 2 * s);
            m = IntArrays.med3(x, y, m - s, m, m + s);
            n = IntArrays.med3(x, y, n - 2 * s, n - s, n);
        }
        m = IntArrays.med3(x, y, l, m, n);
        int v = x[m];
        int w = y[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int t;
            int comparison;
            if (b2 <= c && (comparison = (t = Integer.compare(x[b2], v)) == 0 ? Integer.compare(y[b2], w) : t) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, y, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = (t = Integer.compare(x[c], v)) == 0 ? Integer.compare(y[c], w) : t) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, y, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(x, y, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(x, y, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, y, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            IntArrays.quickSort(x, y, from, from + s);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, y, to - s, to);
        }
    }

    public static void quickSort(int[] x, int[] y) {
        IntArrays.ensureSameLength(x, y);
        IntArrays.quickSort(x, y, 0, x.length);
    }

    public static void parallelQuickSort(int[] x, int[] y, int from, int to) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            IntArrays.quickSort(x, y, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort2(x, y, from, to));
        }
    }

    public static void parallelQuickSort(int[] x, int[] y) {
        IntArrays.ensureSameLength(x, y);
        IntArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static void unstableSort(int[] a2, int from, int to) {
        if (to - from >= 2000) {
            IntArrays.radixSort(a2, from, to);
        } else {
            IntArrays.quickSort(a2, from, to);
        }
    }

    public static void unstableSort(int[] a2) {
        IntArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(int[] a2, int from, int to, IntComparator comp) {
        IntArrays.quickSort(a2, from, to, comp);
    }

    public static void unstableSort(int[] a2, IntComparator comp) {
        IntArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(int[] a2, int from, int to, int[] supp) {
        int len = to - from;
        if (len < 16) {
            IntArrays.insertionSort(a2, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, from, mid, a2);
        IntArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && supp[p2] <= supp[q2] ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(int[] a2, int from, int to) {
        IntArrays.mergeSort(a2, from, to, (int[])null);
    }

    public static void mergeSort(int[] a2) {
        IntArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(int[] a2, int from, int to, IntComparator comp, int[] supp) {
        int len = to - from;
        if (len < 16) {
            IntArrays.insertionSort(a2, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        IntArrays.mergeSort(supp, from, mid, comp, a2);
        IntArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(int[] a2, int from, int to, IntComparator comp) {
        IntArrays.mergeSort(a2, from, to, comp, null);
    }

    public static void mergeSort(int[] a2, IntComparator comp) {
        IntArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static void stableSort(int[] a2, int from, int to) {
        IntArrays.unstableSort(a2, from, to);
    }

    public static void stableSort(int[] a2) {
        IntArrays.stableSort(a2, 0, a2.length);
    }

    public static void stableSort(int[] a2, int from, int to, IntComparator comp) {
        IntArrays.mergeSort(a2, from, to, comp);
    }

    public static void stableSort(int[] a2, IntComparator comp) {
        IntArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(int[] a2, int from, int to, int key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            int midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(int[] a2, int key) {
        return IntArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(int[] a2, int from, int to, int key, IntComparator c) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            int midVal = a2[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(int[] a2, int key, IntComparator c) {
        return IntArrays.binarySearch(a2, 0, a2.length, key, c);
    }

    public static void radixSort(int[] a2) {
        IntArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(int[] a2, int from, int to) {
        if (to - from < 1024) {
            IntArrays.quickSort(a2, from, to);
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = a2[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = a2[i4];
                c = t >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        int z = t;
                        t = a2[d];
                        a2[d] = z;
                        c = t >>> shift & 0xFF ^ signMask;
                    }
                    a2[i4] = t;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        IntArrays.quickSort(a2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(int[] a2, int from, int to) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            IntArrays.quickSort(a2, from, to);
            return;
        }
        int maxLevel = 3;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 4 == 0 ? 128 : 0;
                    int shift = (3 - level % 4) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = a2[i3] >>> shift & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p2 = first2;
                    for (int i4 = 0; i4 < 256; ++i4) {
                        if (count2[i4] != 0) {
                            lastUsed = i4;
                        }
                        pos[i4] = p2 += count2[i4];
                    }
                    int end = first2 + length - count2[lastUsed];
                    int c = -1;
                    for (int i5 = first2; i5 <= end; i5 += count2[c]) {
                        int t = a2[i5];
                        c = t >>> shift & 0xFF ^ signMask;
                        if (i5 < end) {
                            while (true) {
                                int n = c;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i5) break;
                                int z = t;
                                t = a2[d];
                                a2[d] = z;
                                c = t >>> shift & 0xFF ^ signMask;
                            }
                            a2[i5] = t;
                        }
                        if (level < 3 && count2[c] > 1) {
                            if (count2[c] < 1024) {
                                IntArrays.quickSort(a2, i5, i5 + count2[c]);
                            } else {
                                queueSize.incrementAndGet();
                                queue.add(new Segment(i5, count2[c], level + 1));
                            }
                        }
                        count2[c] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(int[] a2) {
        IntArrays.parallelRadixSort(a2, 0, a2.length);
    }

    public static void radixSortIndirect(int[] perm, int[] a2, boolean stable) {
        IntArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, int[] a2, int from, int to, boolean stable) {
        int[] support;
        if (to - from < 1024) {
            IntArrays.quickSortIndirect(perm, a2, from, to);
            if (stable) {
                IntArrays.stabilize(perm, a2, from, to);
            }
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i2;
            int p2;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i3 = first2 + length;
            while (i3-- != first2) {
                int n = a2[perm[i3]] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p2 = stable ? 0 : first2;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p2 += count2[i2];
            }
            if (stable) {
                i2 = first2 + length;
                while (i2-- != first2) {
                    int n2 = a2[perm[i2]] >>> shift & 0xFF ^ signMask;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i2];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p2 = first2;
                for (i2 = 0; i2 <= lastUsed; ++i2) {
                    if (level < 3 && count2[i2] > 1) {
                        if (count2[i2] < 1024) {
                            IntArrays.quickSortIndirect(perm, a2, p2, p2 + count2[i2]);
                            if (stable) {
                                IntArrays.stabilize(perm, a2, p2, p2 + count2[i2]);
                            }
                        } else {
                            offsetStack[stackPos] = p2;
                            lengthStack[stackPos] = count2[i2];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p2 += count2[i2];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = perm[i4];
                c = a2[t] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i4) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c = a2[t] >>> shift & 0xFF ^ signMask;
                    }
                    perm[i4] = t;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        IntArrays.quickSortIndirect(perm, a2, i4, i4 + count2[c]);
                        if (stable) {
                            IntArrays.stabilize(perm, a2, i4, i4 + count2[c]);
                        }
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, int[] a2, int from, int to, boolean stable) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            IntArrays.radixSortIndirect(perm, a2, from, to, stable);
            return;
        }
        int maxLevel = 3;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int[] support = stable ? new int[perm.length] : null;
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    int i2;
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i3 = numberOfThreads;
                        while (i3-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 4 == 0 ? 128 : 0;
                    int shift = (3 - level % 4) * 8;
                    int i4 = first2 + length;
                    while (i4-- != first2) {
                        int n = a2[perm[i4]] >>> shift & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p2 = first2;
                    for (i2 = 0; i2 < 256; ++i2) {
                        if (count2[i2] != 0) {
                            lastUsed = i2;
                        }
                        pos[i2] = p2 += count2[i2];
                    }
                    if (stable) {
                        i2 = first2 + length;
                        while (i2-- != first2) {
                            int n = a2[perm[i2]] >>> shift & 0xFF ^ signMask;
                            int n2 = pos[n] - 1;
                            pos[n] = n2;
                            support[n2] = perm[i2];
                        }
                        System.arraycopy(support, first2, perm, first2, length);
                        p2 = first2;
                        for (i2 = 0; i2 <= lastUsed; ++i2) {
                            if (level < 3 && count2[i2] > 1) {
                                if (count2[i2] < 1024) {
                                    IntArrays.radixSortIndirect(perm, a2, p2, p2 + count2[i2], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(p2, count2[i2], level + 1));
                                }
                            }
                            p2 += count2[i2];
                        }
                        java.util.Arrays.fill(count2, 0);
                    } else {
                        int end = first2 + length - count2[lastUsed];
                        int c = -1;
                        for (int i5 = first2; i5 <= end; i5 += count2[c]) {
                            int t = perm[i5];
                            c = a2[t] >>> shift & 0xFF ^ signMask;
                            if (i5 < end) {
                                while (true) {
                                    int n = c;
                                    int n3 = pos[n] - 1;
                                    pos[n] = n3;
                                    int d = n3;
                                    if (n3 <= i5) break;
                                    int z = t;
                                    t = perm[d];
                                    perm[d] = z;
                                    c = a2[t] >>> shift & 0xFF ^ signMask;
                                }
                                perm[i5] = t;
                            }
                            if (level < 3 && count2[c] > 1) {
                                if (count2[c] < 1024) {
                                    IntArrays.radixSortIndirect(perm, a2, i5, i5 + count2[c], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(i5, count2[c], level + 1));
                                }
                            }
                            count2[c] = 0;
                        }
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, int[] a2, boolean stable) {
        IntArrays.parallelRadixSortIndirect(perm, a2, 0, a2.length, stable);
    }

    public static void radixSort(int[] a2, int[] b2) {
        IntArrays.ensureSameLength(a2, b2);
        IntArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(int[] a2, int[] b2, int from, int to) {
        if (to - from < 1024) {
            IntArrays.quickSort(a2, b2, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int[] k = level < 4 ? a2 : b2;
            int shift = (3 - level % 4) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = k[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = a2[i4];
                int u = b2[i4];
                c = k[i4] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        c = k[d] >>> shift & 0xFF ^ signMask;
                        int z = t;
                        t = a2[d];
                        a2[d] = z;
                        z = u;
                        u = b2[d];
                        b2[d] = z;
                    }
                    a2[i4] = t;
                    b2[i4] = u;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        IntArrays.quickSort(a2, b2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(int[] a2, int[] b2, int from, int to) {
        ForkJoinPool pool = IntArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            IntArrays.quickSort(a2, b2, from, to);
            return;
        }
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 4 == 0 ? 128 : 0;
                    int[] k = level < 4 ? a2 : b2;
                    int shift = (3 - level % 4) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = k[i3] >>> shift & 0xFF ^ signMask;
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p2 = first2;
                    for (int i4 = 0; i4 < 256; ++i4) {
                        if (count2[i4] != 0) {
                            lastUsed = i4;
                        }
                        pos[i4] = p2 += count2[i4];
                    }
                    int end = first2 + length - count2[lastUsed];
                    int c = -1;
                    for (int i5 = first2; i5 <= end; i5 += count2[c]) {
                        int t = a2[i5];
                        int u = b2[i5];
                        c = k[i5] >>> shift & 0xFF ^ signMask;
                        if (i5 < end) {
                            while (true) {
                                int n = c;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i5) break;
                                c = k[d] >>> shift & 0xFF ^ signMask;
                                int z = t;
                                int w = u;
                                t = a2[d];
                                u = b2[d];
                                a2[d] = z;
                                b2[d] = w;
                            }
                            a2[i5] = t;
                            b2[i5] = u;
                        }
                        if (level < 7 && count2[c] > 1) {
                            if (count2[c] < 1024) {
                                IntArrays.quickSort(a2, b2, i5, i5 + count2[c]);
                            } else {
                                queueSize.incrementAndGet();
                                queue.add(new Segment(i5, count2[c], level + 1));
                            }
                        }
                        count2[c] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(int[] a2, int[] b2) {
        IntArrays.ensureSameLength(a2, b2);
        IntArrays.parallelRadixSort(a2, b2, 0, a2.length);
    }

    private static void insertionSortIndirect(int[] perm, int[] a2, int[] b2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (a2[t] < a2[u] || a2[t] == a2[u] && b2[t] < b2[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, int[] a2, int[] b2, boolean stable) {
        IntArrays.ensureSameLength(a2, b2);
        IntArrays.radixSortIndirect(perm, a2, b2, 0, a2.length, stable);
    }

    public static void radixSortIndirect(int[] perm, int[] a2, int[] b2, int from, int to, boolean stable) {
        int[] support;
        if (to - from < 64) {
            IntArrays.insertionSortIndirect(perm, a2, b2, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i2;
            int p2;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int[] k = level < 4 ? a2 : b2;
            int shift = (3 - level % 4) * 8;
            int i3 = first2 + length;
            while (i3-- != first2) {
                int n = k[perm[i3]] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p2 = stable ? 0 : first2;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p2 += count2[i2];
            }
            if (stable) {
                i2 = first2 + length;
                while (i2-- != first2) {
                    int n2 = k[perm[i2]] >>> shift & 0xFF ^ signMask;
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i2];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p2 = first2;
                for (i2 = 0; i2 < 256; ++i2) {
                    if (level < 7 && count2[i2] > 1) {
                        if (count2[i2] < 64) {
                            IntArrays.insertionSortIndirect(perm, a2, b2, p2, p2 + count2[i2]);
                        } else {
                            offsetStack[stackPos] = p2;
                            lengthStack[stackPos] = count2[i2];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p2 += count2[i2];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = perm[i4];
                c = k[t] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i4) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c = k[t] >>> shift & 0xFF ^ signMask;
                    }
                    perm[i4] = t;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 64) {
                        IntArrays.insertionSortIndirect(perm, a2, b2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(int[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 4;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            block1: for (int j = i2 + 1; j < to; ++j) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j] < a2[p2][m]) {
                        m = j;
                        continue block1;
                    }
                    if (a2[p2][j] > a2[p2][m]) continue block1;
                }
            }
            if (m == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                int u = a2[p3][i2];
                a2[p3][i2] = a2[p3][m];
                a2[p3][m] = u;
            }
        }
    }

    public static void radixSort(int[][] a2) {
        IntArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(int[][] a2, int from, int to) {
        if (to - from < 64) {
            IntArrays.selectionSort(a2, from, to, 0);
            return;
        }
        int layers = a2.length;
        int maxLevel = 4 * layers - 1;
        int p2 = layers;
        int l = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 4 - 1) + 1;
        int stackPos = 0;
        int[] offsetStack = new int[stackSize];
        int[] lengthStack = new int[stackSize];
        int[] levelStack = new int[stackSize];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] t = new int[layers];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int[] k = a2[level / 4];
            int shift = (3 - level % 4) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = k[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p3 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p3 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t[p4] = a2[p4][i4];
                }
                c = k[i4] >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    block6: while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        c = k[d] >>> shift & 0xFF ^ signMask;
                        p4 = layers;
                        while (true) {
                            if (p4-- == 0) continue block6;
                            int u = t[p4];
                            t[p4] = a2[p4][d];
                            a2[p4][d] = u;
                        }
                        break;
                    }
                    p4 = layers;
                    while (p4-- != 0) {
                        a2[p4][i4] = t[p4];
                    }
                }
                if (level < maxLevel && count2[c] > 1) {
                    if (count2[c] < 64) {
                        IntArrays.selectionSort(a2, i4, i4 + count2[c], level + 1);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static int[] shuffle(int[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            int t = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t;
        }
        return a2;
    }

    public static int[] shuffle(int[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            int t = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t;
        }
        return a2;
    }

    public static int[] reverse(int[] a2) {
        int length = a2.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            int t = a2[length - i2 - 1];
            a2[length - i2 - 1] = a2[i2];
            a2[i2] = t;
        }
        return a2;
    }

    public static int[] reverse(int[] a2, int from, int to) {
        int length = to - from;
        int i2 = length / 2;
        while (i2-- != 0) {
            int t = a2[from + length - i2 - 1];
            a2[from + length - i2 - 1] = a2[from + i2];
            a2[from + i2] = t;
        }
        return a2;
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] x;
        private final IntComparator comp;

        public ForkJoinQuickSortComp(int[] x, int from, int to, IntComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            int[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                IntArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s, this.comp);
            m = IntArrays.med3(x, m - s, m, m + s, this.comp);
            n = IntArrays.med3(x, n - 2 * s, n - s, n, this.comp);
            m = IntArrays.med3(x, l, m, n, this.comp);
            int v = x[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = this.comp.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = this.comp.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                IntArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] x;

        public ForkJoinQuickSort(int[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            int[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                IntArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s);
            m = IntArrays.med3(x, m - s, m, m + s);
            n = IntArrays.med3(x, n - 2 * s, n - s, n);
            m = IntArrays.med3(x, l, m, n);
            int v = x[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Integer.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Integer.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                IntArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final int[] x;

        public ForkJoinQuickSortIndirect(int[] perm, int[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            int[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                IntArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = IntArrays.med3Indirect(this.perm, x, l, l + s, l + 2 * s);
            m = IntArrays.med3Indirect(this.perm, x, m - s, m, m + s);
            n = IntArrays.med3Indirect(this.perm, x, n - 2 * s, n - s, n);
            m = IntArrays.med3Indirect(this.perm, x, l, m, n);
            int v = x[this.perm[m]];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Integer.compare(x[this.perm[b2]], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Integer.compare(x[this.perm[c]], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                IntArrays.swap(this.perm, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(this.perm, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(this.perm, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s), new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort2
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] x;
        private final int[] y;

        public ForkJoinQuickSort2(int[] x, int[] y, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            int[] x = this.x;
            int[] y = this.y;
            int len = this.to - this.from;
            if (len < 8192) {
                IntArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = IntArrays.med3(x, y, l, l + s, l + 2 * s);
            m = IntArrays.med3(x, y, m - s, m, m + s);
            n = IntArrays.med3(x, y, n - 2 * s, n - s, n);
            m = IntArrays.med3(x, y, l, m, n);
            int v = x[m];
            int w = y[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int t;
                int comparison;
                if (b2 <= c && (comparison = (t = Integer.compare(x[b2], v)) == 0 ? Integer.compare(y[b2], w) : t) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(x, y, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = (t = Integer.compare(x[c], v)) == 0 ? Integer.compare(y[c], w) : t) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(x, y, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                IntArrays.swap(x, y, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(x, y, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(x, y, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s), new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<int[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(int[] a2, int[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

