/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractInt2IntMap;
import it.unimi.dsi.fastutil.ints.AbstractInt2IntSortedMap;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntSortedMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class Int2IntRBTreeMap
extends AbstractInt2IntSortedMap
implements Serializable,
Cloneable {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected transient ObjectSortedSet<Int2IntMap.Entry> entries;
    protected transient IntSortedSet keys;
    protected transient IntCollection values;
    protected transient boolean modified;
    protected Comparator<? super Integer> storedComparator;
    protected transient IntComparator actualComparator;
    private static final long serialVersionUID = -7046029254386353129L;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public Int2IntRBTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = IntComparators.asIntComparator(this.storedComparator);
    }

    public Int2IntRBTreeMap(Comparator<? super Integer> c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public Int2IntRBTreeMap(Map<? extends Integer, ? extends Integer> m) {
        this();
        this.putAll(m);
    }

    public Int2IntRBTreeMap(SortedMap<Integer, Integer> m) {
        this(m.comparator());
        this.putAll((Map<? extends Integer, ? extends Integer>)m);
    }

    public Int2IntRBTreeMap(Int2IntMap m) {
        this();
        this.putAll(m);
    }

    public Int2IntRBTreeMap(Int2IntSortedMap m) {
        this(m.comparator());
        this.putAll(m);
    }

    public Int2IntRBTreeMap(int[] k, int[] v, Comparator<? super Integer> c) {
        this(c);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i2 = 0; i2 < k.length; ++i2) {
            this.put(k[i2], v[i2]);
        }
    }

    public Int2IntRBTreeMap(int[] k, int[] v) {
        this(k, v, null);
    }

    final int compare(int k1, int k2) {
        return this.actualComparator == null ? Integer.compare(k1, k2) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(int k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(int k) {
        Entry e = this.tree;
        Entry last2 = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last2 = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last2;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    public int addTo(int k, int incr) {
        Entry e = this.add(k);
        int oldValue = e.value;
        e.value += incr;
        return oldValue;
    }

    @Override
    public int put(int k, int v) {
        Entry e = this.add(k);
        int oldValue = e.value;
        e.value = v;
        return oldValue;
    }

    private Entry add(int k) {
        Entry e;
        this.modified = false;
        int maxDepth = 0;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k, this.defRetValue);
            this.tree = this.firstEntry;
            e = this.firstEntry;
        } else {
            Entry p2 = this.tree;
            int i2 = 0;
            while (true) {
                int cmp;
                if ((cmp = this.compare(k, p2.key)) == 0) {
                    while (i2-- != 0) {
                        this.nodePath[i2] = null;
                    }
                    return p2;
                }
                this.nodePath[i2] = p2;
                this.dirPath[i2++] = cmp > 0;
                if (this.dirPath[i2++]) {
                    if (p2.succ()) {
                        ++this.count;
                        e = new Entry(k, this.defRetValue);
                        if (p2.right == null) {
                            this.lastEntry = e;
                        }
                        e.left = p2;
                        e.right = p2.right;
                        p2.right(e);
                        break;
                    }
                    p2 = p2.right;
                    continue;
                }
                if (p2.pred()) {
                    ++this.count;
                    e = new Entry(k, this.defRetValue);
                    if (p2.left == null) {
                        this.firstEntry = e;
                    }
                    e.right = p2;
                    e.left = p2.left;
                    p2.left(e);
                    break;
                }
                p2 = p2.left;
            }
            this.modified = true;
            maxDepth = i2--;
            while (i2 > 0 && !this.nodePath[i2].black()) {
                Entry x;
                Entry y;
                if (!this.dirPath[i2 - 1]) {
                    y = this.nodePath[i2 - 1].right;
                    if (!this.nodePath[i2 - 1].succ() && !y.black()) {
                        this.nodePath[i2].black(true);
                        y.black(true);
                        this.nodePath[i2 - 1].black(false);
                        i2 -= 2;
                        continue;
                    }
                    if (!this.dirPath[i2]) {
                        y = this.nodePath[i2];
                    } else {
                        x = this.nodePath[i2];
                        y = x.right;
                        x.right = y.left;
                        y.left = x;
                        this.nodePath[i2 - 1].left = y;
                        if (y.pred()) {
                            y.pred(false);
                            x.succ(y);
                        }
                    }
                    x = this.nodePath[i2 - 1];
                    x.black(false);
                    y.black(true);
                    x.left = y.right;
                    y.right = x;
                    if (i2 < 2) {
                        this.tree = y;
                    } else if (this.dirPath[i2 - 2]) {
                        this.nodePath[i2 - 2].right = y;
                    } else {
                        this.nodePath[i2 - 2].left = y;
                    }
                    if (!y.succ()) break;
                    y.succ(false);
                    x.pred(y);
                    break;
                }
                y = this.nodePath[i2 - 1].left;
                if (!this.nodePath[i2 - 1].pred() && !y.black()) {
                    this.nodePath[i2].black(true);
                    y.black(true);
                    this.nodePath[i2 - 1].black(false);
                    i2 -= 2;
                    continue;
                }
                if (this.dirPath[i2]) {
                    y = this.nodePath[i2];
                } else {
                    x = this.nodePath[i2];
                    y = x.left;
                    x.left = y.right;
                    y.right = x;
                    this.nodePath[i2 - 1].right = y;
                    if (y.succ()) {
                        y.succ(false);
                        x.pred(y);
                    }
                }
                x = this.nodePath[i2 - 1];
                x.black(false);
                y.black(true);
                x.right = y.left;
                y.left = x;
                if (i2 < 2) {
                    this.tree = y;
                } else if (this.dirPath[i2 - 2]) {
                    this.nodePath[i2 - 2].right = y;
                } else {
                    this.nodePath[i2 - 2].left = y;
                }
                if (!y.pred()) break;
                y.pred(false);
                x.succ(y);
                break;
            }
        }
        this.tree.black(true);
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return e;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int remove(int k) {
        int i2;
        Entry p2;
        block68: {
            Entry s;
            int j;
            boolean color;
            block74: {
                block69: {
                    Entry r;
                    block73: {
                        block71: {
                            block72: {
                                block66: {
                                    block67: {
                                        this.modified = false;
                                        if (this.tree == null) {
                                            return this.defRetValue;
                                        }
                                        p2 = this.tree;
                                        i2 = 0;
                                        int kk = k;
                                        while (true) {
                                            int cmp;
                                            if ((cmp = this.compare(kk, p2.key)) == 0) {
                                                if (p2.left != null) break block66;
                                                break block67;
                                            }
                                            this.dirPath[i2] = cmp > 0;
                                            this.nodePath[i2] = p2;
                                            if (this.dirPath[i2++]) {
                                                if ((p2 = p2.right()) != null) continue;
                                                while (true) {
                                                    if (i2-- == 0) {
                                                        return this.defRetValue;
                                                    }
                                                    this.nodePath[i2] = null;
                                                }
                                            }
                                            if ((p2 = p2.left()) == null) break;
                                        }
                                        while (true) {
                                            if (i2-- == 0) {
                                                return this.defRetValue;
                                            }
                                            this.nodePath[i2] = null;
                                        }
                                    }
                                    this.firstEntry = p2.next();
                                }
                                if (p2.right == null) {
                                    this.lastEntry = p2.prev();
                                }
                                if (!p2.succ()) break block71;
                                if (!p2.pred()) break block72;
                                if (i2 == 0) {
                                    this.tree = p2.left;
                                    break block68;
                                } else if (this.dirPath[i2 - 1]) {
                                    this.nodePath[i2 - 1].succ(p2.right);
                                    break block68;
                                } else {
                                    this.nodePath[i2 - 1].pred(p2.left);
                                }
                                break block68;
                            }
                            p2.prev().right = p2.right;
                            if (i2 == 0) {
                                this.tree = p2.left;
                                break block68;
                            } else if (this.dirPath[i2 - 1]) {
                                this.nodePath[i2 - 1].right = p2.left;
                                break block68;
                            } else {
                                this.nodePath[i2 - 1].left = p2.left;
                            }
                            break block68;
                        }
                        r = p2.right;
                        if (!r.pred()) break block73;
                        r.left = p2.left;
                        r.pred(p2.pred());
                        if (!r.pred()) {
                            r.prev().right = r;
                        }
                        if (i2 == 0) {
                            this.tree = r;
                        } else if (this.dirPath[i2 - 1]) {
                            this.nodePath[i2 - 1].right = r;
                        } else {
                            this.nodePath[i2 - 1].left = r;
                        }
                        color = r.black();
                        r.black(p2.black());
                        p2.black(color);
                        this.dirPath[i2] = true;
                        this.nodePath[i2++] = r;
                        break block68;
                    }
                    j = i2++;
                    while (true) {
                        this.dirPath[i2] = false;
                        this.nodePath[i2++] = r;
                        s = r.left;
                        if (s.pred()) {
                            this.dirPath[j] = true;
                            this.nodePath[j] = s;
                            if (s.succ()) {
                                break;
                            }
                            break block69;
                        }
                        r = s;
                    }
                    r.pred(s);
                    break block74;
                }
                r.left = s.right;
            }
            s.left = p2.left;
            if (!p2.pred()) {
                p2.prev().right = s;
                s.pred(false);
            }
            s.right(p2.right);
            color = s.black();
            s.black(p2.black());
            p2.black(color);
            if (j == 0) {
                this.tree = s;
            } else if (this.dirPath[j - 1]) {
                this.nodePath[j - 1].right = s;
            } else {
                this.nodePath[j - 1].left = s;
            }
        }
        int maxDepth = i2;
        if (p2.black()) {
            while (i2 > 0) {
                block70: {
                    Entry y;
                    Entry w;
                    if (this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].succ() || !this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].pred()) {
                        Entry x;
                        Entry entry = x = this.dirPath[i2 - 1] ? this.nodePath[i2 - 1].right : this.nodePath[i2 - 1].left;
                        if (!x.black()) {
                            x.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[i2 - 1]) {
                        w = this.nodePath[i2 - 1].right;
                        if (!w.black()) {
                            w.black(true);
                            this.nodePath[i2 - 1].black(false);
                            this.nodePath[i2 - 1].right = w.left;
                            w.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w;
                            } else {
                                this.nodePath[i2 - 2].left = w;
                            }
                            this.nodePath[i2] = this.nodePath[i2 - 1];
                            this.dirPath[i2] = false;
                            this.nodePath[i2 - 1] = w;
                            if (maxDepth == i2++) {
                                ++maxDepth;
                            }
                            w = this.nodePath[i2 - 1].right;
                        }
                        if ((w.pred() || w.left.black()) && (w.succ() || w.right.black())) {
                            w.black(false);
                            break block70;
                        } else {
                            if (w.succ() || w.right.black()) {
                                y = w.left;
                                y.black(true);
                                w.black(false);
                                w.left = y.right;
                                y.right = w;
                                w = this.nodePath[i2 - 1].right = y;
                                if (w.succ()) {
                                    w.succ(false);
                                    w.right.pred(w);
                                }
                            }
                            w.black(this.nodePath[i2 - 1].black());
                            this.nodePath[i2 - 1].black(true);
                            w.right.black(true);
                            this.nodePath[i2 - 1].right = w.left;
                            w.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w;
                            } else {
                                this.nodePath[i2 - 2].left = w;
                            }
                            if (!w.pred()) break;
                            w.pred(false);
                            this.nodePath[i2 - 1].succ(w);
                            break;
                        }
                    }
                    w = this.nodePath[i2 - 1].left;
                    if (!w.black()) {
                        w.black(true);
                        this.nodePath[i2 - 1].black(false);
                        this.nodePath[i2 - 1].left = w.right;
                        w.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w;
                        } else {
                            this.nodePath[i2 - 2].left = w;
                        }
                        this.nodePath[i2] = this.nodePath[i2 - 1];
                        this.dirPath[i2] = true;
                        this.nodePath[i2 - 1] = w;
                        if (maxDepth == i2++) {
                            ++maxDepth;
                        }
                        w = this.nodePath[i2 - 1].left;
                    }
                    if ((w.pred() || w.left.black()) && (w.succ() || w.right.black())) {
                        w.black(false);
                    } else {
                        if (w.pred() || w.left.black()) {
                            y = w.right;
                            y.black(true);
                            w.black(false);
                            w.right = y.left;
                            y.left = w;
                            w = this.nodePath[i2 - 1].left = y;
                            if (w.pred()) {
                                w.pred(false);
                                w.left.succ(w);
                            }
                        }
                        w.black(this.nodePath[i2 - 1].black());
                        this.nodePath[i2 - 1].black(true);
                        w.left.black(true);
                        this.nodePath[i2 - 1].left = w.right;
                        w.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w;
                        } else {
                            this.nodePath[i2 - 2].left = w;
                        }
                        if (!w.succ()) break;
                        w.succ(false);
                        this.nodePath[i2 - 1].pred(w);
                        break;
                    }
                }
                --i2;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        this.modified = true;
        --this.count;
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return p2.value;
    }

    @Override
    public boolean containsValue(int v) {
        ValueIterator i2 = new ValueIterator();
        int j = this.count;
        while (j-- != 0) {
            int ev = i2.nextInt();
            if (ev != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    @Override
    public boolean containsKey(int k) {
        return this.findKey(k) != null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int get(int k) {
        Entry e = this.findKey(k);
        return e == null ? this.defRetValue : e.value;
    }

    @Override
    public int firstIntKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    @Override
    public int lastIntKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    @Override
    public ObjectSortedSet<Int2IntMap.Entry> int2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Int2IntMap.Entry>(){
                final Comparator<? super Int2IntMap.Entry> comparator;
                {
                    this.comparator = Int2IntRBTreeMap.this.actualComparator == null ? (x, y) -> Integer.compare(x.getIntKey(), y.getIntKey()) : (x, y) -> Int2IntRBTreeMap.this.actualComparator.compare(x.getIntKey(), y.getIntKey());
                }

                @Override
                public Comparator<? super Int2IntMap.Entry> comparator() {
                    return this.comparator;
                }

                @Override
                public ObjectBidirectionalIterator<Int2IntMap.Entry> iterator() {
                    return new EntryIterator();
                }

                @Override
                public ObjectBidirectionalIterator<Int2IntMap.Entry> iterator(Int2IntMap.Entry from) {
                    return new EntryIterator(from.getIntKey());
                }

                @Override
                public boolean contains(Object o) {
                    if (o == null || !(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    if (e.getKey() == null) {
                        return false;
                    }
                    if (!(e.getKey() instanceof Integer)) {
                        return false;
                    }
                    if (e.getValue() == null || !(e.getValue() instanceof Integer)) {
                        return false;
                    }
                    Entry f = Int2IntRBTreeMap.this.findKey((Integer)e.getKey());
                    return e.equals(f);
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    if (e.getKey() == null) {
                        return false;
                    }
                    if (!(e.getKey() instanceof Integer)) {
                        return false;
                    }
                    if (e.getValue() == null || !(e.getValue() instanceof Integer)) {
                        return false;
                    }
                    Entry f = Int2IntRBTreeMap.this.findKey((Integer)e.getKey());
                    if (f == null || f.getIntValue() != ((Integer)e.getValue()).intValue()) {
                        return false;
                    }
                    Int2IntRBTreeMap.this.remove(f.key);
                    return true;
                }

                @Override
                public int size() {
                    return Int2IntRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Int2IntRBTreeMap.this.clear();
                }

                @Override
                public Int2IntMap.Entry first() {
                    return Int2IntRBTreeMap.this.firstEntry;
                }

                @Override
                public Int2IntMap.Entry last() {
                    return Int2IntRBTreeMap.this.lastEntry;
                }

                @Override
                public ObjectSortedSet<Int2IntMap.Entry> subSet(Int2IntMap.Entry from, Int2IntMap.Entry to) {
                    return Int2IntRBTreeMap.this.subMap(from.getIntKey(), to.getIntKey()).int2IntEntrySet();
                }

                @Override
                public ObjectSortedSet<Int2IntMap.Entry> headSet(Int2IntMap.Entry to) {
                    return Int2IntRBTreeMap.this.headMap(to.getIntKey()).int2IntEntrySet();
                }

                @Override
                public ObjectSortedSet<Int2IntMap.Entry> tailSet(Int2IntMap.Entry from) {
                    return Int2IntRBTreeMap.this.tailMap(from.getIntKey()).int2IntEntrySet();
                }
            };
        }
        return this.entries;
    }

    @Override
    public IntSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                @Override
                public IntIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public boolean contains(int k) {
                    return Int2IntRBTreeMap.this.containsValue(k);
                }

                @Override
                public int size() {
                    return Int2IntRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Int2IntRBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public IntComparator comparator() {
        return this.actualComparator;
    }

    @Override
    public Int2IntSortedMap headMap(int to) {
        return new Submap(0, true, to, false);
    }

    @Override
    public Int2IntSortedMap tailMap(int from) {
        return new Submap(from, false, 0, true);
    }

    @Override
    public Int2IntSortedMap subMap(int from, int to) {
        return new Submap(from, false, to, false);
    }

    public Int2IntRBTreeMap clone() {
        Int2IntRBTreeMap c;
        try {
            c = (Int2IntRBTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.allocatePaths();
        if (this.count != 0) {
            Entry rp2 = new Entry();
            Entry rq = new Entry();
            Entry p2 = rp2;
            rp2.left(this.tree);
            Entry q2 = rq;
            rq.pred(null);
            while (true) {
                Entry e;
                if (!p2.pred()) {
                    e = p2.left.clone();
                    e.pred(q2.left);
                    e.succ(q2);
                    q2.left(e);
                    p2 = p2.left;
                    q2 = q2.left;
                } else {
                    while (p2.succ()) {
                        p2 = p2.right;
                        if (p2 == null) {
                            q2.right = null;
                            c.firstEntry = c.tree = rq.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        q2 = q2.right;
                    }
                    p2 = p2.right;
                    q2 = q2.right;
                }
                if (p2.succ()) continue;
                e = p2.right.clone();
                e.succ(q2.right);
                e.pred(q2);
                q2.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        EntryIterator i2 = new EntryIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            Entry e = i2.nextEntry();
            s.writeInt(e.key);
            s.writeInt(e.value);
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readInt(), s.readInt());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readInt(), s.readInt());
            top.black(true);
            top.right(new Entry(s.readInt(), s.readInt()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readInt();
        top.value = s.readInt();
        top.black(true);
        top.right(this.readTree(s, rightN, top, succ));
        if (n + 2 == (n + 2 & -(n + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private static final class Entry
    extends AbstractInt2IntMap.BasicEntry
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        Entry left;
        Entry right;
        int info;

        Entry() {
            super(0, 0);
        }

        Entry(int k, int v) {
            super(k, v);
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        @Override
        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Entry clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.value = this.value;
            c.info = this.info;
            return c;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == (Integer)e.getValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        @Override
        public String toString() {
            return this.key + "=>" + this.value;
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements IntListIterator {
        private ValueIterator() {
        }

        @Override
        public int nextInt() {
            return this.nextEntry().value;
        }

        @Override
        public int previousInt() {
            return this.previousEntry().value;
        }
    }

    private class KeySet
    extends AbstractInt2IntSortedMap.KeySet {
        private KeySet() {
        }

        @Override
        public IntBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int from) {
            return new KeyIterator(from);
        }
    }

    private final class Submap
    extends AbstractInt2IntSortedMap
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        int from;
        int to;
        boolean bottom;
        boolean top;
        protected transient ObjectSortedSet<Int2IntMap.Entry> entries;
        protected transient IntSortedSet keys;
        protected transient IntCollection values;

        public Submap(int from, boolean bottom, int to, boolean top) {
            if (!bottom && !top && Int2IntRBTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Int2IntRBTreeMap.this.defRetValue;
        }

        @Override
        public void clear() {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                i2.nextEntry();
                i2.remove();
            }
        }

        final boolean in(int k) {
            return !(!this.bottom && Int2IntRBTreeMap.this.compare(k, this.from) < 0 || !this.top && Int2IntRBTreeMap.this.compare(k, this.to) >= 0);
        }

        @Override
        public ObjectSortedSet<Int2IntMap.Entry> int2IntEntrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSortedSet<Int2IntMap.Entry>(){

                    @Override
                    public ObjectBidirectionalIterator<Int2IntMap.Entry> iterator() {
                        return new SubmapEntryIterator();
                    }

                    @Override
                    public ObjectBidirectionalIterator<Int2IntMap.Entry> iterator(Int2IntMap.Entry from) {
                        return new SubmapEntryIterator(from.getIntKey());
                    }

                    @Override
                    public Comparator<? super Int2IntMap.Entry> comparator() {
                        return Int2IntRBTreeMap.this.int2IntEntrySet().comparator();
                    }

                    @Override
                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        if (e.getKey() == null || !(e.getKey() instanceof Integer)) {
                            return false;
                        }
                        if (e.getValue() == null || !(e.getValue() instanceof Integer)) {
                            return false;
                        }
                        Entry f = Int2IntRBTreeMap.this.findKey((Integer)e.getKey());
                        return f != null && Submap.this.in(f.key) && e.equals(f);
                    }

                    @Override
                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        if (e.getKey() == null || !(e.getKey() instanceof Integer)) {
                            return false;
                        }
                        if (e.getValue() == null || !(e.getValue() instanceof Integer)) {
                            return false;
                        }
                        Entry f = Int2IntRBTreeMap.this.findKey((Integer)e.getKey());
                        if (f != null && Submap.this.in(f.key)) {
                            Submap.this.remove(f.key);
                        }
                        return f != null;
                    }

                    @Override
                    public int size() {
                        int c = 0;
                        ObjectIterator i2 = this.iterator();
                        while (i2.hasNext()) {
                            ++c;
                            i2.next();
                        }
                        return c;
                    }

                    @Override
                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }

                    @Override
                    public Int2IntMap.Entry first() {
                        return Submap.this.firstEntry();
                    }

                    @Override
                    public Int2IntMap.Entry last() {
                        return Submap.this.lastEntry();
                    }

                    @Override
                    public ObjectSortedSet<Int2IntMap.Entry> subSet(Int2IntMap.Entry from, Int2IntMap.Entry to) {
                        return Submap.this.subMap(from.getIntKey(), to.getIntKey()).int2IntEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Int2IntMap.Entry> headSet(Int2IntMap.Entry to) {
                        return Submap.this.headMap(to.getIntKey()).int2IntEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Int2IntMap.Entry> tailSet(Int2IntMap.Entry from) {
                        return Submap.this.tailMap(from.getIntKey()).int2IntEntrySet();
                    }
                };
            }
            return this.entries;
        }

        @Override
        public IntSortedSet keySet() {
            if (this.keys == null) {
                this.keys = new KeySet();
            }
            return this.keys;
        }

        @Override
        public IntCollection values() {
            if (this.values == null) {
                this.values = new AbstractIntCollection(){

                    @Override
                    public IntIterator iterator() {
                        return new SubmapValueIterator();
                    }

                    @Override
                    public boolean contains(int k) {
                        return Submap.this.containsValue(k);
                    }

                    @Override
                    public int size() {
                        return Submap.this.size();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        @Override
        public boolean containsKey(int k) {
            return this.in(k) && Int2IntRBTreeMap.this.containsKey(k);
        }

        @Override
        public boolean containsValue(int v) {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                int ev = i2.nextEntry().value;
                if (ev != v) continue;
                return true;
            }
            return false;
        }

        @Override
        public int get(int k) {
            Entry e;
            int kk = k;
            return this.in(kk) && (e = Int2IntRBTreeMap.this.findKey(kk)) != null ? e.value : this.defRetValue;
        }

        @Override
        public int put(int k, int v) {
            Int2IntRBTreeMap.this.modified = false;
            if (!this.in(k)) {
                throw new IllegalArgumentException("Key (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            int oldValue = Int2IntRBTreeMap.this.put(k, v);
            return Int2IntRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        @Override
        public int remove(int k) {
            Int2IntRBTreeMap.this.modified = false;
            if (!this.in(k)) {
                return this.defRetValue;
            }
            int oldValue = Int2IntRBTreeMap.this.remove(k);
            return Int2IntRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        @Override
        public int size() {
            SubmapIterator i2 = new SubmapIterator();
            int n = 0;
            while (i2.hasNext()) {
                ++n;
                i2.nextEntry();
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        @Override
        public IntComparator comparator() {
            return Int2IntRBTreeMap.this.actualComparator;
        }

        @Override
        public Int2IntSortedMap headMap(int to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Int2IntRBTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        @Override
        public Int2IntSortedMap tailMap(int from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Int2IntRBTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        @Override
        public Int2IntSortedMap subMap(int from, int to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                int n = to = Int2IntRBTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                int n = from = Int2IntRBTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (Int2IntRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = Int2IntRBTreeMap.this.firstEntry;
            } else {
                e = Int2IntRBTreeMap.this.locateKey(this.from);
                if (Int2IntRBTreeMap.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && Int2IntRBTreeMap.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (Int2IntRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = Int2IntRBTreeMap.this.lastEntry;
            } else {
                e = Int2IntRBTreeMap.this.locateKey(this.to);
                if (Int2IntRBTreeMap.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && Int2IntRBTreeMap.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        @Override
        public int firstIntKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        @Override
        public int lastIntKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(int k) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Int2IntRBTreeMap.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Int2IntRBTreeMap.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Int2IntRBTreeMap.this.locateKey(k);
                if (submap.Int2IntRBTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            @Override
            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Int2IntRBTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            @Override
            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Int2IntRBTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }

        private class KeySet
        extends AbstractInt2IntSortedMap.KeySet {
            private KeySet() {
            }

            @Override
            public IntBidirectionalIterator iterator() {
                return new SubmapKeyIterator();
            }

            @Override
            public IntBidirectionalIterator iterator(int from) {
                return new SubmapKeyIterator(from);
            }
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements IntListIterator {
            private SubmapValueIterator() {
            }

            @Override
            public int nextInt() {
                return this.nextEntry().value;
            }

            @Override
            public int previousInt() {
                return this.previousEntry().value;
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements IntListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(int from) {
                super(from);
            }

            @Override
            public int nextInt() {
                return this.nextEntry().key;
            }

            @Override
            public int previousInt() {
                return this.previousEntry().key;
            }
        }

        private class SubmapEntryIterator
        extends SubmapIterator
        implements ObjectListIterator<Int2IntMap.Entry> {
            SubmapEntryIterator() {
            }

            SubmapEntryIterator(int k) {
                super(k);
            }

            @Override
            public Int2IntMap.Entry next() {
                return this.nextEntry();
            }

            @Override
            public Int2IntMap.Entry previous() {
                return this.previousEntry();
            }
        }
    }

    private class EntryIterator
    extends TreeIterator
    implements ObjectListIterator<Int2IntMap.Entry> {
        EntryIterator() {
        }

        EntryIterator(int k) {
            super(k);
        }

        @Override
        public Int2IntMap.Entry next() {
            return this.nextEntry();
        }

        @Override
        public Int2IntMap.Entry previous() {
            return this.previousEntry();
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements IntListIterator {
        public KeyIterator() {
        }

        public KeyIterator(int k) {
            super(k);
        }

        @Override
        public int nextInt() {
            return this.nextEntry().key;
        }

        @Override
        public int previousInt() {
            return this.previousEntry().key;
        }
    }

    private class TreeIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Int2IntRBTreeMap.this.firstEntry;
        }

        TreeIterator(int k) {
            this.next = Int2IntRBTreeMap.this.locateKey(k);
            if (this.next != null) {
                if (Int2IntRBTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Int2IntRBTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }

        public int skip(int n) {
            int i2 = n;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i2 - 1;
        }

        public int back(int n) {
            int i2 = n;
            while (i2-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i2 - 1;
        }
    }
}

