/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntPredicate;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractIntCollection
extends AbstractCollection<Integer>
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public abstract IntIterator iterator();

    @Override
    public boolean add(int k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(int k) {
        IntIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextInt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(int k) {
        IntIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextInt()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Integer key) {
        return IntCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return IntCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return IntCollection.super.remove(key);
    }

    @Override
    public int[] toArray(int[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new int[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        IntIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public int[] toIntArray() {
        return this.toArray((int[])null);
    }

    @Override
    @Deprecated
    public int[] toIntArray(int[] a2) {
        return this.toArray(a2);
    }

    @Override
    public final void forEach(IntConsumer action) {
        IntCollection.super.forEach(action);
    }

    @Override
    public final boolean removeIf(IntPredicate filter2) {
        return IntCollection.super.removeIf(filter2);
    }

    @Override
    public boolean addAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c instanceof IntCollection) {
            return this.addAll((IntCollection)c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean containsAll(IntCollection c) {
        IntIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.containsAll((IntCollection)c);
        }
        return super.containsAll(c);
    }

    @Override
    public boolean removeAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.removeAll((IntCollection)c);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextInt())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.retainAll((IntCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        IntIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            int k = i2.nextInt();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

