/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.floats.FloatSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;

public class FloatArraySet
extends AbstractFloatSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient float[] a;
    private int size;

    public FloatArraySet(float[] a2) {
        this.a = a2;
        this.size = a2.length;
    }

    public FloatArraySet() {
        this.a = FloatArrays.EMPTY_ARRAY;
    }

    public FloatArraySet(int capacity) {
        this.a = new float[capacity];
    }

    public FloatArraySet(FloatCollection c) {
        this(c.size());
        this.addAll(c);
    }

    public FloatArraySet(Collection<? extends Float> c) {
        this(c.size());
        this.addAll(c);
    }

    public FloatArraySet(FloatSet c) {
        this(c.size());
        int i2 = 0;
        FloatIterator floatIterator = c.iterator();
        while (floatIterator.hasNext()) {
            float x;
            this.a[i2] = x = ((Float)floatIterator.next()).floatValue();
            ++i2;
        }
        this.size = i2;
    }

    public FloatArraySet(Set<? extends Float> c) {
        this(c.size());
        int i2 = 0;
        for (Float f : c) {
            this.a[i2] = f.floatValue();
            ++i2;
        }
        this.size = i2;
    }

    public FloatArraySet(float[] a2, int size) {
        this.a = a2;
        this.size = size;
        if (size > a2.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a2.length + ")");
        }
    }

    public static FloatArraySet of() {
        return FloatArraySet.ofUnchecked();
    }

    public static FloatArraySet of(float e) {
        return FloatArraySet.ofUnchecked(e);
    }

    public static FloatArraySet of(float ... a2) {
        if (a2.length == 2) {
            if (Float.floatToIntBits(a2[0]) == Float.floatToIntBits(a2[1])) {
                throw new IllegalArgumentException("Duplicate element: " + a2[1]);
            }
        } else if (a2.length > 2) {
            FloatOpenHashSet.of(a2);
        }
        return FloatArraySet.ofUnchecked(a2);
    }

    public static FloatArraySet ofUnchecked() {
        return new FloatArraySet();
    }

    public static FloatArraySet ofUnchecked(float ... a2) {
        return new FloatArraySet(a2);
    }

    private int findKey(float o) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (Float.floatToIntBits(this.a[i2]) != Float.floatToIntBits(o)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public FloatIterator iterator() {
        return new FloatIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < FloatArraySet.this.size;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FloatArraySet.this.a[this.next++];
            }

            @Override
            public void remove() {
                int tail = FloatArraySet.this.size-- - this.next--;
                System.arraycopy(FloatArraySet.this.a, this.next + 1, FloatArraySet.this.a, this.next, tail);
            }

            @Override
            public int skip(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                int remaining = FloatArraySet.this.size - this.next;
                if (n < remaining) {
                    this.next += n;
                    return n;
                }
                n = remaining;
                this.next = FloatArraySet.this.size;
                return n;
            }
        };
    }

    @Override
    public FloatSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public boolean contains(float k) {
        return this.findKey(k) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(float k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i2 = 0; i2 < tail; ++i2) {
            this.a[pos + i2] = this.a[pos + i2 + 1];
        }
        --this.size;
        return true;
    }

    @Override
    public boolean add(float k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            float[] b2 = new float[this.size == 0 ? 2 : this.size * 2];
            int i2 = this.size;
            while (i2-- != 0) {
                b2[i2] = this.a[i2];
            }
            this.a = b2;
        }
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float[] toFloatArray() {
        return Arrays.copyOf(this.a, this.size);
    }

    @Override
    public float[] toArray(float[] a2) {
        if (a2 == null || a2.length < this.size) {
            a2 = new float[this.size];
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        return a2;
    }

    public FloatArraySet clone() {
        FloatArraySet c;
        try {
            c = (FloatArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.a = (float[])this.a.clone();
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s.writeFloat(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new float[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s.readFloat();
        }
    }

    private final class Spliterator
    implements FloatSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, floatArraySet.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : FloatArraySet.this.size;
        }

        @Override
        public int characteristics() {
            return 16721;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(FloatConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(FloatArraySet.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(FloatConsumer action) {
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(FloatArraySet.this.a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            int max = this.getWorkingMax();
            if (this.pos >= max) {
                return 0L;
            }
            int remaining = max - this.pos;
            if (n < (long)remaining) {
                this.pos = SafeMath.safeLongToInt((long)this.pos + n);
                return n;
            }
            n = remaining;
            this.pos = max;
            return n;
        }

        @Override
        public FloatSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

