/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public final class DoubleBigArrays {
    public static final double[][] EMPTY_BIG_ARRAY = new double[0][];
    public static final double[][] DEFAULT_EMPTY_BIG_ARRAY = new double[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    private static final int RADIXSORT_NO_REC = 1024;

    private DoubleBigArrays() {
    }

    @Deprecated
    public static double get(double[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    @Deprecated
    public static void set(double[][] array, long index, double value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    @Deprecated
    public static void swap(double[][] array, long first2, long second2) {
        double t = array[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    @Deprecated
    public static void add(double[][] array, long index, double incr) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] + incr;
    }

    @Deprecated
    public static void mul(double[][] array, long index, double factor) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] * factor;
    }

    @Deprecated
    public static void incr(double[][] array, long index) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] + 1.0;
    }

    @Deprecated
    public static void decr(double[][] array, long index) {
        double[] dArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] - 1.0;
    }

    @Deprecated
    public static long length(double[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    @Deprecated
    public static void copy(double[][] srcArray, long srcPos, double[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(double[][] srcArray, long srcPos, double[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(double[] srcArray, int srcPos, double[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static double[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base2 = new double[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base2[i2] = new double[0x8000000];
            }
            base2[baseLength - 1] = new double[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base2[i3] = new double[0x8000000];
            }
        }
        return base2;
    }

    @Deprecated
    public static double[][] wrap(double[] array) {
        return BigArrays.wrap(array);
    }

    @Deprecated
    public static double[][] ensureCapacity(double[][] array, long length) {
        return DoubleBigArrays.ensureCapacity(array, length, DoubleBigArrays.length(array));
    }

    @Deprecated
    public static double[][] forceCapacity(double[][] array, long length, long preserve) {
        return BigArrays.forceCapacity(array, length, preserve);
    }

    @Deprecated
    public static double[][] ensureCapacity(double[][] array, long length, long preserve) {
        return length > DoubleBigArrays.length(array) ? DoubleBigArrays.forceCapacity(array, length, preserve) : array;
    }

    @Deprecated
    public static double[][] grow(double[][] array, long length) {
        long oldLength = DoubleBigArrays.length(array);
        return length > oldLength ? DoubleBigArrays.grow(array, length, oldLength) : array;
    }

    @Deprecated
    public static double[][] grow(double[][] array, long length, long preserve) {
        long oldLength = DoubleBigArrays.length(array);
        return length > oldLength ? DoubleBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    @Deprecated
    public static double[][] trim(double[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = DoubleBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base2 = (double[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base2[baseLength - 1] = DoubleArrays.trim(base2[baseLength - 1], residual);
        }
        return base2;
    }

    @Deprecated
    public static double[][] setLength(double[][] array, long length) {
        return BigArrays.setLength(array, length);
    }

    @Deprecated
    public static double[][] copy(double[][] array, long offset, long length) {
        return BigArrays.copy(array, offset, length);
    }

    @Deprecated
    public static double[][] copy(double[][] array) {
        return BigArrays.copy(array);
    }

    @Deprecated
    public static void fill(double[][] array, double value) {
        int i2 = array.length;
        while (i2-- != 0) {
            Arrays.fill(array[i2], value);
        }
    }

    @Deprecated
    public static void fill(double[][] array, long from, long to, double value) {
        BigArrays.fill(array, from, to, value);
    }

    @Deprecated
    public static boolean equals(double[][] a1, double[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(double[][] a2) {
        return BigArrays.toString(a2);
    }

    @Deprecated
    public static void ensureFromTo(double[][] a2, long from, long to) {
        BigArrays.ensureFromTo(DoubleBigArrays.length(a2), from, to);
    }

    @Deprecated
    public static void ensureOffsetLength(double[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(DoubleBigArrays.length(a2), offset, length);
    }

    @Deprecated
    public static void ensureSameLength(double[][] a2, double[][] b2) {
        if (DoubleBigArrays.length(a2) != DoubleBigArrays.length(b2)) {
            throw new IllegalArgumentException("Array size mismatch: " + DoubleBigArrays.length(a2) + " != " + DoubleBigArrays.length(b2));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    private static void swap(double[][] x, long a2, long b2, long n) {
        int i2 = 0;
        while ((long)i2 < n) {
            BigArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static long med3(double[][] x, long a2, long b2, long c, DoubleComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a2), BigArrays.get(x, b2));
        int ac = comp.compare(BigArrays.get(x, a2), BigArrays.get(x, c));
        int bc = comp.compare(BigArrays.get(x, b2), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(double[][] a2, long from, long to, DoubleComparator comp) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a2, j), BigArrays.get(a2, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a2, i2, m);
        }
    }

    public static void quickSort(double[][] x, long from, long to, DoubleComparator comp) {
        long c;
        long a2;
        long len = to - from;
        if (len < 7L) {
            DoubleBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = DoubleBigArrays.med3(x, m - s, m, m + s, comp);
                n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = DoubleBigArrays.med3(x, l, m, n, comp);
        }
        double v = BigArrays.get(x, m);
        long b2 = a2 = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(BigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BigArrays.swap(x, b2++, c--);
        }
        long n = to;
        long s = Math.min(a2 - from, b2 - a2);
        DoubleBigArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, n - d - 1L);
        DoubleBigArrays.swap(x, b2, n - s, s);
        s = b2 - a2;
        if (s > 1L) {
            DoubleBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            DoubleBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(double[][] x, long a2, long b2, long c) {
        int ab = Double.compare(BigArrays.get(x, a2), BigArrays.get(x, b2));
        int ac = Double.compare(BigArrays.get(x, a2), BigArrays.get(x, c));
        int bc = Double.compare(BigArrays.get(x, b2), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(double[][] a2, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (Double.compare(BigArrays.get(a2, j), BigArrays.get(a2, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a2, i2, m);
        }
    }

    public static void quickSort(double[][] x, DoubleComparator comp) {
        DoubleBigArrays.quickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static void quickSort(double[][] x, long from, long to) {
        long c;
        long a2;
        long len = to - from;
        if (len < 7L) {
            DoubleBigArrays.selectionSort(x, from, to);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s);
                m = DoubleBigArrays.med3(x, m - s, m, m + s);
                n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = DoubleBigArrays.med3(x, l, m, n);
        }
        double v = BigArrays.get(x, m);
        long b2 = a2 = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Double.compare(BigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Double.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BigArrays.swap(x, b2++, c--);
        }
        long n = to;
        long s = Math.min(a2 - from, b2 - a2);
        DoubleBigArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, n - d - 1L);
        DoubleBigArrays.swap(x, b2, n - s, s);
        s = b2 - a2;
        if (s > 1L) {
            DoubleBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1L) {
            DoubleBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(double[][] x) {
        DoubleBigArrays.quickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(double[][] x, long from, long to) {
        ForkJoinPool pool = DoubleBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            DoubleBigArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(double[][] x) {
        DoubleBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(double[][] x, long from, long to, DoubleComparator comp) {
        ForkJoinPool pool = DoubleBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            DoubleBigArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(double[][] x, DoubleComparator comp) {
        DoubleBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static long binarySearch(double[][] a2, long from, long to, double key) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            double midVal = BigArrays.get(a2, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(double[][] a2, double key) {
        return DoubleBigArrays.binarySearch(a2, 0L, BigArrays.length(a2), key);
    }

    public static long binarySearch(double[][] a2, long from, long to, double key, DoubleComparator c) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            double midVal = BigArrays.get(a2, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(double[][] a2, double key, DoubleComparator c) {
        return DoubleBigArrays.binarySearch(a2, 0L, BigArrays.length(a2), key, c);
    }

    private static final long fixDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        return l >= 0L ? l : l ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[][] a2) {
        DoubleBigArrays.radixSort(a2, 0L, BigArrays.length(a2));
    }

    public static void radixSort(double[][] a2, long from, long to) {
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                DoubleBigArrays.selectionSort(a2, first2, first2 + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(DoubleBigArrays.fixDouble(BigArrays.get(a2, first2 + i2)) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p2 = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 7 && count2[i3] > 1L) {
                        offsetStack[offsetPos++] = p2 + first2;
                        lengthStack[lengthPos++] = count2[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count2[i3];
            }
            long end = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count2[c]) {
                double t = BigArrays.get(a2, i4 + first2);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    double z = t;
                    int zz = c;
                    t = BigArrays.get(a2, d + first2);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(a2, d + first2, z);
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a2, i4 + first2, t);
                count2[c] = 0L;
            }
        }
    }

    private static void selectionSort(double[][] a2, double[][] b2, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (Double.compare(BigArrays.get(a2, j), BigArrays.get(a2, m)) >= 0 && (Double.compare(BigArrays.get(a2, j), BigArrays.get(a2, m)) != 0 || Double.compare(BigArrays.get(b2, j), BigArrays.get(b2, m)) >= 0)) continue;
                m = j;
            }
            if (m == i2) continue;
            double t = BigArrays.get(a2, i2);
            BigArrays.set(a2, i2, BigArrays.get(a2, m));
            BigArrays.set(a2, m, t);
            t = BigArrays.get(b2, i2);
            BigArrays.set(b2, i2, BigArrays.get(b2, m));
            BigArrays.set(b2, m, t);
        }
    }

    public static void radixSort(double[][] a2, double[][] b2) {
        DoubleBigArrays.radixSort(a2, b2, 0L, BigArrays.length(a2));
    }

    public static void radixSort(double[][] a2, double[][] b2, long from, long to) {
        int layers = 2;
        if (BigArrays.length(a2) != BigArrays.length(b2)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        long[] offsetStack = new long[3826];
        int offsetPos = 0;
        long[] lengthStack = new long[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first2 = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                DoubleBigArrays.selectionSort(a2, b2, first2, first2 + length);
                continue;
            }
            double[][] k = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(DoubleBigArrays.fixDouble(BigArrays.get(k, first2 + i2)) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count2[n2] = count2[n2] + 1L;
            }
            int lastUsed = -1;
            long p2 = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 15 && count2[i3] > 1L) {
                        offsetStack[offsetPos++] = p2 + first2;
                        lengthStack[lengthPos++] = count2[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count2[i3];
            }
            long end = length - count2[lastUsed];
            count2[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count2[c]) {
                double t = BigArrays.get(a2, i4 + first2);
                double u = BigArrays.get(b2, i4 + first2);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    double z = t;
                    int zz = c;
                    t = BigArrays.get(a2, d + first2);
                    BigArrays.set(a2, d + first2, z);
                    z = u;
                    u = BigArrays.get(b2, d + first2);
                    BigArrays.set(b2, d + first2, z);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a2, i4 + first2, t);
                BigArrays.set(b2, i4 + first2, u);
                count2[c] = 0L;
            }
        }
    }

    private static void insertionSortIndirect(long[][] perm, double[][] a2, double[][] b2, long from, long to) {
        long i2 = from;
        while (++i2 < to) {
            long t = BigArrays.get(perm, i2);
            long j = i2;
            long u = BigArrays.get(perm, j - 1L);
            while (Double.compare(BigArrays.get(a2, t), BigArrays.get(a2, u)) < 0 || Double.compare(BigArrays.get(a2, t), BigArrays.get(a2, u)) == 0 && Double.compare(BigArrays.get(b2, t), BigArrays.get(b2, u)) < 0) {
                BigArrays.set(perm, j, u);
                if (from == j - 1L) {
                    --j;
                    break;
                }
                u = BigArrays.get(perm, --j - 1L);
            }
            BigArrays.set(perm, j, t);
        }
    }

    public static void radixSortIndirect(long[][] perm, double[][] a2, double[][] b2, boolean stable) {
        DoubleBigArrays.ensureSameLength(a2, b2);
        DoubleBigArrays.radixSortIndirect(perm, a2, b2, 0L, BigArrays.length(a2), stable);
    }

    public static void radixSortIndirect(long[][] perm, double[][] a2, double[][] b2, long from, long to, boolean stable) {
        long[][] support;
        if (to - from < 1024L) {
            DoubleBigArrays.insertionSortIndirect(perm, a2, b2, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 15;
        int stackSize = 3826;
        int stackPos = 0;
        long[] offsetStack = new long[3826];
        long[] lengthStack = new long[3826];
        int[] levelStack = new int[3826];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        long[] count2 = new long[256];
        long[] pos = new long[256];
        long[][] lArray = support = stable ? LongBigArrays.newBigArray(BigArrays.length(perm)) : null;
        while (stackPos > 0) {
            long first2 = offsetStack[--stackPos];
            long length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            double[][] k = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            long i2 = first2 + length;
            while (i2-- != first2) {
                int n = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, BigArrays.get(perm, i2))) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1L;
            }
            int lastUsed = -1;
            long p2 = stable ? 0L : first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0L) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            if (stable) {
                long i4 = first2 + length;
                while (i4-- != first2) {
                    int n = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, BigArrays.get(perm, i4))) >>> shift & 0xFFL ^ (long)signMask);
                    long l = pos[n] - 1L;
                    pos[n] = l;
                    BigArrays.set(support, l, BigArrays.get(perm, i4));
                }
                BigArrays.copy(support, 0L, perm, first2, length);
                p2 = first2;
                for (int i5 = 0; i5 < 256; ++i5) {
                    if (level < 15 && count2[i5] > 1L) {
                        if (count2[i5] < 1024L) {
                            DoubleBigArrays.insertionSortIndirect(perm, a2, b2, p2, p2 + count2[i5]);
                        } else {
                            offsetStack[stackPos] = p2;
                            lengthStack[stackPos] = count2[i5];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p2 += count2[i5];
                }
                Arrays.fill(count2, 0L);
                continue;
            }
            long end = first2 + length - count2[lastUsed];
            int c = -1;
            for (long i6 = first2; i6 <= end; i6 += count2[c]) {
                long t = BigArrays.get(perm, i6);
                c = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, t)) >>> shift & 0xFFL ^ (long)signMask);
                if (i6 < end) {
                    while (true) {
                        int n = c;
                        long l = pos[n] - 1L;
                        pos[n] = l;
                        long d = l;
                        if (l <= i6) break;
                        long z = t;
                        t = BigArrays.get(perm, d);
                        BigArrays.set(perm, d, z);
                        c = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, t)) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    BigArrays.set(perm, i6, t);
                }
                if (level < 15 && count2[c] > 1L) {
                    if (count2[c] < 1024L) {
                        DoubleBigArrays.insertionSortIndirect(perm, a2, b2, i6, i6 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i6;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0L;
            }
        }
    }

    public static double[][] shuffle(double[][] a2, long from, long to, Random random) {
        return BigArrays.shuffle(a2, from, to, random);
    }

    public static double[][] shuffle(double[][] a2, Random random) {
        return BigArrays.shuffle(a2, random);
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final double[][] x;

        public ForkJoinQuickSort(double[][] x, long from, long to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            long c;
            long a2;
            double[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                DoubleBigArrays.quickSort(x, this.from, this.to);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s);
            m = DoubleBigArrays.med3(x, m - s, m, m + s);
            n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n);
            m = DoubleBigArrays.med3(x, l, m, n);
            double v = BigArrays.get(x, m);
            long b2 = a2 = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Double.compare(BigArrays.get(x, b2), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Double.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BigArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            DoubleBigArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            DoubleBigArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final double[][] x;
        private final DoubleComparator comp;

        public ForkJoinQuickSortComp(double[][] x, long from, long to, DoubleComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            long c;
            long a2;
            double[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                DoubleBigArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s, this.comp);
            m = DoubleBigArrays.med3(x, m - s, m, m + s, this.comp);
            n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n, this.comp);
            m = DoubleBigArrays.med3(x, l, m, n, this.comp);
            double v = BigArrays.get(x, m);
            long b2 = a2 = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = this.comp.compare(BigArrays.get(x, b2), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = this.comp.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BigArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            DoubleBigArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            DoubleBigArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<double[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(double[][] a2, double[][] b2) {
            return DoubleBigArrays.equals(a2, b2);
        }
    }
}

