/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    private static final int RADIXSORT_NO_REC = 1024;
    private static final int RADIXSORT_NO_REC_SMALL = 64;
    private static final int PARALLEL_RADIXSORT_NO_FORK = 1024;
    static final int RADIX_SORT_MIN_THRESHOLD = 4000;
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    private DoubleArrays() {
    }

    public static double[] forceCapacity(double[] array, int length, int preserve) {
        double[] t = new double[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static double[] ensureCapacity(double[] array, int length) {
        return DoubleArrays.ensureCapacity(array, length, array.length);
    }

    public static double[] ensureCapacity(double[] array, int length, int preserve) {
        return length > array.length ? DoubleArrays.forceCapacity(array, length, preserve) : array;
    }

    public static double[] grow(double[] array, int length) {
        return DoubleArrays.grow(array, length, array.length);
    }

    public static double[] grow(double[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min((long)array.length + (long)(array.length >> 1), 0x7FFFFFF7L), (long)length);
            double[] t = new double[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static double[] trim(double[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        double[] t = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static double[] setLength(double[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return DoubleArrays.trim(array, length);
        }
        return DoubleArrays.ensureCapacity(array, length);
    }

    public static double[] copy(double[] array, int offset, int length) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        double[] a2 = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static double[] copy(double[] array) {
        return (double[])array.clone();
    }

    @Deprecated
    public static void fill(double[] array, double value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    @Deprecated
    public static void fill(double[] array, int from, int to, double value) {
        DoubleArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(double[] a1, double[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (Double.doubleToLongBits(a1[i2]) == Double.doubleToLongBits(a2[i2])) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(double[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(double[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    public static void ensureSameLength(double[] a2, double[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a2.length + " != " + b2.length);
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    public static void swap(double[] x, int a2, int b2) {
        double t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(double[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            DoubleArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(double[] x, int a2, int b2, int c, DoubleComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(double[] a2, int from, int to, DoubleComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            double u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(double[] a2, int from, int to, DoubleComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            double t = a2[i2];
            int j = i2;
            double u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(double[] x, int from, int to, DoubleComparator comp) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = DoubleArrays.med3(x, m - s, m, m + s, comp);
            n = DoubleArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = DoubleArrays.med3(x, l, m, n, comp);
        double v = x[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            DoubleArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        DoubleArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        DoubleArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            DoubleArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static void quickSort(double[] x, DoubleComparator comp) {
        DoubleArrays.quickSort(x, 0, x.length, comp);
    }

    public static void parallelQuickSort(double[] x, int from, int to, DoubleComparator comp) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            DoubleArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(double[] x, DoubleComparator comp) {
        DoubleArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static int med3(double[] x, int a2, int b2, int c) {
        int ab = Double.compare(x[a2], x[b2]);
        int ac = Double.compare(x[a2], x[c]);
        int bc = Double.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(double[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (Double.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            double u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(double[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            double t = a2[i2];
            int j = i2;
            double u = a2[j - 1];
            while (Double.compare(t, u) < 0) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(double[] x, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3(x, l, l + s, l + 2 * s);
            m = DoubleArrays.med3(x, m - s, m, m + s);
            n = DoubleArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = DoubleArrays.med3(x, l, m, n);
        double v = x[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Double.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Double.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            DoubleArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        DoubleArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        DoubleArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            DoubleArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, to - s, to);
        }
    }

    public static void quickSort(double[] x) {
        DoubleArrays.quickSort(x, 0, x.length);
    }

    public static void parallelQuickSort(double[] x, int from, int to) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            DoubleArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(double[] x) {
        DoubleArrays.parallelQuickSort(x, 0, x.length);
    }

    private static int med3Indirect(int[] perm, double[] x, int a2, int b2, int c) {
        double aa = x[perm[a2]];
        double bb = x[perm[b2]];
        double cc = x[perm[c]];
        int ab = Double.compare(aa, bb);
        int ac = Double.compare(aa, cc);
        int bc = Double.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void insertionSortIndirect(int[] perm, double[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (Double.compare(a2[t], a2[u]) < 0) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void quickSortIndirect(int[] perm, double[] x, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSortIndirect(perm, x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3Indirect(perm, x, l, l + s, l + 2 * s);
            m = DoubleArrays.med3Indirect(perm, x, m - s, m, m + s);
            n = DoubleArrays.med3Indirect(perm, x, n - 2 * s, n - s, n);
        }
        m = DoubleArrays.med3Indirect(perm, x, l, m, n);
        double v = x[perm[m]];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Double.compare(x[perm[b2]], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Double.compare(x[perm[c]], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(perm, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(perm, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(perm, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            DoubleArrays.quickSortIndirect(perm, x, from, from + s);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSortIndirect(perm, x, to - s, to);
        }
    }

    public static void quickSortIndirect(int[] perm, double[] x) {
        DoubleArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static void parallelQuickSortIndirect(int[] perm, double[] x, int from, int to) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            DoubleArrays.quickSortIndirect(perm, x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSortIndirect(perm, x, from, to));
        }
    }

    public static void parallelQuickSortIndirect(int[] perm, double[] x) {
        DoubleArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static void stabilize(int[] perm, double[] x, int from, int to) {
        int curr = from;
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (x[perm[i2]] == x[perm[curr]]) continue;
            if (i2 - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i2);
            }
            curr = i2;
        }
        if (to - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to);
        }
    }

    public static void stabilize(int[] perm, double[] x) {
        DoubleArrays.stabilize(perm, x, 0, perm.length);
    }

    private static int med3(double[] x, double[] y, int a2, int b2, int c) {
        int bc;
        int t = Double.compare(x[a2], x[b2]);
        int ab = t == 0 ? Double.compare(y[a2], y[b2]) : t;
        t = Double.compare(x[a2], x[c]);
        int ac = t == 0 ? Double.compare(y[a2], y[c]) : t;
        t = Double.compare(x[b2], x[c]);
        int n = bc = t == 0 ? Double.compare(y[b2], y[c]) : t;
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void swap(double[] x, double[] y, int a2, int b2) {
        double t = x[a2];
        double u = y[a2];
        x[a2] = x[b2];
        y[a2] = y[b2];
        x[b2] = t;
        y[b2] = u;
    }

    private static void swap(double[] x, double[] y, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            DoubleArrays.swap(x, y, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static void selectionSort(double[] a2, double[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                int u = Double.compare(a2[j], a2[m]);
                if (u >= 0 && (u != 0 || Double.compare(b2[j], b2[m]) >= 0)) continue;
                m = j;
            }
            if (m == i2) continue;
            double t = a2[i2];
            a2[i2] = a2[m];
            a2[m] = t;
            t = b2[i2];
            b2[i2] = b2[m];
            b2[m] = t;
        }
    }

    public static void quickSort(double[] x, double[] y, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.selectionSort(x, y, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3(x, y, l, l + s, l + 2 * s);
            m = DoubleArrays.med3(x, y, m - s, m, m + s);
            n = DoubleArrays.med3(x, y, n - 2 * s, n - s, n);
        }
        m = DoubleArrays.med3(x, y, l, m, n);
        double v = x[m];
        double w = y[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int t;
            int comparison;
            if (b2 <= c && (comparison = (t = Double.compare(x[b2], v)) == 0 ? Double.compare(y[b2], w) : t) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, y, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = (t = Double.compare(x[c], v)) == 0 ? Double.compare(y[c], w) : t) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, y, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            DoubleArrays.swap(x, y, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        DoubleArrays.swap(x, y, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        DoubleArrays.swap(x, y, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            DoubleArrays.quickSort(x, y, from, from + s);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, y, to - s, to);
        }
    }

    public static void quickSort(double[] x, double[] y) {
        DoubleArrays.ensureSameLength(x, y);
        DoubleArrays.quickSort(x, y, 0, x.length);
    }

    public static void parallelQuickSort(double[] x, double[] y, int from, int to) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            DoubleArrays.quickSort(x, y, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort2(x, y, from, to));
        }
    }

    public static void parallelQuickSort(double[] x, double[] y) {
        DoubleArrays.ensureSameLength(x, y);
        DoubleArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static void unstableSort(double[] a2, int from, int to) {
        if (to - from >= 4000) {
            DoubleArrays.radixSort(a2, from, to);
        } else {
            DoubleArrays.quickSort(a2, from, to);
        }
    }

    public static void unstableSort(double[] a2) {
        DoubleArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(double[] a2, int from, int to, DoubleComparator comp) {
        DoubleArrays.quickSort(a2, from, to, comp);
    }

    public static void unstableSort(double[] a2, DoubleComparator comp) {
        DoubleArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(double[] a2, int from, int to, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a2, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, a2);
        DoubleArrays.mergeSort(supp, mid, to, a2);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && Double.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(double[] a2, int from, int to) {
        DoubleArrays.mergeSort(a2, from, to, (double[])null);
    }

    public static void mergeSort(double[] a2) {
        DoubleArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(double[] a2, int from, int to, DoubleComparator comp, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a2, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, comp, a2);
        DoubleArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(double[] a2, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, from, to, comp, null);
    }

    public static void mergeSort(double[] a2, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static void stableSort(double[] a2, int from, int to) {
        DoubleArrays.mergeSort(a2, from, to);
    }

    public static void stableSort(double[] a2) {
        DoubleArrays.stableSort(a2, 0, a2.length);
    }

    public static void stableSort(double[] a2, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, from, to, comp);
    }

    public static void stableSort(double[] a2, DoubleComparator comp) {
        DoubleArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(double[] a2, int from, int to, double key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            double midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(double[] a2, double key) {
        return DoubleArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(double[] a2, int from, int to, double key, DoubleComparator c) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            double midVal = a2[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(double[] a2, double key, DoubleComparator c) {
        return DoubleArrays.binarySearch(a2, 0, a2.length, key, c);
    }

    private static final long fixDouble(double d) {
        long l = Double.doubleToLongBits(d);
        return l >= 0L ? l : l ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[] a2) {
        DoubleArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(double[] a2, int from, int to) {
        if (to - from < 1024) {
            DoubleArrays.quickSort(a2, from, to);
            return;
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            int shift = (7 - level % 8) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = (int)(DoubleArrays.fixDouble(a2[i2]) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                double t = a2[i4];
                c = (int)(DoubleArrays.fixDouble(t) >>> shift & 0xFFL ^ (long)signMask);
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        double z = t;
                        t = a2[d];
                        a2[d] = z;
                        c = (int)(DoubleArrays.fixDouble(t) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    a2[i4] = t;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        DoubleArrays.quickSort(a2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(double[] a2, int from, int to) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            DoubleArrays.quickSort(a2, from, to);
            return;
        }
        int maxLevel = 7;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 8 == 0 ? 128 : 0;
                    int shift = (7 - level % 8) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = (int)(DoubleArrays.fixDouble(a2[i3]) >>> shift & 0xFFL ^ (long)signMask);
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p2 = first2;
                    for (int i4 = 0; i4 < 256; ++i4) {
                        if (count2[i4] != 0) {
                            lastUsed = i4;
                        }
                        pos[i4] = p2 += count2[i4];
                    }
                    int end = first2 + length - count2[lastUsed];
                    int c = -1;
                    for (int i5 = first2; i5 <= end; i5 += count2[c]) {
                        double t = a2[i5];
                        c = (int)(DoubleArrays.fixDouble(t) >>> shift & 0xFFL ^ (long)signMask);
                        if (i5 < end) {
                            while (true) {
                                int n = c;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i5) break;
                                double z = t;
                                t = a2[d];
                                a2[d] = z;
                                c = (int)(DoubleArrays.fixDouble(t) >>> shift & 0xFFL ^ (long)signMask);
                            }
                            a2[i5] = t;
                        }
                        if (level < 7 && count2[c] > 1) {
                            if (count2[c] < 1024) {
                                DoubleArrays.quickSort(a2, i5, i5 + count2[c]);
                            } else {
                                queueSize.incrementAndGet();
                                queue.add(new Segment(i5, count2[c], level + 1));
                            }
                        }
                        count2[c] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(double[] a2) {
        DoubleArrays.parallelRadixSort(a2, 0, a2.length);
    }

    public static void radixSortIndirect(int[] perm, double[] a2, boolean stable) {
        DoubleArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, double[] a2, int from, int to, boolean stable) {
        int[] support;
        if (to - from < 1024) {
            DoubleArrays.quickSortIndirect(perm, a2, from, to);
            if (stable) {
                DoubleArrays.stabilize(perm, a2, from, to);
            }
            return;
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i2;
            int p2;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            int shift = (7 - level % 8) * 8;
            int i3 = first2 + length;
            while (i3-- != first2) {
                int n = (int)(DoubleArrays.fixDouble(a2[perm[i3]]) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p2 = stable ? 0 : first2;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p2 += count2[i2];
            }
            if (stable) {
                i2 = first2 + length;
                while (i2-- != first2) {
                    int n2 = (int)(DoubleArrays.fixDouble(a2[perm[i2]]) >>> shift & 0xFFL ^ (long)signMask);
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i2];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p2 = first2;
                for (i2 = 0; i2 <= lastUsed; ++i2) {
                    if (level < 7 && count2[i2] > 1) {
                        if (count2[i2] < 1024) {
                            DoubleArrays.quickSortIndirect(perm, a2, p2, p2 + count2[i2]);
                            if (stable) {
                                DoubleArrays.stabilize(perm, a2, p2, p2 + count2[i2]);
                            }
                        } else {
                            offsetStack[stackPos] = p2;
                            lengthStack[stackPos] = count2[i2];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p2 += count2[i2];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = perm[i4];
                c = (int)(DoubleArrays.fixDouble(a2[t]) >>> shift & 0xFFL ^ (long)signMask);
                if (i4 < end) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i4) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c = (int)(DoubleArrays.fixDouble(a2[t]) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    perm[i4] = t;
                }
                if (level < 7 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        DoubleArrays.quickSortIndirect(perm, a2, i4, i4 + count2[c]);
                        if (stable) {
                            DoubleArrays.stabilize(perm, a2, i4, i4 + count2[c]);
                        }
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, double[] a2, int from, int to, boolean stable) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            DoubleArrays.radixSortIndirect(perm, a2, from, to, stable);
            return;
        }
        int maxLevel = 7;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int[] support = stable ? new int[perm.length] : null;
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    int i2;
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i3 = numberOfThreads;
                        while (i3-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 8 == 0 ? 128 : 0;
                    int shift = (7 - level % 8) * 8;
                    int i4 = first2 + length;
                    while (i4-- != first2) {
                        int n = (int)(DoubleArrays.fixDouble(a2[perm[i4]]) >>> shift & 0xFFL ^ (long)signMask);
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p2 = first2;
                    for (i2 = 0; i2 < 256; ++i2) {
                        if (count2[i2] != 0) {
                            lastUsed = i2;
                        }
                        pos[i2] = p2 += count2[i2];
                    }
                    if (stable) {
                        i2 = first2 + length;
                        while (i2-- != first2) {
                            int n = (int)(DoubleArrays.fixDouble(a2[perm[i2]]) >>> shift & 0xFFL ^ (long)signMask);
                            int n2 = pos[n] - 1;
                            pos[n] = n2;
                            support[n2] = perm[i2];
                        }
                        System.arraycopy(support, first2, perm, first2, length);
                        p2 = first2;
                        for (i2 = 0; i2 <= lastUsed; ++i2) {
                            if (level < 7 && count2[i2] > 1) {
                                if (count2[i2] < 1024) {
                                    DoubleArrays.radixSortIndirect(perm, a2, p2, p2 + count2[i2], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(p2, count2[i2], level + 1));
                                }
                            }
                            p2 += count2[i2];
                        }
                        java.util.Arrays.fill(count2, 0);
                    } else {
                        int end = first2 + length - count2[lastUsed];
                        int c = -1;
                        for (int i5 = first2; i5 <= end; i5 += count2[c]) {
                            int t = perm[i5];
                            c = (int)(DoubleArrays.fixDouble(a2[t]) >>> shift & 0xFFL ^ (long)signMask);
                            if (i5 < end) {
                                while (true) {
                                    int n = c;
                                    int n3 = pos[n] - 1;
                                    pos[n] = n3;
                                    int d = n3;
                                    if (n3 <= i5) break;
                                    int z = t;
                                    t = perm[d];
                                    perm[d] = z;
                                    c = (int)(DoubleArrays.fixDouble(a2[t]) >>> shift & 0xFFL ^ (long)signMask);
                                }
                                perm[i5] = t;
                            }
                            if (level < 7 && count2[c] > 1) {
                                if (count2[c] < 1024) {
                                    DoubleArrays.radixSortIndirect(perm, a2, i5, i5 + count2[c], stable);
                                } else {
                                    queueSize.incrementAndGet();
                                    queue.add(new Segment(i5, count2[c], level + 1));
                                }
                            }
                            count2[c] = 0;
                        }
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSortIndirect(int[] perm, double[] a2, boolean stable) {
        DoubleArrays.parallelRadixSortIndirect(perm, a2, 0, a2.length, stable);
    }

    public static void radixSort(double[] a2, double[] b2) {
        DoubleArrays.ensureSameLength(a2, b2);
        DoubleArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(double[] a2, double[] b2, int from, int to) {
        if (to - from < 1024) {
            DoubleArrays.quickSort(a2, b2, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 15;
        int stackSize = 3826;
        int stackPos = 0;
        int[] offsetStack = new int[3826];
        int[] lengthStack = new int[3826];
        int[] levelStack = new int[3826];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            double[] k = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = (int)(DoubleArrays.fixDouble(k[i2]) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                double t = a2[i4];
                double u = b2[i4];
                c = (int)(DoubleArrays.fixDouble(k[i4]) >>> shift & 0xFFL ^ (long)signMask);
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        c = (int)(DoubleArrays.fixDouble(k[d]) >>> shift & 0xFFL ^ (long)signMask);
                        double z = t;
                        t = a2[d];
                        a2[d] = z;
                        z = u;
                        u = b2[d];
                        b2[d] = z;
                    }
                    a2[i4] = t;
                    b2[i4] = u;
                }
                if (level < 15 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        DoubleArrays.quickSort(a2, b2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static void parallelRadixSort(double[] a2, double[] b2, int from, int to) {
        ForkJoinPool pool = DoubleArrays.getPool();
        if (to - from < 1024 || pool.getParallelism() == 1) {
            DoubleArrays.quickSort(a2, b2, from, to);
            return;
        }
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        LinkedBlockingQueue<Segment> queue = new LinkedBlockingQueue<Segment>();
        queue.add(new Segment(from, to - from, 0));
        AtomicInteger queueSize = new AtomicInteger(1);
        int numberOfThreads = pool.getParallelism();
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(pool);
        int j = numberOfThreads;
        while (j-- != 0) {
            executorCompletionService.submit(() -> {
                int[] count2 = new int[256];
                int[] pos = new int[256];
                while (true) {
                    Segment segment;
                    if (queueSize.get() == 0) {
                        int i2 = numberOfThreads;
                        while (i2-- != 0) {
                            queue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)queue.take()) == POISON_PILL) {
                        return null;
                    }
                    int first2 = segment.offset;
                    int length = segment.length;
                    int level = segment.level;
                    int signMask = level % 8 == 0 ? 128 : 0;
                    double[] k = level < 8 ? a2 : b2;
                    int shift = (7 - level % 8) * 8;
                    int i3 = first2 + length;
                    while (i3-- != first2) {
                        int n = (int)(DoubleArrays.fixDouble(k[i3]) >>> shift & 0xFFL ^ (long)signMask);
                        count2[n] = count2[n] + 1;
                    }
                    int lastUsed = -1;
                    int p2 = first2;
                    for (int i4 = 0; i4 < 256; ++i4) {
                        if (count2[i4] != 0) {
                            lastUsed = i4;
                        }
                        pos[i4] = p2 += count2[i4];
                    }
                    int end = first2 + length - count2[lastUsed];
                    int c = -1;
                    for (int i5 = first2; i5 <= end; i5 += count2[c]) {
                        double t = a2[i5];
                        double u = b2[i5];
                        c = (int)(DoubleArrays.fixDouble(k[i5]) >>> shift & 0xFFL ^ (long)signMask);
                        if (i5 < end) {
                            while (true) {
                                int n = c;
                                int n2 = pos[n] - 1;
                                pos[n] = n2;
                                int d = n2;
                                if (n2 <= i5) break;
                                c = (int)(DoubleArrays.fixDouble(k[d]) >>> shift & 0xFFL ^ (long)signMask);
                                double z = t;
                                double w = u;
                                t = a2[d];
                                u = b2[d];
                                a2[d] = z;
                                b2[d] = w;
                            }
                            a2[i5] = t;
                            b2[i5] = u;
                        }
                        if (level < 15 && count2[c] > 1) {
                            if (count2[c] < 1024) {
                                DoubleArrays.quickSort(a2, b2, i5, i5 + count2[c]);
                            } else {
                                queueSize.incrementAndGet();
                                queue.add(new Segment(i5, count2[c], level + 1));
                            }
                        }
                        count2[c] = 0;
                    }
                    queueSize.decrementAndGet();
                }
            });
        }
        Throwable problem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        if (problem != null) {
            throw problem instanceof RuntimeException ? (RuntimeException)problem : new RuntimeException(problem);
        }
    }

    public static void parallelRadixSort(double[] a2, double[] b2) {
        DoubleArrays.ensureSameLength(a2, b2);
        DoubleArrays.parallelRadixSort(a2, b2, 0, a2.length);
    }

    private static void insertionSortIndirect(int[] perm, double[] a2, double[] b2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (Double.compare(a2[t], a2[u]) < 0 || Double.compare(a2[t], a2[u]) == 0 && Double.compare(b2[t], b2[u]) < 0) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, double[] a2, double[] b2, boolean stable) {
        DoubleArrays.ensureSameLength(a2, b2);
        DoubleArrays.radixSortIndirect(perm, a2, b2, 0, a2.length, stable);
    }

    public static void radixSortIndirect(int[] perm, double[] a2, double[] b2, int from, int to, boolean stable) {
        int[] support;
        if (to - from < 64) {
            DoubleArrays.insertionSortIndirect(perm, a2, b2, from, to);
            return;
        }
        int layers = 2;
        int maxLevel = 15;
        int stackSize = 3826;
        int stackPos = 0;
        int[] offsetStack = new int[3826];
        int[] lengthStack = new int[3826];
        int[] levelStack = new int[3826];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        int[] nArray = support = stable ? new int[perm.length] : null;
        while (stackPos > 0) {
            int i2;
            int p2;
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            double[] k = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            int i3 = first2 + length;
            while (i3-- != first2) {
                int n = (int)(DoubleArrays.fixDouble(k[perm[i3]]) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int n = p2 = stable ? 0 : first2;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p2 += count2[i2];
            }
            if (stable) {
                i2 = first2 + length;
                while (i2-- != first2) {
                    int n2 = (int)(DoubleArrays.fixDouble(k[perm[i2]]) >>> shift & 0xFFL ^ (long)signMask);
                    int n3 = pos[n2] - 1;
                    pos[n2] = n3;
                    support[n3] = perm[i2];
                }
                System.arraycopy(support, 0, perm, first2, length);
                p2 = first2;
                for (i2 = 0; i2 < 256; ++i2) {
                    if (level < 15 && count2[i2] > 1) {
                        if (count2[i2] < 64) {
                            DoubleArrays.insertionSortIndirect(perm, a2, b2, p2, p2 + count2[i2]);
                        } else {
                            offsetStack[stackPos] = p2;
                            lengthStack[stackPos] = count2[i2];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p2 += count2[i2];
                }
                java.util.Arrays.fill(count2, 0);
                continue;
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = perm[i4];
                c = (int)(DoubleArrays.fixDouble(k[t]) >>> shift & 0xFFL ^ (long)signMask);
                if (i4 < end) {
                    while (true) {
                        int n4 = c;
                        int n5 = pos[n4] - 1;
                        pos[n4] = n5;
                        int d = n5;
                        if (n5 <= i4) break;
                        int z = t;
                        t = perm[d];
                        perm[d] = z;
                        c = (int)(DoubleArrays.fixDouble(k[t]) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    perm[i4] = t;
                }
                if (level < 15 && count2[c] > 1) {
                    if (count2[c] < 64) {
                        DoubleArrays.insertionSortIndirect(perm, a2, b2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(double[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 8;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            block1: for (int j = i2 + 1; j < to; ++j) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j] < a2[p2][m]) {
                        m = j;
                        continue block1;
                    }
                    if (a2[p2][j] > a2[p2][m]) continue block1;
                }
            }
            if (m == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                double u = a2[p3][i2];
                a2[p3][i2] = a2[p3][m];
                a2[p3][m] = u;
            }
        }
    }

    public static void radixSort(double[][] a2) {
        DoubleArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(double[][] a2, int from, int to) {
        if (to - from < 64) {
            DoubleArrays.selectionSort(a2, from, to, 0);
            return;
        }
        int layers = a2.length;
        int maxLevel = 8 * layers - 1;
        int p2 = layers;
        int l = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 8 - 1) + 1;
        int stackPos = 0;
        int[] offsetStack = new int[stackSize];
        int[] lengthStack = new int[stackSize];
        int[] levelStack = new int[stackSize];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        double[] t = new double[layers];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            double[] k = a2[level / 8];
            int shift = (7 - level % 8) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = (int)(DoubleArrays.fixDouble(k[i2]) >>> shift & 0xFFL ^ (long)signMask);
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p3 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p3 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t[p4] = a2[p4][i4];
                }
                c = (int)(DoubleArrays.fixDouble(k[i4]) >>> shift & 0xFFL ^ (long)signMask);
                if (i4 < end) {
                    block6: while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        c = (int)(DoubleArrays.fixDouble(k[d]) >>> shift & 0xFFL ^ (long)signMask);
                        p4 = layers;
                        while (true) {
                            if (p4-- == 0) continue block6;
                            double u = t[p4];
                            t[p4] = a2[p4][d];
                            a2[p4][d] = u;
                        }
                        break;
                    }
                    p4 = layers;
                    while (p4-- != 0) {
                        a2[p4][i4] = t[p4];
                    }
                }
                if (level < maxLevel && count2[c] > 1) {
                    if (count2[c] < 64) {
                        DoubleArrays.selectionSort(a2, i4, i4 + count2[c], level + 1);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    public static double[] shuffle(double[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            double t = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t;
        }
        return a2;
    }

    public static double[] shuffle(double[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            double t = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t;
        }
        return a2;
    }

    public static double[] reverse(double[] a2) {
        int length = a2.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            double t = a2[length - i2 - 1];
            a2[length - i2 - 1] = a2[i2];
            a2[i2] = t;
        }
        return a2;
    }

    public static double[] reverse(double[] a2, int from, int to) {
        int length = to - from;
        int i2 = length / 2;
        while (i2-- != 0) {
            double t = a2[from + length - i2 - 1];
            a2[from + length - i2 - 1] = a2[from + i2];
            a2[from + i2] = t;
        }
        return a2;
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final double[] x;
        private final DoubleComparator comp;

        public ForkJoinQuickSortComp(double[] x, int from, int to, DoubleComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            double[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                DoubleArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = DoubleArrays.med3(x, l, l + s, l + 2 * s, this.comp);
            m = DoubleArrays.med3(x, m - s, m, m + s, this.comp);
            n = DoubleArrays.med3(x, n - 2 * s, n - s, n, this.comp);
            m = DoubleArrays.med3(x, l, m, n, this.comp);
            double v = x[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = this.comp.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        DoubleArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = this.comp.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        DoubleArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                DoubleArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            DoubleArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            DoubleArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final double[] x;

        public ForkJoinQuickSort(double[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            double[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                DoubleArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = DoubleArrays.med3(x, l, l + s, l + 2 * s);
            m = DoubleArrays.med3(x, m - s, m, m + s);
            n = DoubleArrays.med3(x, n - 2 * s, n - s, n);
            m = DoubleArrays.med3(x, l, m, n);
            double v = x[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Double.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        DoubleArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Double.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        DoubleArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                DoubleArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            DoubleArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            DoubleArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final double[] x;

        public ForkJoinQuickSortIndirect(int[] perm, double[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            double[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                DoubleArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = DoubleArrays.med3Indirect(this.perm, x, l, l + s, l + 2 * s);
            m = DoubleArrays.med3Indirect(this.perm, x, m - s, m, m + s);
            n = DoubleArrays.med3Indirect(this.perm, x, n - 2 * s, n - s, n);
            m = DoubleArrays.med3Indirect(this.perm, x, l, m, n);
            double v = x[this.perm[m]];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Double.compare(x[this.perm[b2]], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Double.compare(x[this.perm[c]], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                IntArrays.swap(this.perm, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(this.perm, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(this.perm, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s), new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort2
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final double[] x;
        private final double[] y;

        public ForkJoinQuickSort2(double[] x, double[] y, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            double[] x = this.x;
            double[] y = this.y;
            int len = this.to - this.from;
            if (len < 8192) {
                DoubleArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = DoubleArrays.med3(x, y, l, l + s, l + 2 * s);
            m = DoubleArrays.med3(x, y, m - s, m, m + s);
            n = DoubleArrays.med3(x, y, n - 2 * s, n - s, n);
            m = DoubleArrays.med3(x, y, l, m, n);
            double v = x[m];
            double w = y[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int t;
                int comparison;
                if (b2 <= c && (comparison = (t = Double.compare(x[b2], v)) == 0 ? Double.compare(y[b2], w) : t) <= 0) {
                    if (comparison == 0) {
                        DoubleArrays.swap(x, y, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = (t = Double.compare(x[c], v)) == 0 ? Double.compare(y[c], w) : t) >= 0) {
                    if (comparison == 0) {
                        DoubleArrays.swap(x, y, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                DoubleArrays.swap(x, y, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            DoubleArrays.swap(x, y, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            DoubleArrays.swap(x, y, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s), new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a2, double[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

