/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public final class BooleanBigArrays {
    public static final boolean[][] EMPTY_BIG_ARRAY = new boolean[0][];
    public static final boolean[][] DEFAULT_EMPTY_BIG_ARRAY = new boolean[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;

    private BooleanBigArrays() {
    }

    @Deprecated
    public static boolean get(boolean[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    @Deprecated
    public static void set(boolean[][] array, long index, boolean value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    @Deprecated
    public static void swap(boolean[][] array, long first2, long second2) {
        boolean t = array[BigArrays.segment(first2)][BigArrays.displacement(first2)];
        array[BigArrays.segment((long)first2)][BigArrays.displacement((long)first2)] = array[BigArrays.segment(second2)][BigArrays.displacement(second2)];
        array[BigArrays.segment((long)second2)][BigArrays.displacement((long)second2)] = t;
    }

    @Deprecated
    public static long length(boolean[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    @Deprecated
    public static void copy(boolean[][] srcArray, long srcPos, boolean[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(boolean[][] srcArray, long srcPos, boolean[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(boolean[] srcArray, int srcPos, boolean[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static boolean[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base2 = new boolean[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base2[i2] = new boolean[0x8000000];
            }
            base2[baseLength - 1] = new boolean[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base2[i3] = new boolean[0x8000000];
            }
        }
        return base2;
    }

    @Deprecated
    public static boolean[][] wrap(boolean[] array) {
        return BigArrays.wrap(array);
    }

    @Deprecated
    public static boolean[][] ensureCapacity(boolean[][] array, long length) {
        return BooleanBigArrays.ensureCapacity(array, length, BooleanBigArrays.length(array));
    }

    @Deprecated
    public static boolean[][] forceCapacity(boolean[][] array, long length, long preserve) {
        return BigArrays.forceCapacity(array, length, preserve);
    }

    @Deprecated
    public static boolean[][] ensureCapacity(boolean[][] array, long length, long preserve) {
        return length > BooleanBigArrays.length(array) ? BooleanBigArrays.forceCapacity(array, length, preserve) : array;
    }

    @Deprecated
    public static boolean[][] grow(boolean[][] array, long length) {
        long oldLength = BooleanBigArrays.length(array);
        return length > oldLength ? BooleanBigArrays.grow(array, length, oldLength) : array;
    }

    @Deprecated
    public static boolean[][] grow(boolean[][] array, long length, long preserve) {
        long oldLength = BooleanBigArrays.length(array);
        return length > oldLength ? BooleanBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    @Deprecated
    public static boolean[][] trim(boolean[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BooleanBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base2 = (boolean[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base2[baseLength - 1] = BooleanArrays.trim(base2[baseLength - 1], residual);
        }
        return base2;
    }

    @Deprecated
    public static boolean[][] setLength(boolean[][] array, long length) {
        return BigArrays.setLength(array, length);
    }

    @Deprecated
    public static boolean[][] copy(boolean[][] array, long offset, long length) {
        return BigArrays.copy(array, offset, length);
    }

    @Deprecated
    public static boolean[][] copy(boolean[][] array) {
        return BigArrays.copy(array);
    }

    @Deprecated
    public static void fill(boolean[][] array, boolean value) {
        int i2 = array.length;
        while (i2-- != 0) {
            Arrays.fill(array[i2], value);
        }
    }

    @Deprecated
    public static void fill(boolean[][] array, long from, long to, boolean value) {
        BigArrays.fill(array, from, to, value);
    }

    @Deprecated
    public static boolean equals(boolean[][] a1, boolean[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(boolean[][] a2) {
        return BigArrays.toString(a2);
    }

    @Deprecated
    public static void ensureFromTo(boolean[][] a2, long from, long to) {
        BigArrays.ensureFromTo(BooleanBigArrays.length(a2), from, to);
    }

    @Deprecated
    public static void ensureOffsetLength(boolean[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(BooleanBigArrays.length(a2), offset, length);
    }

    @Deprecated
    public static void ensureSameLength(boolean[][] a2, boolean[][] b2) {
        if (BooleanBigArrays.length(a2) != BooleanBigArrays.length(b2)) {
            throw new IllegalArgumentException("Array size mismatch: " + BooleanBigArrays.length(a2) + " != " + BooleanBigArrays.length(b2));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    private static void swap(boolean[][] x, long a2, long b2, long n) {
        int i2 = 0;
        while ((long)i2 < n) {
            BigArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static long med3(boolean[][] x, long a2, long b2, long c, BooleanComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a2), BigArrays.get(x, b2));
        int ac = comp.compare(BigArrays.get(x, a2), BigArrays.get(x, c));
        int bc = comp.compare(BigArrays.get(x, b2), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(boolean[][] a2, long from, long to, BooleanComparator comp) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a2, j), BigArrays.get(a2, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a2, i2, m);
        }
    }

    public static void quickSort(boolean[][] x, long from, long to, BooleanComparator comp) {
        long c;
        long a2;
        long len = to - from;
        if (len < 7L) {
            BooleanBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = BooleanBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = BooleanBigArrays.med3(x, m - s, m, m + s, comp);
                n = BooleanBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = BooleanBigArrays.med3(x, l, m, n, comp);
        }
        boolean v = BigArrays.get(x, m);
        long b2 = a2 = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(BigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BigArrays.swap(x, b2++, c--);
        }
        long n = to;
        long s = Math.min(a2 - from, b2 - a2);
        BooleanBigArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, n - d - 1L);
        BooleanBigArrays.swap(x, b2, n - s, s);
        s = b2 - a2;
        if (s > 1L) {
            BooleanBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            BooleanBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(boolean[][] x, long a2, long b2, long c) {
        int ab = Boolean.compare(BigArrays.get(x, a2), BigArrays.get(x, b2));
        int ac = Boolean.compare(BigArrays.get(x, a2), BigArrays.get(x, c));
        int bc = Boolean.compare(BigArrays.get(x, b2), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(boolean[][] a2, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a2, j) || !BigArrays.get(a2, m)) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a2, i2, m);
        }
    }

    public static void quickSort(boolean[][] x, BooleanComparator comp) {
        BooleanBigArrays.quickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static void quickSort(boolean[][] x, long from, long to) {
        long c;
        long a2;
        long len = to - from;
        if (len < 7L) {
            BooleanBigArrays.selectionSort(x, from, to);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = BooleanBigArrays.med3(x, l, l + s, l + 2L * s);
                m = BooleanBigArrays.med3(x, m - s, m, m + s);
                n = BooleanBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = BooleanBigArrays.med3(x, l, m, n);
        }
        boolean v = BigArrays.get(x, m);
        long b2 = a2 = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Boolean.compare(BigArrays.get(x, b2), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Boolean.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BigArrays.swap(x, b2++, c--);
        }
        long n = to;
        long s = Math.min(a2 - from, b2 - a2);
        BooleanBigArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, n - d - 1L);
        BooleanBigArrays.swap(x, b2, n - s, s);
        s = b2 - a2;
        if (s > 1L) {
            BooleanBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1L) {
            BooleanBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(boolean[][] x) {
        BooleanBigArrays.quickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(boolean[][] x, long from, long to) {
        ForkJoinPool pool = BooleanBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            BooleanBigArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(boolean[][] x) {
        BooleanBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(boolean[][] x, long from, long to, BooleanComparator comp) {
        ForkJoinPool pool = BooleanBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            BooleanBigArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(boolean[][] x, BooleanComparator comp) {
        BooleanBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static boolean[][] shuffle(boolean[][] a2, long from, long to, Random random) {
        return BigArrays.shuffle(a2, from, to, random);
    }

    public static boolean[][] shuffle(boolean[][] a2, Random random) {
        return BigArrays.shuffle(a2, random);
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final boolean[][] x;

        public ForkJoinQuickSort(boolean[][] x, long from, long to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            long c;
            long a2;
            boolean[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                BooleanBigArrays.quickSort(x, this.from, this.to);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = BooleanBigArrays.med3(x, l, l + s, l + 2L * s);
            m = BooleanBigArrays.med3(x, m - s, m, m + s);
            n = BooleanBigArrays.med3(x, n - 2L * s, n - s, n);
            m = BooleanBigArrays.med3(x, l, m, n);
            boolean v = BigArrays.get(x, m);
            long b2 = a2 = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Boolean.compare(BigArrays.get(x, b2), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Boolean.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BigArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            BooleanBigArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            BooleanBigArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final boolean[][] x;
        private final BooleanComparator comp;

        public ForkJoinQuickSortComp(boolean[][] x, long from, long to, BooleanComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            long c;
            long a2;
            boolean[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                BooleanBigArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = BooleanBigArrays.med3(x, l, l + s, l + 2L * s, this.comp);
            m = BooleanBigArrays.med3(x, m - s, m, m + s, this.comp);
            n = BooleanBigArrays.med3(x, n - 2L * s, n - s, n, this.comp);
            m = BooleanBigArrays.med3(x, l, m, n, this.comp);
            boolean v = BigArrays.get(x, m);
            long b2 = a2 = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = this.comp.compare(BigArrays.get(x, b2), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = this.comp.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BigArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            BooleanBigArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            BooleanBigArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<boolean[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(boolean[][] a2, boolean[][] b2) {
            return BooleanBigArrays.equals(a2, b2);
        }
    }
}

