/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public final class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    public static final boolean[] DEFAULT_EMPTY_ARRAY = new boolean[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    private BooleanArrays() {
    }

    public static boolean[] forceCapacity(boolean[] array, int length, int preserve) {
        boolean[] t = new boolean[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static boolean[] ensureCapacity(boolean[] array, int length) {
        return BooleanArrays.ensureCapacity(array, length, array.length);
    }

    public static boolean[] ensureCapacity(boolean[] array, int length, int preserve) {
        return length > array.length ? BooleanArrays.forceCapacity(array, length, preserve) : array;
    }

    public static boolean[] grow(boolean[] array, int length) {
        return BooleanArrays.grow(array, length, array.length);
    }

    public static boolean[] grow(boolean[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min((long)array.length + (long)(array.length >> 1), 0x7FFFFFF7L), (long)length);
            boolean[] t = new boolean[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static boolean[] trim(boolean[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        boolean[] t = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static boolean[] setLength(boolean[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return BooleanArrays.trim(array, length);
        }
        return BooleanArrays.ensureCapacity(array, length);
    }

    public static boolean[] copy(boolean[] array, int offset, int length) {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        boolean[] a2 = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static boolean[] copy(boolean[] array) {
        return (boolean[])array.clone();
    }

    @Deprecated
    public static void fill(boolean[] array, boolean value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    @Deprecated
    public static void fill(boolean[] array, int from, int to, boolean value) {
        BooleanArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(boolean[] a1, boolean[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(boolean[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(boolean[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    public static void ensureSameLength(boolean[] a2, boolean[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a2.length + " != " + b2.length);
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    public static void swap(boolean[] x, int a2, int b2) {
        boolean t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(boolean[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            BooleanArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(boolean[] x, int a2, int b2, int c, BooleanComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            boolean u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            boolean t = a2[i2];
            int j = i2;
            boolean u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(boolean[] x, int from, int to, BooleanComparator comp) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            BooleanArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = BooleanArrays.med3(x, m - s, m, m + s, comp);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = BooleanArrays.med3(x, l, m, n, comp);
        boolean v = x[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BooleanArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        BooleanArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            BooleanArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static void quickSort(boolean[] x, BooleanComparator comp) {
        BooleanArrays.quickSort(x, 0, x.length, comp);
    }

    public static void parallelQuickSort(boolean[] x, int from, int to, BooleanComparator comp) {
        ForkJoinPool pool = BooleanArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            BooleanArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(boolean[] x, BooleanComparator comp) {
        BooleanArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static int med3(boolean[] x, int a2, int b2, int c) {
        int ab = Boolean.compare(x[a2], x[b2]);
        int ac = Boolean.compare(x[a2], x[c]);
        int bc = Boolean.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(boolean[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a2[j] || !a2[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            boolean u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(boolean[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            boolean t = a2[i2];
            int j = i2;
            boolean u = a2[j - 1];
            while (!t && u) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(boolean[] x, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            BooleanArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s);
            m = BooleanArrays.med3(x, m - s, m, m + s);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = BooleanArrays.med3(x, l, m, n);
        boolean v = x[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Boolean.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Boolean.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BooleanArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        BooleanArrays.swap(x, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            BooleanArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, to - s, to);
        }
    }

    public static void quickSort(boolean[] x) {
        BooleanArrays.quickSort(x, 0, x.length);
    }

    public static void parallelQuickSort(boolean[] x, int from, int to) {
        ForkJoinPool pool = BooleanArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            BooleanArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(boolean[] x) {
        BooleanArrays.parallelQuickSort(x, 0, x.length);
    }

    private static int med3Indirect(int[] perm, boolean[] x, int a2, int b2, int c) {
        boolean aa = x[perm[a2]];
        boolean bb = x[perm[b2]];
        boolean cc = x[perm[c]];
        int ab = Boolean.compare(aa, bb);
        int ac = Boolean.compare(aa, cc);
        int bc = Boolean.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void insertionSortIndirect(int[] perm, boolean[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j = i2;
            int u = perm[j - 1];
            while (!a2[t] && a2[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void quickSortIndirect(int[] perm, boolean[] x, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            BooleanArrays.insertionSortIndirect(perm, x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3Indirect(perm, x, l, l + s, l + 2 * s);
            m = BooleanArrays.med3Indirect(perm, x, m - s, m, m + s);
            n = BooleanArrays.med3Indirect(perm, x, n - 2 * s, n - s, n);
        }
        m = BooleanArrays.med3Indirect(perm, x, l, m, n);
        boolean v = x[perm[m]];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Boolean.compare(x[perm[b2]], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Boolean.compare(x[perm[c]], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(perm, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(perm, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(perm, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            BooleanArrays.quickSortIndirect(perm, x, from, from + s);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSortIndirect(perm, x, to - s, to);
        }
    }

    public static void quickSortIndirect(int[] perm, boolean[] x) {
        BooleanArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static void parallelQuickSortIndirect(int[] perm, boolean[] x, int from, int to) {
        ForkJoinPool pool = BooleanArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            BooleanArrays.quickSortIndirect(perm, x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSortIndirect(perm, x, from, to));
        }
    }

    public static void parallelQuickSortIndirect(int[] perm, boolean[] x) {
        BooleanArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static void stabilize(int[] perm, boolean[] x, int from, int to) {
        int curr = from;
        for (int i2 = from + 1; i2 < to; ++i2) {
            if (x[perm[i2]] == x[perm[curr]]) continue;
            if (i2 - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i2);
            }
            curr = i2;
        }
        if (to - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to);
        }
    }

    public static void stabilize(int[] perm, boolean[] x) {
        BooleanArrays.stabilize(perm, x, 0, perm.length);
    }

    private static int med3(boolean[] x, boolean[] y, int a2, int b2, int c) {
        int bc;
        int t = Boolean.compare(x[a2], x[b2]);
        int ab = t == 0 ? Boolean.compare(y[a2], y[b2]) : t;
        t = Boolean.compare(x[a2], x[c]);
        int ac = t == 0 ? Boolean.compare(y[a2], y[c]) : t;
        t = Boolean.compare(x[b2], x[c]);
        int n = bc = t == 0 ? Boolean.compare(y[b2], y[c]) : t;
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void swap(boolean[] x, boolean[] y, int a2, int b2) {
        boolean t = x[a2];
        boolean u = y[a2];
        x[a2] = x[b2];
        y[a2] = y[b2];
        x[b2] = t;
        y[b2] = u;
    }

    private static void swap(boolean[] x, boolean[] y, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            BooleanArrays.swap(x, y, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static void selectionSort(boolean[] a2, boolean[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                int u = Boolean.compare(a2[j], a2[m]);
                if (u >= 0 && (u != 0 || b2[j] || !b2[m])) continue;
                m = j;
            }
            if (m == i2) continue;
            boolean t = a2[i2];
            a2[i2] = a2[m];
            a2[m] = t;
            t = b2[i2];
            b2[i2] = b2[m];
            b2[m] = t;
        }
    }

    public static void quickSort(boolean[] x, boolean[] y, int from, int to) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            BooleanArrays.selectionSort(x, y, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, y, l, l + s, l + 2 * s);
            m = BooleanArrays.med3(x, y, m - s, m, m + s);
            n = BooleanArrays.med3(x, y, n - 2 * s, n - s, n);
        }
        m = BooleanArrays.med3(x, y, l, m, n);
        boolean v = x[m];
        boolean w = y[m];
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int t;
            int comparison;
            if (b2 <= c && (comparison = (t = Boolean.compare(x[b2], v)) == 0 ? Boolean.compare(y[b2], w) : t) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, y, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = (t = Boolean.compare(x[c], v)) == 0 ? Boolean.compare(y[c], w) : t) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, y, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            BooleanArrays.swap(x, y, b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        BooleanArrays.swap(x, y, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, y, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            BooleanArrays.quickSort(x, y, from, from + s);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, y, to - s, to);
        }
    }

    public static void quickSort(boolean[] x, boolean[] y) {
        BooleanArrays.ensureSameLength(x, y);
        BooleanArrays.quickSort(x, y, 0, x.length);
    }

    public static void parallelQuickSort(boolean[] x, boolean[] y, int from, int to) {
        ForkJoinPool pool = BooleanArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            BooleanArrays.quickSort(x, y, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort2(x, y, from, to));
        }
    }

    public static void parallelQuickSort(boolean[] x, boolean[] y) {
        BooleanArrays.ensureSameLength(x, y);
        BooleanArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static void unstableSort(boolean[] a2, int from, int to) {
        BooleanArrays.quickSort(a2, from, to);
    }

    public static void unstableSort(boolean[] a2) {
        BooleanArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        BooleanArrays.quickSort(a2, from, to, comp);
    }

    public static void unstableSort(boolean[] a2, BooleanComparator comp) {
        BooleanArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(boolean[] a2, int from, int to, boolean[] supp) {
        int len = to - from;
        if (len < 16) {
            BooleanArrays.insertionSort(a2, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, a2);
        BooleanArrays.mergeSort(supp, mid, to, a2);
        if (!supp[mid - 1] || supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && (!supp[p2] || supp[q2]) ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(boolean[] a2, int from, int to) {
        BooleanArrays.mergeSort(a2, from, to, (boolean[])null);
    }

    public static void mergeSort(boolean[] a2) {
        BooleanArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(boolean[] a2, int from, int to, BooleanComparator comp, boolean[] supp) {
        int len = to - from;
        if (len < 16) {
            BooleanArrays.insertionSort(a2, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, comp, a2);
        BooleanArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, from, to, comp, null);
    }

    public static void mergeSort(boolean[] a2, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static void stableSort(boolean[] a2, int from, int to) {
        BooleanArrays.unstableSort(a2, from, to);
    }

    public static void stableSort(boolean[] a2) {
        BooleanArrays.stableSort(a2, 0, a2.length);
    }

    public static void stableSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, from, to, comp);
    }

    public static void stableSort(boolean[] a2, BooleanComparator comp) {
        BooleanArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static boolean[] shuffle(boolean[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            boolean t = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t;
        }
        return a2;
    }

    public static boolean[] shuffle(boolean[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            boolean t = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t;
        }
        return a2;
    }

    public static boolean[] reverse(boolean[] a2) {
        int length = a2.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            boolean t = a2[length - i2 - 1];
            a2[length - i2 - 1] = a2[i2];
            a2[i2] = t;
        }
        return a2;
    }

    public static boolean[] reverse(boolean[] a2, int from, int to) {
        int length = to - from;
        int i2 = length / 2;
        while (i2-- != 0) {
            boolean t = a2[from + length - i2 - 1];
            a2[from + length - i2 - 1] = a2[from + i2];
            a2[from + i2] = t;
        }
        return a2;
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final boolean[] x;
        private final BooleanComparator comp;

        public ForkJoinQuickSortComp(boolean[] x, int from, int to, BooleanComparator comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            boolean[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                BooleanArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s, this.comp);
            m = BooleanArrays.med3(x, m - s, m, m + s, this.comp);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n, this.comp);
            m = BooleanArrays.med3(x, l, m, n, this.comp);
            boolean v = x[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = this.comp.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        BooleanArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = this.comp.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        BooleanArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BooleanArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            BooleanArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            BooleanArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final boolean[] x;

        public ForkJoinQuickSort(boolean[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            boolean[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                BooleanArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s);
            m = BooleanArrays.med3(x, m - s, m, m + s);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n);
            m = BooleanArrays.med3(x, l, m, n);
            boolean v = x[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Boolean.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        BooleanArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Boolean.compare(x[c], v)) >= 0) {
                    if (comparison == 0) {
                        BooleanArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BooleanArrays.swap(x, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            BooleanArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            BooleanArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final boolean[] x;

        public ForkJoinQuickSortIndirect(int[] perm, boolean[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            boolean[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                BooleanArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = BooleanArrays.med3Indirect(this.perm, x, l, l + s, l + 2 * s);
            m = BooleanArrays.med3Indirect(this.perm, x, m - s, m, m + s);
            n = BooleanArrays.med3Indirect(this.perm, x, n - 2 * s, n - s, n);
            m = BooleanArrays.med3Indirect(this.perm, x, l, m, n);
            boolean v = x[this.perm[m]];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = Boolean.compare(x[this.perm[b2]], v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = Boolean.compare(x[this.perm[c]], v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                IntArrays.swap(this.perm, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(this.perm, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            IntArrays.swap(this.perm, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s), new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.from, this.from + s));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect(this.perm, x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort2
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final boolean[] x;
        private final boolean[] y;

        public ForkJoinQuickSort2(boolean[] x, boolean[] y, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            boolean[] x = this.x;
            boolean[] y = this.y;
            int len = this.to - this.from;
            if (len < 8192) {
                BooleanArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = BooleanArrays.med3(x, y, l, l + s, l + 2 * s);
            m = BooleanArrays.med3(x, y, m - s, m, m + s);
            n = BooleanArrays.med3(x, y, n - 2 * s, n - s, n);
            m = BooleanArrays.med3(x, y, l, m, n);
            boolean v = x[m];
            boolean w = y[m];
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int t;
                int comparison;
                if (b2 <= c && (comparison = (t = Boolean.compare(x[b2], v)) == 0 ? Boolean.compare(y[b2], w) : t) <= 0) {
                    if (comparison == 0) {
                        BooleanArrays.swap(x, y, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = (t = Boolean.compare(x[c], v)) == 0 ? Boolean.compare(y[c], w) : t) >= 0) {
                    if (comparison == 0) {
                        BooleanArrays.swap(x, y, c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                BooleanArrays.swap(x, y, b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            BooleanArrays.swap(x, y, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            BooleanArrays.swap(x, y, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s), new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.from, this.from + s));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2(x, y, this.to - t, this.to));
            }
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(boolean[] a2, boolean[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

