/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public class Arrays {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int MERGESORT_NO_REC = 16;
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;

    private Arrays() {
    }

    public static void ensureFromTo(int arrayLength, int from, int to) {
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + arrayLength + ")");
        }
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }

    private static void inPlaceMerge(int from, int mid, int to, IntComparator comp, Swapper swapper) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(mid, from) < 0) {
                swapper.swap(from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = Arrays.lowerBound(mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = Arrays.upperBound(from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        Arrays.inPlaceMerge(from, firstCut, mid, comp, swapper);
        Arrays.inPlaceMerge(mid, secondCut, to, comp, swapper);
    }

    private static int lowerBound(int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(middle, pos) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(int from, int mid, int pos, IntComparator comp) {
        int len = mid - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(pos, middle) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    private static int med3(int a2, int b2, int c, IntComparator comp) {
        int ab = comp.compare(a2, b2);
        int ac = comp.compare(a2, c);
        int bc = comp.compare(b2, c);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    public static void mergeSort(int from, int to, IntComparator c, Swapper swapper) {
        int length = to - from;
        if (length < 16) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j = i2; j > from && c.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        Arrays.mergeSort(from, mid, c, swapper);
        Arrays.mergeSort(mid, to, c, swapper);
        if (c.compare(mid - 1, mid) <= 0) {
            return;
        }
        Arrays.inPlaceMerge(from, mid, to, c, swapper);
    }

    protected static void swap(Swapper swapper, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            swapper.swap(a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    public static void parallelQuickSort(int from, int to, IntComparator comp, Swapper swapper) {
        ForkJoinPool pool = Arrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            Arrays.quickSort(from, to, comp, swapper);
        } else {
            pool.invoke(new ForkJoinGenericQuickSort(from, to, comp, swapper));
        }
    }

    public static void quickSort(int from, int to, IntComparator comp, Swapper swapper) {
        int c;
        int a2;
        int len = to - from;
        if (len < 16) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j = i2; j > from && comp.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = Arrays.med3(l, l + s, l + 2 * s, comp);
            m = Arrays.med3(m - s, m, m + s, comp);
            n = Arrays.med3(n - 2 * s, n - s, n, comp);
        }
        m = Arrays.med3(l, m, n, comp);
        int b2 = a2 = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(b2, m)) <= 0) {
                if (comparison == 0) {
                    if (a2 == m) {
                        m = b2;
                    } else if (b2 == m) {
                        m = a2;
                    }
                    swapper.swap(a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            if (b2 == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            swapper.swap(b2++, c--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        Arrays.swap(swapper, from, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        Arrays.swap(swapper, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            Arrays.quickSort(from, from + s, comp, swapper);
        }
        if ((s = d - c) > 1) {
            Arrays.quickSort(to - s, to, comp, swapper);
        }
    }

    protected static class ForkJoinGenericQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final IntComparator comp;
        private final Swapper swapper;

        public ForkJoinGenericQuickSort(int from, int to, IntComparator comp, Swapper swapper) {
            this.from = from;
            this.to = to;
            this.comp = comp;
            this.swapper = swapper;
        }

        @Override
        protected void compute() {
            int c;
            int a2;
            int len = this.to - this.from;
            if (len < 8192) {
                Arrays.quickSort(this.from, this.to, this.comp, this.swapper);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = Arrays.med3(l, l + s, l + 2 * s, this.comp);
            m = Arrays.med3(m - s, m, m + s, this.comp);
            n = Arrays.med3(n - 2 * s, n - s, n, this.comp);
            m = Arrays.med3(l, m, n, this.comp);
            int b2 = a2 = this.from;
            int d = c = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c && (comparison = this.comp.compare(b2, m)) <= 0) {
                    if (comparison == 0) {
                        if (a2 == m) {
                            m = b2;
                        } else if (b2 == m) {
                            m = a2;
                        }
                        this.swapper.swap(a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c >= b2 && (comparison = this.comp.compare(c, m)) >= 0) {
                    if (comparison == 0) {
                        if (c == m) {
                            m = d;
                        } else if (d == m) {
                            m = c;
                        }
                        this.swapper.swap(c, d--);
                    }
                    --c;
                }
                if (b2 > c) break;
                if (b2 == m) {
                    m = d;
                } else if (c == m) {
                    m = c;
                }
                this.swapper.swap(b2++, c--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            Arrays.swap(this.swapper, this.from, b2 - s, s);
            s = Math.min(d - c, this.to - d - 1);
            Arrays.swap(this.swapper, b2, this.to - s, s);
            s = b2 - a2;
            int t = d - c;
            if (s > 1 && t > 1) {
                ForkJoinGenericQuickSort.invokeAll(new ForkJoinGenericQuickSort(this.from, this.from + s, this.comp, this.swapper), new ForkJoinGenericQuickSort(this.to - t, this.to, this.comp, this.swapper));
            } else if (s > 1) {
                ForkJoinGenericQuickSort.invokeAll(new ForkJoinGenericQuickSort(this.from, this.from + s, this.comp, this.swapper));
            } else {
                ForkJoinGenericQuickSort.invokeAll(new ForkJoinGenericQuickSort(this.to - t, this.to, this.comp, this.swapper));
            }
        }
    }
}

