/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APIOptions;

public class ConsoleProcessListChildProcessMain {
    static final String PREFIX = "Process list count: ";
    static final String SUFFIX = " attached to the console";

    public static void main(String[] args2) {
        int pid;
        if (args2.length != 1) {
            System.err.println("single argument expected: pid");
            return;
        }
        try {
            pid = Integer.parseInt(args2[0]);
        }
        catch (NumberFormatException e) {
            System.err.println("Cannot parse pid from " + args2[0]);
            return;
        }
        if (!Kernel32.INSTANCE.FreeConsole()) {
            System.err.println(LastErrorExceptionEx.getErrorMessage("FreeConsole"));
            return;
        }
        if (!Kernel32.INSTANCE.AttachConsole(pid)) {
            System.err.println(LastErrorExceptionEx.getErrorMessage("AttachConsole"));
            return;
        }
        int MAX_COUNT = 64;
        Memory buffer = new Memory(4 * MAX_COUNT);
        WinDef.DWORD result2 = MyConsoleLibrary.INSTANCE.GetConsoleProcessList(buffer, new WinDef.DWORD((long)MAX_COUNT));
        int count2 = result2.intValue();
        if (count2 == 0) {
            System.err.println(LastErrorExceptionEx.getErrorMessage("GetConsoleProcessList"));
            return;
        }
        System.out.println(PREFIX + count2 + SUFFIX);
    }

    private static interface MyConsoleLibrary
    extends Library {
        public static final MyConsoleLibrary INSTANCE = Native.load("kernel32", MyConsoleLibrary.class, W32APIOptions.DEFAULT_OPTIONS);

        public WinDef.DWORD GetConsoleProcessList(Pointer var1, WinDef.DWORD var2);
    }
}

