/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.NamedPipe;
import com.pty4j.windows.WinPty;
import java.io.IOException;
import java.io.OutputStream;

public class WinPTYOutputStream
extends OutputStream {
    private final WinPty myWinPty;
    private final NamedPipe myNamedPipe;
    private final boolean myPatchNewline;
    private final boolean mySendEOF;

    public WinPTYOutputStream(WinPty winPty, NamedPipe namedPipe, boolean patchNewline, boolean sendEOF) {
        this.myWinPty = winPty;
        this.myNamedPipe = namedPipe;
        this.myPatchNewline = patchNewline;
        this.mySendEOF = sendEOF;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.myPatchNewline) {
            byte[] newBuf = new byte[len];
            int newPos = 0;
            for (int i2 = off; i2 < off + len; ++i2) {
                newBuf[newPos++] = b2[i2] == 10 ? 13 : b2[i2];
            }
            b2 = newBuf;
            off = 0;
            len = newPos;
        }
        this.myNamedPipe.write(b2, off, len);
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] buf = new byte[]{(byte)b2};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.mySendEOF) {
            this.write(new byte[]{94, 90, 10});
        }
        this.myNamedPipe.close();
    }
}

