/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.util.PtyUtil;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class WinHelper {
    private WinHelper() {
    }

    @NotNull
    public static String getCurrentDirectory(long processId) throws IOException {
        if (!Platform.isWindows()) {
            throw new IOException("Should be called on Windows OS only");
        }
        PointerByReference errorMessageRef = new PointerByReference();
        Pointer currentDirectory = Holder.INSTANCE.getCurrentDirectory(new WinDef.DWORD(processId), errorMessageRef);
        Pointer errorMessagePtr = errorMessageRef.getValue();
        if (currentDirectory != null) {
            if (errorMessagePtr != null) {
                throw new IOException("Unexpected error message: " + WinHelper.getStringAndFree(errorMessagePtr));
            }
            return WinHelper.getStringAndFree(currentDirectory);
        }
        if (errorMessagePtr == null) {
            throw new IOException("getCurrentDirectory failed without error message");
        }
        throw new IOException("getCurrentDirectory failed: " + WinHelper.getStringAndFree(errorMessagePtr));
    }

    @NotNull
    private static String getStringAndFree(@NotNull Pointer stringPtr) {
        String result2 = stringPtr.getWideString(0L);
        Native.free(Pointer.nativeValue(stringPtr));
        return result2;
    }

    private static class Holder {
        private static final WinHelperNativeLibrary INSTANCE = Native.load(PtyUtil.resolveNativeFile("win-helper.dll").getAbsolutePath(), WinHelperNativeLibrary.class);

        private Holder() {
        }
    }

    private static interface WinHelperNativeLibrary
    extends Library {
        public Pointer getCurrentDirectory(WinDef.DWORD var1, PointerByReference var2);
    }
}

