/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.NamedPipe;
import java.io.IOException;
import java.io.OutputStream;

public class CygwinPTYOutputStream
extends OutputStream {
    private final NamedPipe myNamedPipe;
    private boolean myClosed;

    public CygwinPTYOutputStream(NamedPipe namedPipe) {
        this.myNamedPipe = namedPipe;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.myClosed) {
            return;
        }
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.myNamedPipe.write(b2, off, len);
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] buf = new byte[]{(byte)b2};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.myClosed = true;
        this.myNamedPipe.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

