/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import com.pty4j.util.Pair;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class LazyValue<T> {
    private final Callable<T> myProvider;
    private final Object myLock = new Object();
    private volatile Pair<T, Throwable> myResult;

    public LazyValue(@NotNull Callable<T> provider) {
        this.myProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() throws Exception {
        Pair<Object, Throwable> result2 = this.myResult;
        if (result2 != null) {
            return this.unpack(result2);
        }
        Object object = this.myLock;
        synchronized (object) {
            result2 = this.myResult;
            if (result2 == null) {
                try {
                    T value = this.myProvider.call();
                    result2 = Pair.create(value, null);
                }
                catch (Throwable t) {
                    result2 = Pair.create(null, t);
                }
                this.myResult = result2;
            }
        }
        return this.unpack(result2);
    }

    private T unpack(@NotNull Pair<T, Throwable> result2) throws Exception {
        if (result2.second != null) {
            if (result2.second instanceof Exception) {
                throw (Exception)result2.second;
            }
            if (result2.second instanceof Error) {
                throw (Error)result2.second;
            }
            throw new RuntimeException("Rethrowing unknown Throwable", (Throwable)result2.second);
        }
        return (T)result2.first;
    }
}

