/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.AbstractFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PanelBuilder
extends AbstractFormBuilder {
    private ComponentFactory componentFactory;

    public PanelBuilder(FormLayout layout) {
        this(layout, new JPanel(null));
    }

    public PanelBuilder(FormLayout layout, JPanel panel) {
        super(layout, panel);
    }

    public PanelBuilder(JPanel panel, FormLayout layout) {
        super(layout, panel);
    }

    public final JPanel getPanel() {
        return (JPanel)this.getContainer();
    }

    public final void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    public final void setDefaultDialogBorder() {
        this.setBorder(Borders.DIALOG_BORDER);
    }

    public final JLabel addLabel(String textWithMnemonic) {
        return this.addLabel(textWithMnemonic, this.cellConstraints());
    }

    public final JLabel addLabel(String textWithMnemonic, CellConstraints constraints) {
        JLabel label2 = this.getComponentFactory().createLabel(textWithMnemonic);
        this.add((Component)label2, constraints);
        return label2;
    }

    public final JLabel addLabel(String textWithMnemonic, String encodedConstraints) {
        return this.addLabel(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JLabel add(JLabel label2, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        this.add((Component)label2, labelConstraints);
        this.add(component, componentConstraints);
        label2.setLabelFor(component);
        return label2;
    }

    public final JLabel addLabel(String textWithMnemonic, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        JLabel label2 = this.addLabel(textWithMnemonic, labelConstraints);
        this.add(component, componentConstraints);
        label2.setLabelFor(component);
        return label2;
    }

    public final JLabel addTitle(String textWithMnemonic) {
        return this.addTitle(textWithMnemonic, this.cellConstraints());
    }

    public final JLabel addTitle(String textWithMnemonic, CellConstraints constraints) {
        JLabel titleLabel = this.getComponentFactory().createTitle(textWithMnemonic);
        this.add((Component)titleLabel, constraints);
        return titleLabel;
    }

    public final JLabel addTitle(String textWithMnemonic, String encodedConstraints) {
        return this.addTitle(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JComponent addSeparator(String textWithMnemonic) {
        return this.addSeparator(textWithMnemonic, this.getLayout().getColumnCount());
    }

    public final JComponent addSeparator(String textWithMnemonic, CellConstraints constraints) {
        int titleAlignment = this.isLeftToRight() ? 2 : 4;
        JComponent titledSeparator = this.getComponentFactory().createSeparator(textWithMnemonic, titleAlignment);
        this.add((Component)titledSeparator, constraints);
        return titledSeparator;
    }

    public final JComponent addSeparator(String textWithMnemonic, String encodedConstraints) {
        return this.addSeparator(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JComponent addSeparator(String textWithMnemonic, int columnSpan) {
        return this.addSeparator(textWithMnemonic, this.createLeftAdjustedConstraints(columnSpan));
    }

    public final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = DefaultComponentFactory.getInstance();
        }
        return this.componentFactory;
    }

    public final void setComponentFactory(ComponentFactory newFactory) {
        this.componentFactory = newFactory;
    }
}

