/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.stax;

import com.fasterxml.aalto.AsyncByteArrayFeeder;
import com.fasterxml.aalto.AsyncByteBufferFeeder;
import com.fasterxml.aalto.AsyncXMLInputFactory;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.async.AsyncByteArrayScanner;
import com.fasterxml.aalto.async.AsyncByteBufferScanner;
import com.fasterxml.aalto.async.AsyncStreamReaderImpl;
import com.fasterxml.aalto.dom.DOMReaderImpl;
import com.fasterxml.aalto.evt.EventAllocatorImpl;
import com.fasterxml.aalto.evt.EventReaderImpl;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.ByteSourceBootstrapper;
import com.fasterxml.aalto.in.CharSourceBootstrapper;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.stax.StreamReaderImpl;
import com.fasterxml.aalto.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.io.Stax2CharArraySource;
import org.codehaus.stax2.io.Stax2Source;
import org.codehaus.stax2.ri.Stax2FilteredStreamReader;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;
import org.codehaus.stax2.ri.evt.Stax2EventReaderAdapter;
import org.codehaus.stax2.ri.evt.Stax2FilteredEventReader;
import org.xml.sax.InputSource;

public final class InputFactoryImpl
extends AsyncXMLInputFactory {
    final ReaderConfig _config = new ReaderConfig();
    protected XMLEventAllocator _allocator = null;

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter2) {
        return new Stax2FilteredEventReader(Stax2EventReaderAdapter.wrapIfNecessary(reader), filter2);
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter2) throws XMLStreamException {
        Stax2FilteredStreamReader fr = new Stax2FilteredStreamReader(reader, filter2);
        if (!filter2.accept(fr)) {
            fr.next();
        }
        return fr;
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        return this.createXMLEventReader(in, null);
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream in, String enc) throws XMLStreamException {
        return this.constructER(this.constructSR(in, enc, true));
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader r) throws XMLStreamException {
        return this.createXMLEventReader(null, r);
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source2) throws XMLStreamException {
        return this.constructER(this.constructSR(source2, true));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream in) throws XMLStreamException {
        return this.constructER(this.constructSR(systemId, in, true));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader r) throws XMLStreamException {
        return this.constructER(this.constructSR(systemId, r, true));
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader sr) throws XMLStreamException {
        return this.constructER(Stax2ReaderAdapter.wrapIfNecessary(sr));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.constructSR(in, null, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        return this.constructSR(in, enc, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.constructSR(null, r, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.constructSR(systemId, r, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source src) throws XMLStreamException {
        return this.constructSR(src, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.constructSR(systemId, in, false);
    }

    @Override
    public Object getProperty(String name) {
        return this._config.getProperty(name, true);
    }

    @Override
    public void setProperty(String propName, Object value) {
        this._config.setProperty(propName, value);
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this._allocator;
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this._config.getXMLReporter();
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this._config.getXMLResolver();
    }

    @Override
    public boolean isPropertySupported(String name) {
        return this._config.isPropertySupported(name);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
        this._allocator = allocator;
    }

    @Override
    public void setXMLReporter(XMLReporter r) {
        this._config.setXMLReporter(r);
    }

    @Override
    public void setXMLResolver(XMLResolver r) {
        this._config.setXMLResolver(r);
    }

    @Override
    public XMLEventReader2 createXMLEventReader(URL src) throws XMLStreamException {
        return this.constructER(this.constructSR(src, true));
    }

    @Override
    public XMLEventReader2 createXMLEventReader(File f) throws XMLStreamException {
        return this.constructER(this.constructSR(f, true));
    }

    @Override
    public XMLStreamReader2 createXMLStreamReader(URL src) throws XMLStreamException {
        return this.constructSR(src, false);
    }

    @Override
    public XMLStreamReader2 createXMLStreamReader(File f) throws XMLStreamException {
        return this.constructSR(f, false);
    }

    @Override
    public void configureForXmlConformance() {
        this._config.configureForXmlConformance();
    }

    @Override
    public void configureForConvenience() {
        this._config.configureForConvenience();
    }

    @Override
    public void configureForSpeed() {
        this._config.configureForSpeed();
    }

    @Override
    public void configureForLowMemUsage() {
        this._config.configureForLowMemUsage();
    }

    @Override
    public void configureForRoundTripping() {
        this._config.configureForRoundTripping();
    }

    @Override
    public AsyncXMLStreamReader<AsyncByteArrayFeeder> createAsyncForByteArray() {
        ReaderConfig cfg = this.getNonSharedConfig(null, null, null, false, false);
        cfg.setActualEncoding("UTF-8");
        return new AsyncStreamReaderImpl<AsyncByteArrayFeeder>(new AsyncByteArrayScanner(cfg));
    }

    @Override
    public AsyncXMLStreamReader<AsyncByteArrayFeeder> createAsyncFor(byte[] input2) throws XMLStreamException {
        return this.createAsyncFor(input2, 0, input2.length);
    }

    @Override
    public AsyncXMLStreamReader<AsyncByteArrayFeeder> createAsyncFor(byte[] input2, int offset, int length) throws XMLStreamException {
        ReaderConfig cfg = this.getNonSharedConfig(null, null, null, false, false);
        cfg.setActualEncoding("UTF-8");
        AsyncByteArrayScanner scanner = new AsyncByteArrayScanner(cfg);
        scanner.feedInput(input2, offset, length);
        return new AsyncStreamReaderImpl<AsyncByteArrayFeeder>(scanner);
    }

    @Override
    public AsyncXMLStreamReader<AsyncByteBufferFeeder> createAsyncForByteBuffer() {
        ReaderConfig cfg = this.getNonSharedConfig(null, null, null, false, false);
        cfg.setActualEncoding("UTF-8");
        return new AsyncStreamReaderImpl<AsyncByteBufferFeeder>(new AsyncByteBufferScanner(cfg));
    }

    @Override
    public AsyncXMLStreamReader<AsyncByteBufferFeeder> createAsyncFor(ByteBuffer input2) throws XMLStreamException {
        ReaderConfig cfg = this.getNonSharedConfig(null, null, null, false, false);
        cfg.setActualEncoding("UTF-8");
        AsyncByteBufferScanner scanner = new AsyncByteBufferScanner(cfg);
        scanner.feedInput(input2);
        return new AsyncStreamReaderImpl<AsyncByteBufferFeeder>(scanner);
    }

    public ReaderConfig getNonSharedConfig(String systemId, String publicId, String extEncoding, boolean forEventReader, boolean forceAutoClose) {
        ReaderConfig cfg = this._config.createNonShared(publicId, systemId, extEncoding);
        if (forEventReader) {
            cfg.doParseLazily(false);
        }
        if (forceAutoClose) {
            cfg.doAutoCloseInput(true);
        }
        return cfg;
    }

    protected XMLStreamReader2 constructSR(InputStream in, String enc, boolean forEventReader) throws XMLStreamException {
        ReaderConfig cfg = this.getNonSharedConfig(null, null, enc, forEventReader, false);
        return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
    }

    protected XMLStreamReader2 constructSR(String systemId, Reader r, boolean forEventReader) throws XMLStreamException {
        ReaderConfig cfg = this.getNonSharedConfig(null, systemId, null, forEventReader, false);
        return StreamReaderImpl.construct(CharSourceBootstrapper.construct(cfg, r));
    }

    protected XMLStreamReader2 constructSR(String systemId, InputStream in, boolean forEventReader) throws XMLStreamException {
        ReaderConfig cfg = this.getNonSharedConfig(null, systemId, null, forEventReader, false);
        return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
    }

    protected XMLStreamReader2 constructSR(Source src, boolean forEventReader) throws XMLStreamException {
        ReaderConfig cfg;
        boolean autoCloseInput;
        Source ss;
        if (src instanceof Stax2Source) {
            return this.constructSR2((Stax2Source)src, forEventReader);
        }
        Reader r = null;
        InputStream in = null;
        String pubId = null;
        String sysId = null;
        String encoding = null;
        if (src instanceof StreamSource) {
            ss = (StreamSource)src;
            sysId = ((StreamSource)ss).getSystemId();
            pubId = ((StreamSource)ss).getPublicId();
            in = ((StreamSource)ss).getInputStream();
            if (in == null) {
                r = ((StreamSource)ss).getReader();
            }
            autoCloseInput = false;
        } else if (src instanceof SAXSource) {
            ss = (SAXSource)src;
            sysId = ((SAXSource)ss).getSystemId();
            InputSource isrc = ((SAXSource)ss).getInputSource();
            if (isrc != null) {
                sysId = isrc.getSystemId();
                pubId = isrc.getPublicId();
                encoding = isrc.getEncoding();
                in = isrc.getByteStream();
                if (in == null) {
                    r = isrc.getCharacterStream();
                }
            }
            autoCloseInput = false;
        } else {
            if (src instanceof DOMSource) {
                boolean autoCloseInput2 = false;
                ReaderConfig cfg2 = this.getNonSharedConfig(pubId, sysId, encoding, forEventReader, autoCloseInput2);
                return DOMReaderImpl.createFrom((DOMSource)src, cfg2);
            }
            throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unrecognized type)");
        }
        if (in != null) {
            cfg = this.getNonSharedConfig(pubId, sysId, encoding, forEventReader, autoCloseInput);
            return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
        }
        if (r != null) {
            cfg = this.getNonSharedConfig(pubId, sysId, encoding, forEventReader, autoCloseInput);
            return StreamReaderImpl.construct(CharSourceBootstrapper.construct(cfg, r));
        }
        if (sysId != null && sysId.length() > 0) {
            autoCloseInput = true;
            cfg = this.getNonSharedConfig(pubId, sysId, encoding, forEventReader, autoCloseInput);
            try {
                URL url = URLUtil.urlFromSystemId(sysId);
                in = URLUtil.inputStreamFromURL(url);
                return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
            }
            catch (IOException ioe) {
                throw new IoStreamException(ioe);
            }
        }
        throw new XMLStreamException("Can not create Stax reader for the Source passed -- neither reader, input stream nor system id was accessible; can not use other types of sources (like embedded SAX streams)");
    }

    protected XMLStreamReader2 constructSR2(Stax2Source ss, boolean forEventReader) throws XMLStreamException {
        ReaderConfig cfg = this.getNonSharedConfig(ss.getPublicId(), ss.getSystemId(), ss.getEncoding(), forEventReader, true);
        if (ss instanceof Stax2ByteArraySource) {
            Stax2ByteArraySource bs = (Stax2ByteArraySource)ss;
            return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, bs.getBuffer(), bs.getBufferStart(), bs.getBufferLength()));
        }
        if (ss instanceof Stax2CharArraySource) {
            Stax2CharArraySource cs = (Stax2CharArraySource)ss;
            return StreamReaderImpl.construct(CharSourceBootstrapper.construct(cfg, cs.getBuffer(), cs.getBufferStart(), cs.getBufferLength()));
        }
        try {
            InputStream in = ss.constructInputStream();
            if (in != null) {
                return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
            }
            Reader r = ss.constructReader();
            if (r != null) {
                return StreamReaderImpl.construct(CharSourceBootstrapper.construct(cfg, r));
            }
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        throw new IllegalArgumentException("Can not create stream reader for given Stax2Source: neither InputStream nor Reader available");
    }

    protected XMLStreamReader2 constructSR(URL src, boolean forEventReader) throws XMLStreamException {
        InputStream in;
        try {
            in = URLUtil.inputStreamFromURL(src);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        ReaderConfig cfg = this.getNonSharedConfig(URLUtil.urlToSystemId(src), null, null, forEventReader, true);
        return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
    }

    protected XMLStreamReader2 constructSR(File f, boolean forEventReader) throws XMLStreamException {
        try {
            FileInputStream in = new FileInputStream(f);
            String systemId = URLUtil.fileToSystemId(f);
            ReaderConfig cfg = this.getNonSharedConfig(systemId, null, null, forEventReader, true);
            return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(cfg, in));
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    public XMLEventReader2 constructER(XMLStreamReader2 sr) {
        return new EventReaderImpl(this.createEventAllocator(), sr);
    }

    protected XMLEventAllocator createEventAllocator() {
        if (this._allocator != null) {
            return this._allocator.newInstance();
        }
        return this._config.willPreserveLocation() ? EventAllocatorImpl.getDefaultInstance() : EventAllocatorImpl.getFastInstance();
    }
}

