/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.appengine.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.appengine.v1.AppengineRequest;
import com.google.api.services.appengine.v1.AppengineRequestInitializer;
import com.google.api.services.appengine.v1.model.Application;
import com.google.api.services.appengine.v1.model.DebugInstanceRequest;
import com.google.api.services.appengine.v1.model.Instance;
import com.google.api.services.appengine.v1.model.ListInstancesResponse;
import com.google.api.services.appengine.v1.model.ListLocationsResponse;
import com.google.api.services.appengine.v1.model.ListOperationsResponse;
import com.google.api.services.appengine.v1.model.ListServicesResponse;
import com.google.api.services.appengine.v1.model.ListVersionsResponse;
import com.google.api.services.appengine.v1.model.Location;
import com.google.api.services.appengine.v1.model.Operation;
import com.google.api.services.appengine.v1.model.RepairApplicationRequest;
import com.google.api.services.appengine.v1.model.Service;
import com.google.api.services.appengine.v1.model.Version;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appengine
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://appengine.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://appengine.googleapis.com/";

    public Appengine(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Appengine(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Apps apps() {
        return new Apps();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google App Engine Admin API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://appengine.googleapis.com/", Appengine.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Appengine build() {
            return new Appengine(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAppengineRequestInitializer(AppengineRequestInitializer appengineRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)appengineRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Apps {
        public Create create(Application application) throws IOException {
            Create create = new Create(application);
            Appengine.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Appengine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Patch patch(String string, Application application) throws IOException {
            Patch patch = new Patch(string, application);
            Appengine.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Repair repair(String string, RepairApplicationRequest repairApplicationRequest) throws IOException {
            Repair repair = new Repair(string, repairApplicationRequest);
            Appengine.this.initialize((AbstractGoogleClientRequest<?>)repair);
            return repair;
        }

        public Locations locations() {
            return new Locations();
        }

        public Operations operations() {
            return new Operations();
        }

        public Services services() {
            return new Services();
        }

        public class Services {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Service service) throws IOException {
                Patch patch = new Patch(string, string2, service);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Versions versions() {
                return new Versions();
            }

            public class Versions {
                public Create create(String string, String string2, Version version) throws IOException {
                    Create create = new Create(string, string2, version);
                    Appengine.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Appengine.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Appengine.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Appengine.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, String string2, String string3, Version version) throws IOException {
                    Patch patch = new Patch(string, string2, string3, version);
                    Appengine.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Instances instances() {
                    return new Instances();
                }

                public class Instances {
                    public Debug debug(String string, String string2, String string3, String string4, DebugInstanceRequest debugInstanceRequest) throws IOException {
                        Debug debug = new Debug(string, string2, string3, string4, debugInstanceRequest);
                        Appengine.this.initialize((AbstractGoogleClientRequest<?>)debug);
                        return debug;
                    }

                    public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                        Delete delete = new Delete(string, string2, string3, string4);
                        Appengine.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string, String string2, String string3, String string4) throws IOException {
                        Get get = new Get(string, string2, string3, string4);
                        Appengine.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string, String string2, String string3) throws IOException {
                        List list = new List(string, string2, string3);
                        Appengine.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends AppengineRequest<ListInstancesResponse> {
                        private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances";
                        @Key
                        private String appsId;
                        @Key
                        private String servicesId;
                        @Key
                        private String versionsId;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String string, String string2, String string3) {
                            super(Appengine.this, "GET", REST_PATH, null, ListInstancesResponse.class);
                            this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                            this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                            this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setBearerToken(String string) {
                            return (List)super.setBearerToken(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPp(Boolean bl) {
                            return (List)super.setPp(bl);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getAppsId() {
                            return this.appsId;
                        }

                        public List setAppsId(String string) {
                            this.appsId = string;
                            return this;
                        }

                        public String getServicesId() {
                            return this.servicesId;
                        }

                        public List setServicesId(String string) {
                            this.servicesId = string;
                            return this;
                        }

                        public String getVersionsId() {
                            return this.versionsId;
                        }

                        public List setVersionsId(String string) {
                            this.versionsId = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends AppengineRequest<Instance> {
                        private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}";
                        @Key
                        private String appsId;
                        @Key
                        private String servicesId;
                        @Key
                        private String versionsId;
                        @Key
                        private String instancesId;

                        protected Get(String string, String string2, String string3, String string4) {
                            super(Appengine.this, "GET", REST_PATH, null, Instance.class);
                            this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                            this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                            this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                            this.instancesId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter instancesId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setBearerToken(String string) {
                            return (Get)super.setBearerToken(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPp(Boolean bl) {
                            return (Get)super.setPp(bl);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getAppsId() {
                            return this.appsId;
                        }

                        public Get setAppsId(String string) {
                            this.appsId = string;
                            return this;
                        }

                        public String getServicesId() {
                            return this.servicesId;
                        }

                        public Get setServicesId(String string) {
                            this.servicesId = string;
                            return this;
                        }

                        public String getVersionsId() {
                            return this.versionsId;
                        }

                        public Get setVersionsId(String string) {
                            this.versionsId = string;
                            return this;
                        }

                        public String getInstancesId() {
                            return this.instancesId;
                        }

                        public Get setInstancesId(String string) {
                            this.instancesId = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends AppengineRequest<Operation> {
                        private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}";
                        @Key
                        private String appsId;
                        @Key
                        private String servicesId;
                        @Key
                        private String versionsId;
                        @Key
                        private String instancesId;

                        protected Delete(String string, String string2, String string3, String string4) {
                            super(Appengine.this, "DELETE", REST_PATH, null, Operation.class);
                            this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                            this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                            this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                            this.instancesId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter instancesId must be specified.");
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setBearerToken(String string) {
                            return (Delete)super.setBearerToken(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPp(Boolean bl) {
                            return (Delete)super.setPp(bl);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getAppsId() {
                            return this.appsId;
                        }

                        public Delete setAppsId(String string) {
                            this.appsId = string;
                            return this;
                        }

                        public String getServicesId() {
                            return this.servicesId;
                        }

                        public Delete setServicesId(String string) {
                            this.servicesId = string;
                            return this;
                        }

                        public String getVersionsId() {
                            return this.versionsId;
                        }

                        public Delete setVersionsId(String string) {
                            this.versionsId = string;
                            return this;
                        }

                        public String getInstancesId() {
                            return this.instancesId;
                        }

                        public Delete setInstancesId(String string) {
                            this.instancesId = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Debug
                    extends AppengineRequest<Operation> {
                        private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}:debug";
                        @Key
                        private String appsId;
                        @Key
                        private String servicesId;
                        @Key
                        private String versionsId;
                        @Key
                        private String instancesId;

                        protected Debug(String string, String string2, String string3, String string4, DebugInstanceRequest debugInstanceRequest) {
                            super(Appengine.this, "POST", REST_PATH, (Object)debugInstanceRequest, Operation.class);
                            this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                            this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                            this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                            this.instancesId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter instancesId must be specified.");
                        }

                        public Debug set$Xgafv(String string) {
                            return (Debug)super.set$Xgafv(string);
                        }

                        public Debug setAccessToken(String string) {
                            return (Debug)super.setAccessToken(string);
                        }

                        public Debug setAlt(String string) {
                            return (Debug)super.setAlt(string);
                        }

                        public Debug setBearerToken(String string) {
                            return (Debug)super.setBearerToken(string);
                        }

                        public Debug setCallback(String string) {
                            return (Debug)super.setCallback(string);
                        }

                        public Debug setFields(String string) {
                            return (Debug)super.setFields(string);
                        }

                        public Debug setKey(String string) {
                            return (Debug)super.setKey(string);
                        }

                        public Debug setOauthToken(String string) {
                            return (Debug)super.setOauthToken(string);
                        }

                        public Debug setPp(Boolean bl) {
                            return (Debug)super.setPp(bl);
                        }

                        public Debug setPrettyPrint(Boolean bl) {
                            return (Debug)super.setPrettyPrint(bl);
                        }

                        public Debug setQuotaUser(String string) {
                            return (Debug)super.setQuotaUser(string);
                        }

                        public Debug setUploadType(String string) {
                            return (Debug)super.setUploadType(string);
                        }

                        public Debug setUploadProtocol(String string) {
                            return (Debug)super.setUploadProtocol(string);
                        }

                        public String getAppsId() {
                            return this.appsId;
                        }

                        public Debug setAppsId(String string) {
                            this.appsId = string;
                            return this;
                        }

                        public String getServicesId() {
                            return this.servicesId;
                        }

                        public Debug setServicesId(String string) {
                            this.servicesId = string;
                            return this;
                        }

                        public String getVersionsId() {
                            return this.versionsId;
                        }

                        public Debug setVersionsId(String string) {
                            this.versionsId = string;
                            return this;
                        }

                        public String getInstancesId() {
                            return this.instancesId;
                        }

                        public Debug setInstancesId(String string) {
                            this.instancesId = string;
                            return this;
                        }

                        @Override
                        public Debug set(String string, Object object) {
                            return (Debug)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends AppengineRequest<Operation> {
                    private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}";
                    @Key
                    private String appsId;
                    @Key
                    private String servicesId;
                    @Key
                    private String versionsId;
                    @Key
                    private String updateMask;

                    protected Patch(String string, String string2, String string3, Version version) {
                        super(Appengine.this, "PATCH", REST_PATH, (Object)version, Operation.class);
                        this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                        this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                        this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setBearerToken(String string) {
                        return (Patch)super.setBearerToken(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPp(Boolean bl) {
                        return (Patch)super.setPp(bl);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getAppsId() {
                        return this.appsId;
                    }

                    public Patch setAppsId(String string) {
                        this.appsId = string;
                        return this;
                    }

                    public String getServicesId() {
                        return this.servicesId;
                    }

                    public Patch setServicesId(String string) {
                        this.servicesId = string;
                        return this;
                    }

                    public String getVersionsId() {
                        return this.versionsId;
                    }

                    public Patch setVersionsId(String string) {
                        this.versionsId = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends AppengineRequest<ListVersionsResponse> {
                    private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions";
                    @Key
                    private String appsId;
                    @Key
                    private String servicesId;
                    @Key
                    private String view;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String string, String string2) {
                        super(Appengine.this, "GET", REST_PATH, null, ListVersionsResponse.class);
                        this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                        this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getAppsId() {
                        return this.appsId;
                    }

                    public List setAppsId(String string) {
                        this.appsId = string;
                        return this;
                    }

                    public String getServicesId() {
                        return this.servicesId;
                    }

                    public List setServicesId(String string) {
                        this.servicesId = string;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public List setView(String string) {
                        this.view = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends AppengineRequest<Version> {
                    private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}";
                    @Key
                    private String appsId;
                    @Key
                    private String servicesId;
                    @Key
                    private String versionsId;
                    @Key
                    private String view;

                    protected Get(String string, String string2, String string3) {
                        super(Appengine.this, "GET", REST_PATH, null, Version.class);
                        this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                        this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                        this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getAppsId() {
                        return this.appsId;
                    }

                    public Get setAppsId(String string) {
                        this.appsId = string;
                        return this;
                    }

                    public String getServicesId() {
                        return this.servicesId;
                    }

                    public Get setServicesId(String string) {
                        this.servicesId = string;
                        return this;
                    }

                    public String getVersionsId() {
                        return this.versionsId;
                    }

                    public Get setVersionsId(String string) {
                        this.versionsId = string;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Get setView(String string) {
                        this.view = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends AppengineRequest<Operation> {
                    private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}";
                    @Key
                    private String appsId;
                    @Key
                    private String servicesId;
                    @Key
                    private String versionsId;

                    protected Delete(String string, String string2, String string3) {
                        super(Appengine.this, "DELETE", REST_PATH, null, Operation.class);
                        this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                        this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                        this.versionsId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter versionsId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getAppsId() {
                        return this.appsId;
                    }

                    public Delete setAppsId(String string) {
                        this.appsId = string;
                        return this;
                    }

                    public String getServicesId() {
                        return this.servicesId;
                    }

                    public Delete setServicesId(String string) {
                        this.servicesId = string;
                        return this;
                    }

                    public String getVersionsId() {
                        return this.versionsId;
                    }

                    public Delete setVersionsId(String string) {
                        this.versionsId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends AppengineRequest<Operation> {
                    private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}/versions";
                    @Key
                    private String appsId;
                    @Key
                    private String servicesId;

                    protected Create(String string, String string2, Version version) {
                        super(Appengine.this, "POST", REST_PATH, (Object)version, Operation.class);
                        this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                        this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getAppsId() {
                        return this.appsId;
                    }

                    public Create setAppsId(String string) {
                        this.appsId = string;
                        return this;
                    }

                    public String getServicesId() {
                        return this.servicesId;
                    }

                    public Create setServicesId(String string) {
                        this.servicesId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AppengineRequest<Operation> {
                private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}";
                @Key
                private String appsId;
                @Key
                private String servicesId;
                @Key
                private String updateMask;
                @Key
                private Boolean migrateTraffic;

                protected Patch(String string, String string2, Service service) {
                    super(Appengine.this, "PATCH", REST_PATH, (Object)service, Operation.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                    this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public Patch setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getServicesId() {
                    return this.servicesId;
                }

                public Patch setServicesId(String string) {
                    this.servicesId = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                public Boolean getMigrateTraffic() {
                    return this.migrateTraffic;
                }

                public Patch setMigrateTraffic(Boolean bl) {
                    this.migrateTraffic = bl;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AppengineRequest<ListServicesResponse> {
                private static final String REST_PATH = "v1/apps/{appsId}/services";
                @Key
                private String appsId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Appengine.this, "GET", REST_PATH, null, ListServicesResponse.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public List setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AppengineRequest<Service> {
                private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}";
                @Key
                private String appsId;
                @Key
                private String servicesId;

                protected Get(String string, String string2) {
                    super(Appengine.this, "GET", REST_PATH, null, Service.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                    this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public Get setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getServicesId() {
                    return this.servicesId;
                }

                public Get setServicesId(String string) {
                    this.servicesId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AppengineRequest<Operation> {
                private static final String REST_PATH = "v1/apps/{appsId}/services/{servicesId}";
                @Key
                private String appsId;
                @Key
                private String servicesId;

                protected Delete(String string, String string2) {
                    super(Appengine.this, "DELETE", REST_PATH, null, Operation.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                    this.servicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter servicesId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public Delete setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getServicesId() {
                    return this.servicesId;
                }

                public Delete setServicesId(String string) {
                    this.servicesId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Operations {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AppengineRequest<ListOperationsResponse> {
                private static final String REST_PATH = "v1/apps/{appsId}/operations";
                @Key
                private String appsId;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Appengine.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public List setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AppengineRequest<Operation> {
                private static final String REST_PATH = "v1/apps/{appsId}/operations/{operationsId}";
                @Key
                private String appsId;
                @Key
                private String operationsId;

                protected Get(String string, String string2) {
                    super(Appengine.this, "GET", REST_PATH, null, Operation.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                    this.operationsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operationsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public Get setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getOperationsId() {
                    return this.operationsId;
                }

                public Get setOperationsId(String string) {
                    this.operationsId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Locations {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Appengine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AppengineRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1/apps/{appsId}/locations";
                @Key
                private String appsId;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(Appengine.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public List setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AppengineRequest<Location> {
                private static final String REST_PATH = "v1/apps/{appsId}/locations/{locationsId}";
                @Key
                private String appsId;
                @Key
                private String locationsId;

                protected Get(String string, String string2) {
                    super(Appengine.this, "GET", REST_PATH, null, Location.class);
                    this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
                    this.locationsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter locationsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getAppsId() {
                    return this.appsId;
                }

                public Get setAppsId(String string) {
                    this.appsId = string;
                    return this;
                }

                public String getLocationsId() {
                    return this.locationsId;
                }

                public Get setLocationsId(String string) {
                    this.locationsId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Repair
        extends AppengineRequest<Operation> {
            private static final String REST_PATH = "v1/apps/{appsId}:repair";
            @Key
            private String appsId;

            protected Repair(String string, RepairApplicationRequest repairApplicationRequest) {
                super(Appengine.this, "POST", REST_PATH, (Object)repairApplicationRequest, Operation.class);
                this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
            }

            public Repair set$Xgafv(String string) {
                return (Repair)super.set$Xgafv(string);
            }

            public Repair setAccessToken(String string) {
                return (Repair)super.setAccessToken(string);
            }

            public Repair setAlt(String string) {
                return (Repair)super.setAlt(string);
            }

            public Repair setBearerToken(String string) {
                return (Repair)super.setBearerToken(string);
            }

            public Repair setCallback(String string) {
                return (Repair)super.setCallback(string);
            }

            public Repair setFields(String string) {
                return (Repair)super.setFields(string);
            }

            public Repair setKey(String string) {
                return (Repair)super.setKey(string);
            }

            public Repair setOauthToken(String string) {
                return (Repair)super.setOauthToken(string);
            }

            public Repair setPp(Boolean bl) {
                return (Repair)super.setPp(bl);
            }

            public Repair setPrettyPrint(Boolean bl) {
                return (Repair)super.setPrettyPrint(bl);
            }

            public Repair setQuotaUser(String string) {
                return (Repair)super.setQuotaUser(string);
            }

            public Repair setUploadType(String string) {
                return (Repair)super.setUploadType(string);
            }

            public Repair setUploadProtocol(String string) {
                return (Repair)super.setUploadProtocol(string);
            }

            public String getAppsId() {
                return this.appsId;
            }

            public Repair setAppsId(String string) {
                this.appsId = string;
                return this;
            }

            @Override
            public Repair set(String string, Object object) {
                return (Repair)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends AppengineRequest<Operation> {
            private static final String REST_PATH = "v1/apps/{appsId}";
            @Key
            private String appsId;
            @Key
            private String updateMask;

            protected Patch(String string, Application application) {
                super(Appengine.this, "PATCH", REST_PATH, (Object)application, Operation.class);
                this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
            }

            public Patch set$Xgafv(String string) {
                return (Patch)super.set$Xgafv(string);
            }

            public Patch setAccessToken(String string) {
                return (Patch)super.setAccessToken(string);
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setBearerToken(String string) {
                return (Patch)super.setBearerToken(string);
            }

            public Patch setCallback(String string) {
                return (Patch)super.setCallback(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPp(Boolean bl) {
                return (Patch)super.setPp(bl);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUploadType(String string) {
                return (Patch)super.setUploadType(string);
            }

            public Patch setUploadProtocol(String string) {
                return (Patch)super.setUploadProtocol(string);
            }

            public String getAppsId() {
                return this.appsId;
            }

            public Patch setAppsId(String string) {
                this.appsId = string;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String string) {
                this.updateMask = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AppengineRequest<Application> {
            private static final String REST_PATH = "v1/apps/{appsId}";
            @Key
            private String appsId;

            protected Get(String string) {
                super(Appengine.this, "GET", REST_PATH, null, Application.class);
                this.appsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter appsId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getAppsId() {
                return this.appsId;
            }

            public Get setAppsId(String string) {
                this.appsId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends AppengineRequest<Operation> {
            private static final String REST_PATH = "v1/apps";

            protected Create(Application application) {
                super(Appengine.this, "POST", REST_PATH, (Object)application, Operation.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }
}

