/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.safeDelete;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl;

public class JavaSafeDeleteDelegateForGroovy
implements JavaSafeDeleteDelegate {
    public void createUsageInfoForParameter(@NotNull PsiReference reference, @NotNull List<UsageInfo> usages, @NotNull PsiNamedElement parameter, int paramIdx, boolean isVararg2) {
        PsiElement element = reference.getElement();
        GrCall call = null;
        if (element instanceof GrCall) {
            call = (GrCall)element;
        } else if (element.getParent() instanceof GrCall) {
            call = (GrCall)element.getParent();
        }
        if (call != null) {
            GrSignature signature = GrClosureSignatureUtil.createSignature(call);
            if (signature == null) {
                return;
            }
            GrClosureSignatureUtil.ArgInfo<PsiElement>[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call);
            if (argInfos == null) {
                return;
            }
            for (PsiElement arg : argInfos[paramIdx].args) {
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(arg, (PsiElement)parameter, true));
            }
        } else if (element instanceof GrDocMethodReference) {
            final @NonNls StringBuilder newText = new StringBuilder();
            newText.append("/** @see ");
            GrDocReferenceElement holder = ((GrDocMethodReference)element).getReferenceHolder();
            if (holder != null) {
                newText.append(holder.getText());
            }
            newText.append('#');
            newText.append(((GrDocMethodReference)element).getReferenceName());
            newText.append('(');
            ArrayList<GrDocMethodParameter> parameters2 = new ArrayList<GrDocMethodParameter>(Arrays.asList(((GrDocMethodReference)element).getParameterList().getParameters()));
            parameters2.remove(paramIdx);
            newText.append(StringUtil.join(parameters2, p -> p.getText(), (String)","));
            newText.append(")*/");
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, true){

                public void deleteElement() throws IncorrectOperationException {
                    PsiElement e = this.getElement();
                    if (e != null) {
                        ((GrDocMethodReference)e).bindToText(e.getProject(), newText.toString());
                    }
                }
            });
        }
    }

    public void createJavaTypeParameterUsageInfo(@NotNull PsiReference reference, @NotNull List<? super UsageInfo> usages, @NotNull PsiElement typeParameter, int paramsCount, int index) {
        GrTypeElement[] typeArgs;
        GrTypeArgumentList parameterList;
        if (reference instanceof GrCodeReferenceElementImpl && (parameterList = ((GrCodeReferenceElementImpl)reference).getTypeArgumentList()) != null && (typeArgs = parameterList.getTypeArgumentElements()).length > index) {
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(typeArgs.length == 1 ? parameterList : typeArgs[index], typeParameter, true){

                public void deleteElement() throws IncorrectOperationException {
                    PsiElement parent2;
                    PsiElement element = this.getElement();
                    if (element != null && (parent2 = element.getParent()) != null && parent2.isValid()) {
                        @Nullable PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
                        if (next != null && PsiUtilCore.getElementType((PsiElement)next) == GroovyElementTypes.T_COMMA) {
                            next.delete();
                        } else {
                            @Nullable PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element);
                            if (prev != null && PsiUtilCore.getElementType((PsiElement)prev) == GroovyElementTypes.T_COMMA) {
                                prev.delete();
                            }
                        }
                    }
                    super.deleteElement();
                }
            });
        }
    }

    public void createCleanupOverriding(@NotNull PsiElement overriddenFunction, PsiElement[] elements2Delete, @NotNull List<UsageInfo> result2) {
    }

    public UsageInfo createExtendsListUsageInfo(PsiElement refElement, PsiReference reference) {
        return null;
    }
}

