/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameAliasedUsagesUtil;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameGrFieldProcessor;
import org.jetbrains.plugins.groovy.refactoring.rename.RenameHelperKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J7\u0010!\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/groovy/refactoring/rename/RenameGrFieldProcessor;", "Lcom/intellij/refactoring/rename/RenameJavaVariableProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findExistingNameConflicts", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "handleElementRename", "ref", "fieldName", "qualify", "member", "Lcom/intellij/psi/PsiMember;", "refExpr", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "intellij.groovy"})
public class RenameGrFieldProcessor
extends RenameJavaVariableProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof GrField;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        boolean bl = element instanceof GrField;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField");
        GrField field = (GrField)element;
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)searchScope, (boolean)true).findAll(), (PsiElement)setter));
        }
        for (GrAccessorMethod getter : field.getGetters()) {
            refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)searchScope, (boolean)true).findAll(), (PsiElement)getter));
        }
        refs.addAll(RenameAliasedUsagesUtil.filterAliasedRefs(ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope, (boolean)false).findAll(), field));
        return refs;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) {
        block4: {
            PsiElement resolved;
            HashMap oldResolvedRefs = new HashMap();
            int n = usages.length;
            for (int j = 0; j < n; ++j) {
                PsiElement psiElement;
                GrReferenceExpression ref2;
                UsageInfo usage = usages[j];
                Object object = usage.getReference();
                if ((object instanceof GrReferenceExpression ? (GrReferenceExpression)object : null) == null) continue;
                ref2 = ref2;
                PsiElement resovled = ref2.resolve();
                object = oldResolvedRefs;
                if (resovled == null) continue;
                object.put(ref2, psiElement);
            }
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField");
            GrField field = (GrField)element;
            for (UsageInfo usage : usages) {
                PsiReference ref3 = usage.getReference();
                if (ref3 instanceof GrReferenceExpression) {
                    resolved = (PsiElement)oldResolvedRefs.get(ref3);
                    ((GrReferenceExpression)ref3).handleElementRename(RenameHelperKt.getNewNameFromTransformations(resolved, newName));
                    continue;
                }
                if (ref3 == null) continue;
                this.handleElementRename(newName, ref3, field.getName());
            }
            field.setName(newName);
            PsiManager manager = element.getManager();
            for (GrReferenceExpression expression : oldResolvedRefs.keySet()) {
                PsiElement oldResolved;
                if ((PsiElement)oldResolvedRefs.get(expression) == null || expression.resolve() == null || manager.areElementsEquivalent(oldResolved, resolved) || !Intrinsics.areEqual((Object)oldResolved, (Object)field) && !RenameHelperKt.isQualificationNeeded(manager, oldResolved, resolved)) continue;
                this.qualify(field, expression);
            }
            RefactoringElementListener refactoringElementListener = listener;
            if (refactoringElementListener == null) break block4;
            refactoringElementListener.elementRenamed(element);
        }
    }

    private final void handleElementRename(String newName, PsiReference ref2, String fieldName) {
        String refText = ref2 instanceof PsiQualifiedReference ? ((PsiQualifiedReference)ref2).getReferenceName() : ref2.getCanonicalText();
        String toRename = Intrinsics.areEqual((Object)fieldName, (Object)refText) ? newName : (Intrinsics.areEqual((Object)GroovyPropertyUtils.getGetterNameNonBoolean(fieldName), (Object)refText) ? GroovyPropertyUtils.getGetterNameNonBoolean(newName) : (Intrinsics.areEqual((Object)GroovyPropertyUtils.getGetterNameBoolean(fieldName), (Object)refText) ? GroovyPropertyUtils.getGetterNameBoolean(newName) : (Intrinsics.areEqual((Object)GroovyPropertyUtils.getSetterName(fieldName), (Object)refText) ? GroovyPropertyUtils.getSetterName(newName) : newName)));
        ref2.handleElementRename(toRename);
    }

    private final void qualify(PsiMember member, GrReferenceExpression refExpr) {
        String string;
        String string2 = refExpr.getReferenceName();
        if (string2 == null) {
            return;
        }
        String referenceName = string2;
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass clazz = psiClass;
        if (refExpr.getQualifierExpression() != null) {
            return;
        }
        PsiManager manager = member.getManager();
        Project project = manager.getProject();
        if (member.hasModifierProperty("static")) {
            string = clazz.getQualifiedName() + "." + referenceName;
        } else {
            PsiElement $this$parentOfType_u24default$iv = refExpr;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            string = manager.areElementsEquivalent(PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiClass.class, (boolean)true), (PsiElement)clazz) ? "this." + referenceName : clazz.getQualifiedName() + ".this." + referenceName;
        }
        String newText = string;
        GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(project).createReferenceExpressionFromText(newText);
        PsiElement replaced = refExpr.replace(newRefExpr);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        ArrayList<findCollisions.1> collisions = new ArrayList<findCollisions.1>();
        for (UsageInfo info : result2) {
            PsiMethod resolved;
            Class[] classArray;
            PsiType[] typeArguments;
            PsiType[] argTypes;
            MethodResolverProcessor processor;
            PsiElement referencedElement;
            GrReferenceExpression refExpr;
            if (!(info instanceof MoveRenameUsageInfo)) continue;
            PsiElement psiElement = info.getElement();
            GrReferenceExpression grReferenceExpression = psiElement instanceof GrReferenceExpression ? (GrReferenceExpression)psiElement : null;
            if (grReferenceExpression == null || !((refExpr = grReferenceExpression).getParent() instanceof GrCall) || !((referencedElement = ((MoveRenameUsageInfo)info).getReferencedElement()) instanceof GrField) && !refExpr.advancedResolve().isInvokedOnProperty() || (PsiMethod)ResolveUtil.resolveExistingElement(refExpr, processor = new MethodResolverProcessor(newName, refExpr, false, null, argTypes = PsiUtil.getArgumentTypes(refExpr, false), typeArguments = refExpr.getTypeArguments()), classArray = new Class[]{PsiMethod.class}) == null) continue;
            collisions.add(new UnresolvableCollisionUsageInfo(resolved, refExpr){
                final /* synthetic */ PsiMethod $resolved;
                final /* synthetic */ GrReferenceExpression $refExpr;
                {
                    this.$resolved = $resolved;
                    this.$refExpr = $refExpr;
                    super((PsiElement)$resolved, (PsiElement)$refExpr);
                }

                @NotNull
                public String getDescription() {
                    Object[] objectArray = new Object[]{this.$refExpr.getParent().getText(), PsiFormatUtil.formatMethod((PsiMethod)this.$resolved, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)2)};
                    return GroovyRefactoringBundle.message("usage.will.be.overridden.by.method", objectArray);
                }

                @NotNull
                public Object clone() {
                    return super.clone();
                }
            });
        }
        result2.addAll((Collection<UsageInfo>)collisions);
        super.findCollisions(element, newName, allRenames, result2);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiMethod newSetter;
        PsiMethod setter;
        PsiMethod newGetter;
        super.findExistingNameConflicts(element, newName, conflicts);
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField");
        GrField field = (GrField)element;
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        PsiMethod getter = GroovyPropertyUtils.findGetterForField(field);
        if (getter instanceof GrAccessorMethod && (newGetter = PropertyUtilBase.findPropertyGetter((PsiClass)containingClass, (String)newName, (boolean)field.hasModifierProperty("static"), (boolean)true)) != null && !(newGetter instanceof GrAccessorMethod)) {
            Object[] objectArray = new Object[]{field.getName(), newGetter.getName()};
            conflicts.putValue((Object)newGetter, (Object)GroovyRefactoringBundle.message("implicit.getter.will.by.overridden.by.method", objectArray));
        }
        if ((setter = GroovyPropertyUtils.findSetterForField(field)) instanceof GrAccessorMethod && (newSetter = PropertyUtilBase.findPropertySetter((PsiClass)containingClass, (String)newName, (boolean)field.hasModifierProperty("static"), (boolean)true)) != null && !(newSetter instanceof GrAccessorMethod)) {
            Object[] objectArray = new Object[]{field.getName(), newSetter.getName()};
            conflicts.putValue((Object)newSetter, (Object)GroovyRefactoringBundle.message("implicit.setter.will.by.overridden.by.method", objectArray));
        }
    }
}

