/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public class MoveGroovyMemberHandler
implements MoveMemberHandler {
    public boolean changeExternalUsage(@NotNull MoveMembersOptions options2, @NotNull MoveMembersProcessor.MoveMembersUsageInfo usage) {
        PsiElement element = usage.getElement();
        if (element == null || !element.isValid()) {
            return true;
        }
        if (usage.reference instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)usage.reference;
            GrExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null) {
                    MoveGroovyMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
                } else {
                    refExpr.setQualifier(null);
                }
            } else if (usage.qualifierClass != null) {
                MoveGroovyMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options2, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiMember moved;
        GroovyChangeContextUtil.encodeContextInfo((PsiElement)member);
        PsiDocComment docComment = member instanceof PsiDocCommentOwner ? ((PsiDocCommentOwner)member).getDocComment() : null;
        if (options2.makeEnumConstant() && member instanceof GrVariable && EnumConstantsUtil.isSuitableForEnumConstant((PsiType)((PsiVariable)member).getType(), (PsiClass)targetClass)) {
            GrEnumConstant prototype = MoveGroovyMemberHandler.createEnumConstant(member.getName(), ((GrVariable)member).getInitializerGroovy(), member.getProject());
            moved = (PsiMember)MoveGroovyMemberHandler.addEnumConstant(targetClass, prototype, anchor);
            member.delete();
        } else if (member instanceof GrEnumConstant) {
            moved = (PsiMember)MoveGroovyMemberHandler.addEnumConstant(targetClass, (GrEnumConstant)member, null);
        } else if (member instanceof GrField) {
            int i2;
            if (anchor != null) {
                anchor = anchor.getParent();
            }
            GrVariableDeclaration parent2 = (GrVariableDeclaration)member.getParent();
            GrVariableDeclaration movedDeclaration = (GrVariableDeclaration)targetClass.addAfter((PsiElement)parent2, anchor);
            int number = ArrayUtil.find((Object[])parent2.getMembers(), (Object)member);
            GrMember[] members = movedDeclaration.getMembers();
            for (i2 = 0; i2 < number; ++i2) {
                members[i2].delete();
            }
            for (i2 = number + 1; i2 < members.length; ++i2) {
                members[i2].delete();
            }
            if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                GrModifierList list = movedDeclaration.getModifierList();
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
            }
            moved = movedDeclaration.getMembers()[0];
        } else if (member instanceof GrMethod) {
            moved = (PsiMember)targetClass.addAfter((PsiElement)member, anchor);
            if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                PsiModifierList list = moved.getModifierList();
                assert (list != null);
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
            }
        } else {
            moved = (PsiMember)targetClass.addAfter((PsiElement)member, anchor);
        }
        if (docComment != null) {
            PsiElement insertedDocComment = targetClass.addBefore((PsiElement)docComment, (PsiElement)moved);
            PsiElement prevSibling = insertedDocComment.getPrevSibling();
            MoveGroovyMemberHandler.addLineFeedIfNeeded(prevSibling);
            docComment.delete();
        }
        member.delete();
        return moved;
    }

    private static void addLineFeedIfNeeded(PsiElement prevSibling) {
        if (prevSibling == null) {
            return;
        }
        ASTNode node = prevSibling.getNode();
        IElementType type2 = node.getElementType();
        if (type2 == GroovyTokenTypes.mNLS) {
            String text = prevSibling.getText();
            int lfCount = StringUtil.countChars((CharSequence)text, (char)'\n');
            if (lfCount < 2) {
                ASTNode parent2 = node.getTreeParent();
                parent2.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)(text + "\n "), node);
                parent2.removeChild(node);
            }
        } else {
            node.getTreeParent().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n\n ", node.getTreeNext());
        }
    }

    public void decodeContextInfo(@NotNull PsiElement scope) {
        GroovyChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    private static void changeQualifier(GrReferenceExpression refExpr, PsiClass aClass, PsiMember member) throws IncorrectOperationException {
        if (MoveGroovyMemberHandler.hasOnDemandStaticImport(refExpr, aClass)) {
            refExpr.setQualifier(null);
        } else if (!MoveGroovyMemberHandler.hasStaticImport(refExpr, member)) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(refExpr.getProject());
            refExpr.setQualifier(factory.createReferenceExpressionFromText(aClass.getName()));
            ((GrReferenceExpression)refExpr.getQualifierExpression()).bindToElement((PsiElement)aClass);
        }
    }

    private static boolean hasStaticImport(GrReferenceExpression refExpr, PsiMember member) {
        GrImportStatement[] imports2;
        if (!(refExpr.getContainingFile() instanceof GroovyFile)) {
            return false;
        }
        for (GrImportStatement stmt : imports2 = ((GroovyFile)refExpr.getContainingFile()).getImportStatements()) {
            if (stmt.isOnDemand() || stmt.resolveTargetClass() != member.getContainingClass() || !Comparing.strEqual((String)stmt.getImportReference().getReferenceName(), (String)member.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        if (element.getContainingFile() instanceof GroovyFile) {
            GrImportStatement[] importStatements;
            for (GrImportStatement stmt : importStatements = ((GroovyFile)element.getContainingFile()).getImportStatements()) {
                GrCodeReferenceElement ref2 = stmt.getImportReference();
                if (ref2 == null || !stmt.isStatic() || !stmt.isOnDemand() || ref2.resolve() != aClass) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public PsiElement getAnchor(@NotNull PsiMember member, final @NotNull PsiClass targetClass, Set<PsiMember> membersToMove) {
        if (member instanceof GrField && member.hasModifierProperty("static")) {
            final ArrayList referencedFields = new ArrayList();
            GrExpression psiExpression = ((GrField)member).getInitializerGroovy();
            if (psiExpression != null) {
                psiExpression.accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
                        GrField grField;
                        super.visitReferenceExpression(expression);
                        PsiElement psiElement = expression.resolve();
                        if (psiElement instanceof GrField && (grField = (GrField)psiElement).getContainingClass() == targetClass && !referencedFields.contains(grField)) {
                            referencedFields.add(grField);
                        }
                    }
                });
            }
            if (!referencedFields.isEmpty()) {
                referencedFields.sort((o1, o2) -> -PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2));
                return (PsiElement)referencedFields.get(0);
            }
        }
        return null;
    }

    private static GrEnumConstant createEnumConstant(String constantName, GrExpression initializerExpr, Project project) throws IncorrectOperationException {
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(project);
        String enumConstantText = initializerExpr != null ? constantName + "(" + initializerExpr.getText() + ")" : constantName;
        return elementFactory.createEnumConstantFromText(enumConstantText);
    }

    private static PsiElement addEnumConstant(PsiClass targetClass, GrEnumConstant constant, @Nullable PsiElement anchor) {
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumTypeDefinition enumeration = (GrEnumTypeDefinition)targetClass;
            GrEnumConstantList constantList = enumeration.getEnumConstantList();
            if (constantList != null) {
                ASTNode node = constantList.getNode();
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", node.getFirstChildNode());
                return constantList.addBefore(constant, constantList.getFirstChild());
            }
            PsiElement parent2 = constant.getParent();
            assert (parent2 instanceof GrEnumConstantList);
            GrEnumConstantList constListCopy = (GrEnumConstantList)targetClass.add(parent2);
            return constListCopy.getEnumConstants()[0];
        }
        return anchor != null ? targetClass.addAfter((PsiElement)constant, anchor) : targetClass.add((PsiElement)constant);
    }

    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(@NotNull PsiMember member, @NotNull PsiReference psiReference, @NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass) {
        PsiElement ref2 = psiReference.getElement();
        if (ref2 instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)ref2;
            GrExpression qualifier = (GrExpression)refExpr.getQualifier();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, (PsiClass)targetClass, (boolean)true)) {
                if (!RefactoringUtil.isInMovedElement((PsiElement)refExpr, membersToMove) ? qualifier != null : qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    public void checkConflictsOnUsage(@NotNull MoveMembersProcessor.MoveMembersUsageInfo usageInfo, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiElement element = usageInfo.getElement();
        if (element == null) {
            return;
        }
        PsiMember member = usageInfo.member;
        if (element instanceof GrReferenceExpression) {
            GrExpression qualifier = (GrExpression)((GrReferenceExpression)element).getQualifier();
            PsiClass accessObjectClass = null;
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
            }
            if (!JavaResolveUtil.isAccessible((PsiMember)member, (PsiClass)targetClass, (PsiModifierList)modifierListCopy, (PsiElement)element, (PsiClass)accessObjectClass, null)) {
                String visibility = newVisibility != null ? newVisibility : VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member);
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), visibility, RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)element), (boolean)true)});
                conflicts.putValue((Object)member, (Object)StringUtil.capitalize((String)message));
            }
        }
    }

    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
    }
}

