/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.extract.GroovyExtractChooser;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.IntroduceOccurrencesChooser;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrInplaceParameterIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;
import org.jetbrains.plugins.groovy.refactoring.ui.MethodOrClosureScopeChooser;

public class GrIntroduceParameterHandler
implements RefactoringActionHandler,
MethodOrClosureScopeChooser.JBPopupOwner {
    private JBPopup myEnclosingMethodsPopup;

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, @Nullable DataContext dataContext) {
        if (editor == null || file == null) {
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List<GrExpression> expressions = GrIntroduceHandlerBase.collectExpressions(file, editor, offset, false);
            if (expressions.isEmpty()) {
                GrIntroduceHandlerBase.updateSelectionForVariable(editor, file, selectionModel, offset);
            } else if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                TextRange textRange = expressions.get(0).getTextRange();
                selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<GrExpression>(){

                    public void pass(GrExpression selectedValue) {
                        GrIntroduceParameterHandler.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                    }
                }, grExpression -> grExpression.getText());
                return;
            }
        }
        this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
    }

    private void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset) {
        try {
            InitialInfo initialInfo = GroovyExtractChooser.invoke(project, editor, file, startOffset, endOffset, false);
            this.chooseScopeAndRun(initialInfo, editor);
        }
        catch (GrRefactoringError e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"introduce.parameter.title"), (String)"refactoring.introduceParameter.groovy");
        }
    }

    private void chooseScopeAndRun(@NotNull InitialInfo initialInfo, @NotNull Editor editor) {
        List<GrParameterListOwner> scopes = GrIntroduceParameterHandler.findScopes(initialInfo);
        if (scopes.isEmpty()) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("there.is.no.method.or.closure", new Object[0]));
        }
        if (scopes.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            GrVariable toSearchFor;
            GrParameterListOwner owner2 = scopes.get(0);
            if (owner2 instanceof GrMethod) {
                toSearchFor = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)((PsiMethod)owner2));
                if (toSearchFor == null) {
                    return;
                }
            } else {
                toSearchFor = MethodOrClosureScopeChooser.findVariableToUse(owner2);
            }
            this.showDialogOrStartInplace(new IntroduceParameterInfoImpl(initialInfo, owner2, toSearchFor), editor);
        } else {
            this.myEnclosingMethodsPopup = MethodOrClosureScopeChooser.create(scopes, editor, this, (PairFunction<? super GrParameterListOwner, ? super PsiElement, Object>)((PairFunction)(owner, element) -> {
                this.showDialogOrStartInplace(new IntroduceParameterInfoImpl(initialInfo, (GrParameterListOwner)owner, (PsiElement)element), editor);
                return null;
            }));
            this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
        }
    }

    @NotNull
    private static List<GrParameterListOwner> findScopes(@NotNull InitialInfo initialInfo) {
        GrParameterListOwner parent2;
        PsiElement place = initialInfo.getContext();
        ArrayList<GrParameterListOwner> scopes = new ArrayList<GrParameterListOwner>();
        while ((parent2 = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)place, GrParameterListOwner.class)) != null) {
            scopes.add(parent2);
            place = parent2;
        }
        return scopes;
    }

    @Override
    public JBPopup get() {
        return this.myEnclosingMethodsPopup;
    }

    protected void showDialogOrStartInplace(final @NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        if (GrIntroduceParameterHandler.isInplace(info, editor)) {
            final GrIntroduceContext context = GrIntroduceParameterHandler.createContext(info, editor);
            Map<OccurrencesChooser.ReplaceChoice, List<Object>> occurrencesMap = GrIntroduceHandlerBase.fillChoice(context);
            new IntroduceOccurrencesChooser(editor).showChooser((Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                public void pass(OccurrencesChooser.ReplaceChoice choice) {
                    GrIntroduceParameterHandler.startInplace(info, context, choice);
                }
            }, occurrencesMap);
        } else {
            this.showDialog(info);
        }
    }

    protected void showDialog(IntroduceParameterInfo info) {
        new GrIntroduceParameterDialog(info).show();
    }

    private static void startInplace(@NotNull IntroduceParameterInfo info, @NotNull GrIntroduceContext context, OccurrencesChooser.ReplaceChoice replaceChoice) {
        new GrInplaceParameterIntroducer(info, context, replaceChoice).startInplaceIntroduceTemplate();
    }

    private static boolean isInplace(@NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        return GroovyIntroduceParameterUtil.findExpr(info) != null && info.getToReplaceIn() instanceof GrMethod && info.getToSearchFor() instanceof PsiMethod && GrIntroduceHandlerBase.isInplace(editor, info.getContext());
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
    }

    private static GrIntroduceContext createContext(@NotNull IntroduceParameterInfo info, @NotNull Editor editor) {
        GrExpression expr = GroovyIntroduceParameterUtil.findExpr(info);
        GrVariable var = GroovyIntroduceParameterUtil.findVar(info);
        StringPartInfo stringPart = info.getStringPartInfo();
        return new GrIntroduceVariableHandler().getContext(info.getProject(), editor, expr, var, stringPart, info.getToReplaceIn());
    }
}

