/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;

public class GrIntroduceFieldProcessor {
    private static final Logger LOG = Logger.getInstance(GrIntroduceFieldProcessor.class);
    private final GrIntroduceContext myContext;
    private final GrIntroduceFieldSettings mySettings;
    @Nullable
    private GrExpression myInitializer;
    @Nullable
    private GrVariable myLocalVariable;

    public GrIntroduceFieldProcessor(@NotNull GrIntroduceContext context, @NotNull GrIntroduceFieldSettings settings) {
        this.myContext = context;
        this.mySettings = settings;
    }

    @Nullable
    public GrVariable run() {
        GrExpression originalInitializer;
        PsiClass targetClass;
        PsiElement scope = this.myContext.getScope();
        PsiClass psiClass = targetClass = scope instanceof GroovyFileBase ? ((GroovyFileBase)scope).getScriptClass() : (PsiClass)scope;
        if (targetClass == null) {
            return null;
        }
        GrVariableDeclaration declaration = this.insertField(targetClass);
        GrVariable field = declaration.getVariables()[0];
        if (this.mySettings.removeLocalVar()) {
            this.myLocalVariable = GrIntroduceHandlerBase.resolveLocalVar(this.myContext);
            assert (this.myLocalVariable != null) : this.myContext.getExpression() + ", " + this.myContext.getVar() + ", " + this.myContext.getStringPart();
        }
        this.myInitializer = (originalInitializer = this.getInitializer()) == null ? null : (GrExpression)originalInitializer.copy();
        List<PsiElement> replaced = this.processOccurrences(targetClass, field);
        switch (this.mySettings.initializeIn()) {
            case CUR_METHOD: {
                this.initializeInMethod(field, replaced);
                break;
            }
            case FIELD_DECLARATION: {
                field.setInitializerGroovy(this.myInitializer);
                break;
            }
            case CONSTRUCTOR: {
                this.initializeInConstructor(field, replaced);
                break;
            }
            case SETUP_METHOD: {
                this.initializeInSetup(field, replaced);
            }
        }
        JavaCodeStyleManager.getInstance((Project)declaration.getProject()).shortenClassReferences((PsiElement)declaration);
        if (this.mySettings.removeLocalVar()) {
            GrIntroduceHandlerBase.deleteLocalVar(this.myLocalVariable);
        }
        return field;
    }

    @NotNull
    private List<PsiElement> processOccurrences(@NotNull PsiClass targetClass, @NotNull GrVariable field) {
        if (this.myContext.getStringPart() != null) {
            GrExpression expr = this.myContext.getStringPart().replaceLiteralWithConcatenation(field.getName());
            PsiElement occurrence = this.replaceOccurrence(field, expr, targetClass);
            this.updateCaretPosition(occurrence);
            return Collections.singletonList(occurrence);
        }
        if (this.mySettings.replaceAllOccurrences()) {
            GroovyRefactoringUtil.sortOccurrences(this.myContext.getOccurrences());
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (PsiElement occurrence : this.myContext.getOccurrences()) {
                result2.add(this.replaceOccurrence(field, occurrence, targetClass));
            }
            return result2;
        }
        GrVariable var = this.myContext.getVar();
        if (var != null) {
            GrExpression initializer = var.getInitializerGroovy();
            if (initializer != null) {
                return Collections.singletonList(this.replaceOccurrence(field, initializer, targetClass));
            }
            return Collections.emptyList();
        }
        GrExpression expression = this.myContext.getExpression();
        assert (expression != null);
        return Collections.singletonList(this.replaceOccurrence(field, expression, targetClass));
    }

    private void updateCaretPosition(@NotNull PsiElement occurrence) {
        this.myContext.getEditor().getCaretModel().moveToOffset(occurrence.getTextRange().getEndOffset());
        this.myContext.getEditor().getSelectionModel().removeSelection();
    }

    @NotNull
    protected GrVariableDeclaration insertField(@NotNull PsiClass targetClass) {
        GrVariableDeclaration declaration = this.createField(targetClass);
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumConstantList enumConstants = ((GrEnumTypeDefinition)targetClass).getEnumConstantList();
            return (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, (PsiElement)enumConstants);
        }
        if (targetClass instanceof GrTypeDefinition) {
            PsiElement anchor = GrIntroduceFieldProcessor.getAnchorForDeclaration((GrTypeDefinition)targetClass);
            return (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, anchor);
        }
        assert (targetClass instanceof GroovyScriptClass);
        GroovyFile file = ((GroovyScriptClass)targetClass).getContainingFile();
        Object[] elements = file.getMethods();
        if (elements.length == 0) {
            elements = file.getStatements();
        }
        PsiElement anchor = (PsiElement)ArrayUtil.getFirstElement((Object[])elements);
        return (GrVariableDeclaration)file.addBefore(declaration, anchor);
    }

    @Nullable
    private static PsiElement getAnchorForDeclaration(@NotNull GrTypeDefinition targetClass) {
        GrMembersDeclaration[] declarations;
        GrTypeDefinitionBody body = targetClass.getBody();
        if (body == null) {
            return null;
        }
        PsiElement anchor = body.getLBrace();
        for (GrMembersDeclaration declaration : declarations = targetClass.getMemberDeclarations()) {
            if (declaration instanceof GrVariableDeclaration) {
                anchor = declaration;
            }
            if (declaration instanceof GrVariableDeclaration) continue;
            return anchor;
        }
        return anchor;
    }

    void initializeInSetup(@NotNull GrVariable field, @NotNull Collection<PsiElement> replaced) {
        PsiMethod setUpMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod((PsiClass)this.myContext.getScope());
        assert (setUpMethod instanceof GrMethod);
        GrOpenBlock body = ((GrMethod)setUpMethod).getBlock();
        GrStatement anchor = GrIntroduceFieldProcessor.findAnchorForAssignment(body, replaced);
        this.generateAssignment(field, anchor, body, null);
    }

    void initializeInMethod(@NotNull GrVariable field, @NotNull List<PsiElement> replaced) {
        PsiElement anchor;
        GrOpenBlock container;
        PsiElement _scope = this.myContext.getScope();
        PsiElement scope = _scope instanceof GroovyScriptClass ? ((GroovyScriptClass)_scope).getContainingFile() : _scope;
        PsiElement place = replaced.get(0);
        GrMember member = GrIntroduceFieldHandler.getContainer(place, scope);
        GrVariableDeclarationOwner grVariableDeclarationOwner = member instanceof GrMethod ? ((GrMethod)member).getBlock() : (member instanceof GrClassInitializer ? ((GrClassInitializer)member).getBlock() : (container = place.getContainingFile() instanceof GroovyFile ? (GroovyFile)place.getContainingFile() : null));
        assert (container != null);
        if (this.mySettings.removeLocalVar()) {
            GrVariable variable = this.myLocalVariable;
            anchor = PsiTreeUtil.getParentOfType((PsiElement)variable, GrStatement.class);
        } else {
            anchor = GrIntroduceHandlerBase.findAnchor(replaced.toArray(PsiElement.EMPTY_ARRAY), container);
            GrIntroduceHandlerBase.assertStatement(anchor, this.myContext.getScope());
        }
        this.initializeInMethodInner(field, container, (GrStatement)anchor, replaced.get(0));
    }

    private void initializeInMethodInner(@NotNull GrVariable field, @Nullable GrStatementOwner container, @Nullable GrStatement anchor, @Nullable PsiElement occurence) {
        if (!this.mySettings.replaceAllOccurrences() && PsiUtil.isExpressionStatement(occurence) && Comparing.equal((Object)anchor, (Object)occurence)) {
            this.generateAssignment(field, anchor, container, occurence);
        } else {
            this.generateAssignment(field, anchor, container, null);
        }
    }

    void initializeInConstructor(@NotNull GrVariable field, @NotNull Collection<PsiElement> replaced) {
        PsiClass scope = (PsiClass)this.myContext.getScope();
        if (scope instanceof GrAnonymousClassDefinition) {
            this.initializeInAnonymousClassInitializer(field, (GrAnonymousClassDefinition)scope, replaced);
        } else {
            this.initializeInConstructor(field, scope, replaced);
        }
    }

    private void initializeInConstructor(@NotNull GrVariable field, @NotNull PsiClass scope, @NotNull Collection<PsiElement> replaced) {
        PsiMethod[] constructors = scope.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{this.generateConstructor(scope)};
        }
        for (PsiMethod constructor : constructors) {
            GrConstructorInvocation invocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)constructor);
            if (invocation != null && invocation.isThisCall()) continue;
            GrOpenBlock body = ((GrMethod)constructor).getBlock();
            GrStatement anchor = GrIntroduceFieldProcessor.findAnchorForAssignment(body, replaced);
            this.initializeInMethodInner(field, body, anchor, (PsiElement)ContainerUtil.getFirstItem(replaced));
        }
    }

    @NotNull
    private PsiMethod generateConstructor(@NotNull PsiClass scope) {
        String name = scope.getName();
        LOG.assertTrue(name != null, (Object)scope.getText());
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        GrMethod constructor = factory.createConstructorFromText(name, ArrayUtilRt.EMPTY_STRING_ARRAY, ArrayUtilRt.EMPTY_STRING_ARRAY, "{}", (PsiElement)scope);
        if (scope instanceof GroovyScriptClass) {
            constructor.getModifierList().setModifierProperty("def", true);
        }
        return (PsiMethod)scope.add((PsiElement)constructor);
    }

    private void initializeInAnonymousClassInitializer(@NotNull GrVariable field, @NotNull GrAnonymousClassDefinition scope, @NotNull Collection<PsiElement> replaced) {
        GrClassInitializer[] initializers = scope.getInitializers();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        GrClassInitializer initializer = initializers.length == 0 ? (GrClassInitializer)scope.add(factory.createClassInitializer()) : initializers[0];
        GrStatement anchor = GrIntroduceFieldProcessor.findAnchorForAssignment(initializer.getBlock(), replaced);
        this.initializeInMethodInner(field, initializer.getBlock(), anchor, (PsiElement)ContainerUtil.getFirstItem(replaced));
    }

    private void generateAssignment(@NotNull GrVariable field, @Nullable GrStatement anchor, @Nullable GrStatementOwner defaultContainer, @Nullable PsiElement occurrenceToDelete) {
        GrStatementOwner block;
        if (this.myInitializer == null || defaultContainer == null) {
            return;
        }
        GrAssignmentExpression init = (GrAssignmentExpression)GroovyPsiElementFactory.getInstance(this.myContext.getProject()).createExpressionFromText(this.mySettings.getName() + " = " + this.myInitializer.getText());
        if (anchor != null) {
            anchor = GroovyRefactoringUtil.addBlockIntoParent(anchor);
            LOG.assertTrue(anchor.getParent() instanceof GrStatementOwner);
            block = (GrStatementOwner)anchor.getParent();
        } else {
            block = defaultContainer;
        }
        init = (GrAssignmentExpression)block.addStatementBefore(init, anchor);
        this.replaceOccurrence(field, init.getLValue(), (PsiClass)this.myContext.getScope());
        if (occurrenceToDelete != null) {
            occurrenceToDelete.delete();
        }
    }

    @Nullable
    private GrExpression extractVarInitializer() {
        assert (this.myLocalVariable != null);
        return this.myLocalVariable.getInitializerGroovy();
    }

    @Nullable
    private static GrStatement findAnchorForAssignment(@Nullable GrCodeBlock block, @NotNull Collection<PsiElement> replaced) {
        if (block == null) {
            return null;
        }
        List elements = ContainerUtil.findAll(replaced, element -> PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)element, (boolean)true));
        if (elements.isEmpty()) {
            return null;
        }
        return (GrStatement)GrIntroduceHandlerBase.findAnchor(elements.toArray(PsiElement.EMPTY_ARRAY), block);
    }

    @NotNull
    private PsiElement replaceOccurrence(@NotNull GrVariable field, @NotNull PsiElement occurrence, @NotNull PsiClass containingClass) {
        boolean isOriginal = occurrence == this.myContext.getExpression();
        GrReferenceExpression newExpr = GrIntroduceFieldProcessor.createRefExpression(field, occurrence, containingClass);
        PsiElement replaced = occurrence instanceof GrExpression ? ((GrExpression)occurrence).replaceWithExpression(newExpr, false) : occurrence.replace((PsiElement)newExpr);
        if (replaced instanceof GrQualifiedReference) {
            GrReferenceAdjuster.shortenReference((GrQualifiedReference)replaced);
        }
        if (isOriginal) {
            this.updateCaretPosition(replaced);
        }
        return replaced;
    }

    @NotNull
    private static GrReferenceExpression createRefExpression(@NotNull GrVariable field, @NotNull PsiElement place, @NotNull PsiClass containingClass) {
        String qname = containingClass instanceof GroovyScriptClass ? null : containingClass.getQualifiedName();
        Object prefix = qname != null ? qname + "." : "";
        String refText = field.hasModifierProperty("static") ? (String)prefix + field.getName() : (String)prefix + "this." + field.getName();
        return GroovyPsiElementFactory.getInstance(place.getProject()).createReferenceExpressionFromText(refText, place);
    }

    @NotNull
    private GrVariableDeclaration createField(@NotNull PsiClass targetClass) {
        String name = this.mySettings.getName();
        PsiType type2 = this.mySettings.getSelectedType();
        String modifier = this.mySettings.getVisibilityModifier();
        ArrayList<String> modifiers = new ArrayList<String>();
        if (targetClass instanceof GroovyScriptClass) {
            modifiers.add("@groovy.transform.Field");
        }
        if (this.mySettings.isStatic()) {
            modifiers.add("static");
        }
        if (!"packageLocal".equals(modifier)) {
            modifiers.add(modifier);
        }
        if (this.mySettings.declareFinal()) {
            modifiers.add("final");
        }
        String[] arr_modifiers = ArrayUtilRt.toStringArray(modifiers);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        if (targetClass instanceof GroovyScriptClass) {
            return factory.createVariableDeclaration(arr_modifiers, (GrExpression)null, type2, name);
        }
        return factory.createFieldDeclaration(arr_modifiers, name, null, type2);
    }

    @Nullable
    protected GrExpression getInitializer() {
        if (this.mySettings.removeLocalVar()) {
            return this.extractVarInitializer();
        }
        GrExpression expression = this.myContext.getExpression();
        StringPartInfo stringPart = this.myContext.getStringPart();
        if (expression != null) {
            return expression;
        }
        if (stringPart != null) {
            return stringPart.createLiteralFromSelected();
        }
        throw new IncorrectOperationException("cannot be here!");
    }
}

