/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public final class SwitchStatementGenerator {
    private SwitchStatementGenerator() {
    }

    public static void generate(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrSwitchStatement switchStatement) {
        PsiType type2;
        GrExpression condition = switchStatement.getCondition();
        GrCaseSection[] caseSections = switchStatement.getCaseSections();
        PsiType psiType = type2 = condition == null ? null : TypesUtil.unboxPrimitiveTypeWrapper(condition.getType());
        if (type2 == null || SwitchStatementGenerator.isValidTypeForSwitchSelector(type2)) {
            SwitchStatementGenerator.generateSwitch(builder, context, condition, caseSections);
        } else {
            SwitchStatementGenerator.generateIfs(builder, context, condition, caseSections);
        }
    }

    private static boolean isValidTypeForSwitchSelector(@NotNull PsiType type2) {
        if (TypeConversionUtil.getTypeRank((PsiType)type2) <= 4) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return aClass != null && aClass.isEnum();
    }

    private static void generateIfs(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition, GrCaseSection @NotNull [] caseSections) {
        GrExpression ref2;
        if (condition instanceof GrReferenceExpression) {
            ref2 = condition;
        } else {
            String varName = SwitchStatementGenerator.generateConditionVar(builder, context, condition);
            ref2 = GroovyPsiElementFactory.getInstance(context.project).createExpressionFromText(varName);
        }
        GrExpression[] args = new GrExpression[]{ref2};
        SwitchStatementGenerator.generateIfFromCaseSection(builder, context, caseSections, 0, List.of(), args);
    }

    private static void generateIfFromCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, final GrCaseSection @NotNull [] caseSections, final int i2, final List<GrCaseSection> currentSequentialSectionFrame, final GrExpression @NotNull [] args) {
        GenerationUtil.writeStatement(builder, context, null, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrCaseSection section;
                if (caseSections.length == 1 && caseSections[0].isDefault()) {
                    builder.append("if(true)");
                }
                if ((section = caseSections[i2]).getStatements().length != 0) {
                    boolean isCase;
                    boolean bl = isCase = currentSequentialSectionFrame.size() > 1 || !section.isDefault();
                    if (isCase) {
                        SwitchStatementGenerator.writeCondition(builder, context, section, currentSequentialSectionFrame, args);
                    }
                    SwitchStatementGenerator.writeCaseBody(builder, context, i2, caseSections);
                    if (isCase && i2 != caseSections.length - 1) {
                        builder.append("\nelse ");
                        StringBuilder elseBuilder = new StringBuilder();
                        ExpressionContext elseContext = context.extend();
                        SwitchStatementGenerator.generateIfFromCaseSection(elseBuilder, elseContext, caseSections, i2 + 1, List.of(), args);
                        GenerationUtil.insertStatementFromContextBefore(builder, elseContext);
                        builder.append((CharSequence)elseBuilder);
                    }
                    if (!context.myStatements.isEmpty()) {
                        context.setInsertCurlyBrackets();
                    }
                } else {
                    ArrayList<GrCaseSection> list = new ArrayList<GrCaseSection>(currentSequentialSectionFrame);
                    list.add(section);
                    SwitchStatementGenerator.generateIfFromCaseSection(builder, context, caseSections, i2 + 1, list, args);
                }
            }
        });
    }

    private static void writeCaseBody(@NotNull StringBuilder builder, @NotNull ExpressionContext context, int i2, GrCaseSection @NotNull [] caseSections) {
        builder.append("{\n");
        ExpressionContext extended = context.extend();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, extended);
        block0: for (int j = i2; j < caseSections.length; ++j) {
            GrStatement[] statements2;
            GrCaseSection curSection = caseSections[j];
            for (GrStatement statement : statements2 = curSection.getStatements()) {
                if (statement instanceof GrBreakStatement && ((GrBreakStatement)statement).getLabelIdentifier() == null) break block0;
                statement.accept(generator);
                builder.append("\n");
            }
            if (SwitchStatementGenerator.brakesFlow(curSection)) break;
        }
        builder.append('}');
    }

    private static boolean brakesFlow(GrCaseSection section) {
        Object[] statements2 = section.getStatements();
        return statements2.length > 0 && !ControlFlowUtils.statementMayCompleteNormally((GrStatement)ArrayUtil.getLastElement((Object[])statements2));
    }

    private static void writeCondition(StringBuilder builder, ExpressionContext context, GrCaseSection section, List<GrCaseSection> currentSequentialSectionFrame, GrExpression[] args) {
        builder.append("if (");
        for (GrCaseSection prevSection : currentSequentialSectionFrame) {
            SwitchStatementGenerator.appendCaseSection(builder, context, args, prevSection);
        }
        SwitchStatementGenerator.appendCaseSection(builder, context, args, section);
        builder.delete(builder.length() - 2, builder.length());
        builder.append(") ");
    }

    private static void appendCaseSection(StringBuilder builder, ExpressionContext context, GrExpression[] args, GrCaseSection prevSection) {
        if (prevSection.isDefault()) {
            builder.append("true");
        } else {
            GenerationUtil.invokeMethodByName(prevSection.getExpressions()[0], "isCase", args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, new ExpressionGenerator(builder, context), prevSection);
        }
        builder.append("||");
    }

    private static String generateConditionVar(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition) {
        StringBuilder conditionBuilder = new StringBuilder();
        PsiType type2 = condition.getType();
        String varName = GenerationUtil.validateName("switchArg", condition, context);
        conditionBuilder.append("final ");
        TypeWriter.writeType(conditionBuilder, type2, condition);
        conditionBuilder.append(' ').append(varName).append(" = ");
        condition.accept(new ExpressionGenerator(conditionBuilder, context));
        conditionBuilder.append(";\n");
        GenerationUtil.insertStatementFromContextBefore(builder, context);
        builder.append((CharSequence)conditionBuilder);
        return varName;
    }

    private static void generateSwitch(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @Nullable GrExpression condition, GrCaseSection @NotNull [] caseSections) {
        builder.append("switch (");
        if (condition != null) {
            condition.accept(new ExpressionGenerator(builder, context));
        }
        builder.append(") {\n");
        ExpressionContext innerContext = context.extend();
        for (GrCaseSection section : caseSections) {
            SwitchStatementGenerator.generateCaseSection(builder, context, innerContext, section);
        }
        builder.append('}');
    }

    private static void generateCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull ExpressionContext innerContext, @NotNull GrCaseSection section) {
        SwitchStatementGenerator.writeLabel(builder, context, section);
        GrStatement[] statements2 = section.getStatements();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, innerContext);
        for (GrStatement statement : statements2) {
            statement.accept(generator);
            builder.append("\n");
        }
    }

    private static void writeLabel(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrCaseSection section) {
        if (section.isDefault()) {
            builder.append("default");
        } else {
            Object evaluated;
            builder.append("case ");
            GrExpression value2 = section.getExpressions()[0];
            try {
                evaluated = GroovyConstantExpressionEvaluator.evaluate(value2);
            }
            catch (Throwable e) {
                evaluated = null;
            }
            if (evaluated != null) {
                builder.append(evaluated);
            } else if (value2 != null) {
                value2.accept(new ExpressionGenerator(builder, context));
            }
        }
        builder.append(":\n");
    }
}

