/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class SetterWriter {
    private final StringBuilder myBuffer;
    private final PsiClass myClass;
    private final PsiMethod mySetter;
    private final String myName;
    private final ClassNameProvider myClassNameProvider;
    private final ExpressionContext myContext;

    public SetterWriter(@NotNull StringBuilder builder, @NotNull PsiClass psiClass, @NotNull PsiMethod setter, @NotNull String name, @NotNull ClassNameProvider classNameProvider, @NotNull ExpressionContext context) {
        this.myBuffer = builder;
        this.myClass = psiClass;
        this.myClassNameProvider = classNameProvider;
        this.myContext = context;
        this.myName = name;
        if (setter instanceof PsiCompiledElement) {
            setter = (PsiMethod)((PsiCompiledElement)setter).getMirror();
        }
        this.mySetter = setter;
    }

    public void write() {
        boolean isStatic = this.mySetter.hasModifierProperty("static");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.project);
        PsiParameter[] parameters2 = this.mySetter.getParameterList().getParameters();
        PsiParameter parameter = parameters2[parameters2.length - 1];
        PsiType parameterType = this.myContext.typeProvider.getParameterType(parameter);
        this.myBuffer.append("private static ");
        this.processTypeParameters(parameterType);
        this.myBuffer.append(this.myName);
        if (!(parameterType instanceof PsiPrimitiveType)) {
            parameter = factory.createParameter(parameter.getName(), "Value", null);
        }
        PsiParameter[] actual = this.inferActualParameters(isStatic, parameters2, parameter);
        GroovyPsiElement place = this.createStubMethod(actual);
        GenerationUtil.writeParameterList(this.myBuffer, actual, this.myClassNameProvider, this.myContext);
        this.writeBody(isStatic, parameters2, parameter, place);
    }

    private void writeBody(boolean aStatic, PsiParameter @NotNull [] parameters2, @NotNull PsiParameter parameter, GroovyPsiElement place) {
        this.myBuffer.append("{\n");
        this.myContext.myUsedVarNames.add("propOwner");
        GrExpression[] args = this.generateArguments(parameters2, place);
        new ExpressionGenerator(this.myBuffer, this.myContext).invokeMethodOn(this.mySetter, aStatic ? null : GroovyPsiElementFactory.getInstance(this.myContext.project).createExpressionFromText("propOwner", place), args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, PsiSubstitutor.EMPTY, place);
        this.myBuffer.append(";\n");
        this.myBuffer.append("return ").append(parameter.getName()).append(";\n");
        this.myBuffer.append("}\n");
    }

    private GrExpression @NotNull [] generateArguments(PsiParameter @NotNull [] parameters2, @NotNull GroovyPsiElement place) {
        GrExpression[] args = new GrExpression[parameters2.length];
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            args[i2] = GroovyPsiElementFactory.getInstance(this.myContext.project).createExpressionFromText(parameters2[i2].getName(), place);
            this.myContext.myUsedVarNames.add(parameters2[i2].getName());
        }
        return args;
    }

    private GroovyPsiElement createStubMethod(PsiParameter @NotNull [] parameters2) {
        StringBuilder methodText = new StringBuilder("def ").append(this.myName).append('(');
        for (PsiParameter parameter : parameters2) {
            methodText.append(parameter.getType().getCanonicalText()).append(' ').append(parameter.getName()).append(',');
        }
        if (parameters2.length > 0) {
            methodText.deleteCharAt(methodText.length() - 1);
        }
        methodText.append("){}");
        return GroovyPsiElementFactory.getInstance(this.myContext.project).createMethodFromText(methodText.toString(), (PsiElement)this.mySetter);
    }

    private PsiParameter @NotNull [] inferActualParameters(boolean aStatic, PsiParameter @NotNull [] parameters2, @NotNull PsiParameter parameter) {
        PsiParameter[] actual;
        parameters2[parameters2.length - 1] = parameter;
        if (aStatic) {
            actual = parameters2;
        } else {
            PsiClass containingClass = this.mySetter.getContainingClass();
            String typeText = containingClass == null ? (this.mySetter instanceof GrGdkMethod ? ((GrGdkMethod)this.mySetter).getReceiverType().getCanonicalText() : "java.lang.Object") : containingClass.getQualifiedName();
            GrParameter propOwner = GroovyPsiElementFactory.getInstance(this.myContext.project).createParameter("propOwner", typeText, null);
            actual = new PsiParameter[parameters2.length + 1];
            actual[0] = propOwner;
            System.arraycopy(parameters2, 0, actual, 1, parameters2.length);
        }
        return actual;
    }

    private void processTypeParameters(PsiType parameterType) {
        if (this.mySetter.hasTypeParameters()) {
            GenerationUtil.writeTypeParameters(this.myBuffer, (PsiTypeParameterListOwner)this.mySetter, this.myClassNameProvider);
        }
        if (parameterType instanceof PsiPrimitiveType) {
            this.myBuffer.append(parameterType.getCanonicalText()).append(' ');
        } else {
            if (this.mySetter.hasTypeParameters()) {
                this.myBuffer.delete(this.myBuffer.length() - 1, this.myBuffer.length());
                this.myBuffer.append(", ");
            } else {
                this.myBuffer.append('<');
            }
            this.myBuffer.append("Value");
            if (!parameterType.equalsToText("java.lang.Object")) {
                this.myBuffer.append(" extends ");
                TypeWriter.writeType(this.myBuffer, parameterType, (PsiElement)this.myClass, this.myClassNameProvider);
            }
            this.myBuffer.append('>');
            this.myBuffer.append("Value ");
        }
    }
}

