/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrClassMemberReferenceVisitor
extends GroovyRecursiveElementVisitor {
    private final PsiClass myClass;

    public GrClassMemberReferenceVisitor(@NotNull PsiClass aClass) {
        this.myClass = aClass;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression ref2) {
        PsiClass containingClass;
        GroovyResolveResult resolveResult2;
        PsiElement resolved;
        GrExpression qualifier = (GrExpression)ref2.getQualifier();
        if (qualifier != null && !PsiUtil.isThisOrSuperRef(qualifier)) {
            qualifier.accept(this);
            if (!(qualifier instanceof GrReferenceExpression) || !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                return;
            }
        }
        if ((resolved = (resolveResult2 = ref2.advancedResolve()).getElement()) instanceof GrMember && GrClassMemberReferenceVisitor.isPartOf(this.myClass, containingClass = ((GrMember)resolved).getContainingClass())) {
            this.visitClassMemberReferenceElement(ref2, (GrMember)resolved, resolveResult2);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement reference) {
        GroovyResolveResult resolveResult2 = reference.advancedResolve();
        PsiElement referencedElement = resolveResult2.getElement();
        if (referencedElement instanceof GrTypeDefinition) {
            GrTypeDefinition referencedClass = (GrTypeDefinition)referencedElement;
            if (PsiTreeUtil.isAncestor((PsiElement)this.myClass, (PsiElement)referencedElement, (boolean)true) || GrClassMemberReferenceVisitor.isPartOf(this.myClass, referencedClass.getContainingClass())) {
                this.visitClassMemberReferenceElement(reference, (GrMember)referencedElement, resolveResult2);
            }
        }
    }

    private static boolean isPartOf(@NotNull PsiClass aClass, @Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        return aClass.equals(containingClass) || aClass.isInheritor(containingClass, true);
    }

    protected void visitClassMemberReferenceElement(GrReferenceElement<?> ref2, GrMember member, GroovyResolveResult resolveResult2) {
        this.visitClassMemberReferenceElement(member, ref2);
    }

    protected void visitClassMemberReferenceElement(GrMember resolved, GrReferenceElement ref2) {
        throw new RuntimeException("Override one of visitClassMemberReferenceElement() methods");
    }
}

