/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class GrMethodDescriptor
implements MethodDescriptor<GrParameterInfo, String> {
    private final GrMethod myMethod;

    public GrMethodDescriptor(@NotNull GrMethod method) {
        this.myMethod = method;
    }

    public String getName() {
        return this.myMethod.getName();
    }

    @NotNull
    public List<GrParameterInfo> getParameters() {
        ArrayList<GrParameterInfo> result2 = new ArrayList<GrParameterInfo>();
        GrParameter[] parameters2 = this.myMethod.getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            GrParameter parameter = parameters2[i2];
            GrParameterInfo info = new GrParameterInfo(parameter, i2);
            result2.add(info);
        }
        return result2;
    }

    public int getParametersCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @NotNull
    public String getVisibility() {
        return VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList());
    }

    @NotNull
    public GrMethod getMethod() {
        return this.myMethod;
    }

    public boolean canChangeVisibility() {
        PsiClass containingClass = this.myMethod.getContainingClass();
        return containingClass != null && !containingClass.isInterface();
    }

    public boolean canChangeParameters() {
        return true;
    }

    public boolean canChangeName() {
        return !this.myMethod.isConstructor();
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        return this.myMethod.isConstructor() ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    public String getReturnTypeText() {
        GrTypeElement returnTypeElement = this.myMethod.getReturnTypeElementGroovy();
        return returnTypeElement != null ? returnTypeElement.getText() : "";
    }
}

