/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl;
import com.intellij.psi.scope.ElementClassHint;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyProperty;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class ResolverProcessorImpl
extends ResolverProcessor<GroovyResolveResult> {
    private Set<String> myProcessedClasses;
    private final PsiType[] myTypeArguments;

    protected ResolverProcessorImpl(@Nullable String name, @NotNull EnumSet<ElementClassHint.DeclarationKind> resolveTargets, @NotNull PsiElement place, PsiType @NotNull [] typeArguments) {
        super(name, resolveTargets, place);
        this.myTypeArguments = typeArguments;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element instanceof PsiLocalVariableImpl) {
            return true;
        }
        if (this.myResolveTargetKinds == null || this.myResolveTargetKinds.contains(ResolverProcessorImpl.getDeclarationKind(element))) {
            if (element instanceof PsiVariable && !(element instanceof PsiField) && this.myName != null && !this.myName.equals(((PsiVariable)element).getName())) {
                return true;
            }
            PsiNamedElement namedElement = (PsiNamedElement)element;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            if (substitutor2 == null) {
                substitutor2 = PsiSubstitutor.EMPTY;
            }
            if (this.myTypeArguments.length > 0 && namedElement instanceof PsiClass) {
                substitutor2 = substitutor2.putAll((PsiClass)namedElement, this.myTypeArguments);
            }
            if (namedElement instanceof PsiClass && !(namedElement instanceof PsiTypeParameter)) {
                PsiClass aClass = (PsiClass)namedElement;
                if (this.myProcessedClasses == null) {
                    this.myProcessedClasses = new HashSet<String>();
                }
                if (!this.myProcessedClasses.add(aClass.getQualifiedName())) {
                    return true;
                }
            }
            boolean isAccessible = this.isAccessible(namedElement);
            PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, false);
            this.addCandidate(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor2, isAccessible, isStaticsOK));
            return !isAccessible || !isStaticsOK;
        }
        return true;
    }

    private static ElementClassHint.DeclarationKind getDeclarationKind(PsiElement element) {
        if (element instanceof PsiMethod) {
            return ElementClassHint.DeclarationKind.METHOD;
        }
        if (element instanceof PsiEnumConstant) {
            return ElementClassHint.DeclarationKind.ENUM_CONST;
        }
        if (element instanceof PsiField) {
            return ElementClassHint.DeclarationKind.FIELD;
        }
        if (element instanceof GroovyProperty) {
            return ElementClassHint.DeclarationKind.FIELD;
        }
        if (element instanceof PsiVariable) {
            return ElementClassHint.DeclarationKind.VARIABLE;
        }
        if (element instanceof PsiClass) {
            return ElementClassHint.DeclarationKind.CLASS;
        }
        if (element instanceof PsiPackage) {
            return ElementClassHint.DeclarationKind.PACKAGE;
        }
        return null;
    }
}

