/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.LookbackSequenceKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.AccessibilityKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.AccessibilityKt$getContextClass$;
import org.jetbrains.plugins.groovy.lang.resolve.impl.AccessibilityKt$isPrivateMemberAccessibleFrom$;
import org.jetbrains.plugins.groovy.lang.resolve.impl.AccessibilityKt$isProtectedMemberAccessibleFrom$;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"getContextClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "place", "Lcom/intellij/psi/PsiElement;", "isAccessible", "", "member", "Lcom/intellij/psi/PsiMember;", "isInGroovyDoc", "isPackageLocalMemberAccessibleFrom", "isPrivateMemberAccessibleFrom", "isProtectedMemberAccessibleFrom", "intellij.groovy.psi"})
public final class AccessibilityKt {
    public static final boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place) {
        if (AccessibilityKt.isInGroovyDoc(place)) {
            return true;
        }
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return true;
        }
        return switch (PsiUtil.getAccessLevel((PsiModifierList)modifierList)) {
            case 4 -> true;
            case 3 -> AccessibilityKt.isProtectedMemberAccessibleFrom(place, member);
            case 2 -> AccessibilityKt.isPackageLocalMemberAccessibleFrom(place, member);
            case 1 -> AccessibilityKt.isPrivateMemberAccessibleFrom(member, place);
            default -> throw new IllegalStateException("unexpected access level".toString());
        };
    }

    private static final boolean isProtectedMemberAccessibleFrom(PsiElement place, PsiMember member) {
        if (JavaPsiFacade.getInstance((Project)place.getProject()).arePackagesTheSame((PsiElement)member, place)) {
            return true;
        }
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass memberClass = psiClass;
        Sequence<PsiElement> $this$filterIsInstance$iv = PsiTreeUtilKt.contexts(place);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)isProtectedMemberAccessibleFrom$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (GrTypeDefinition contextClass : sequence) {
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)memberClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isPackageLocalMemberAccessibleFrom(PsiElement place, PsiMember member) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)place.getProject());
        if (!facade.arePackagesTheSame((PsiElement)member, place)) {
            return false;
        }
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        PsiClass memberClass = psiClass;
        GrTypeDefinition grTypeDefinition = AccessibilityKt.getContextClass(place);
        if (grTypeDefinition == null) {
            return true;
        }
        GrTypeDefinition placeClass = grTypeDefinition;
        PsiClass psiClass2 = placeClass.getSuperClass();
        if (psiClass2 == null) {
            return true;
        }
        PsiClass placeSuperClass = psiClass2;
        if (!placeSuperClass.isInheritor(memberClass, true)) {
            return true;
        }
        for (PsiClass superClass : SequencesKt.generateSequence((Object)placeSuperClass, (Function1)isPackageLocalMemberAccessibleFrom.1.INSTANCE)) {
            if (Intrinsics.areEqual((Object)superClass, (Object)memberClass)) {
                return true;
            }
            if (facade.arePackagesTheSame((PsiElement)superClass, (PsiElement)memberClass)) continue;
            return false;
        }
        return false;
    }

    private static final boolean isPrivateMemberAccessibleFrom(PsiMember member, PsiElement place) {
        PsiClass psiClass2 = member.getContainingClass();
        GrTypeDefinition grTypeDefinition = psiClass2 instanceof GrTypeDefinition ? (GrTypeDefinition)psiClass2 : null;
        if (grTypeDefinition == null) {
            return false;
        }
        GrTypeDefinition memberClass = grTypeDefinition;
        if (memberClass instanceof GroovyScriptClass) {
            for (PsiClass psiClass2 : LookbackSequenceKt.withPrevious(PsiTreeUtilKt.contexts(place))) {
                PsiElement context = (PsiElement)psiClass2.component1();
                PsiElement previousContext = (PsiElement)psiClass2.component2();
                if (!(context instanceof GroovyFile) || previousContext instanceof GrTypeDefinition) continue;
                return Intrinsics.areEqual((Object)((GroovyFile)context).getScriptClass(), (Object)memberClass);
            }
            return false;
        }
        Sequence<PsiElement> $this$filterIsInstance$iv = PsiTreeUtilKt.contexts(memberClass);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)isPrivateMemberAccessibleFrom$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        GrTypeDefinition memberTopLevelClass = (GrTypeDefinition)SequencesKt.lastOrNull((Sequence)sequence);
        Sequence<PsiElement> $this$filterIsInstance$iv2 = PsiTreeUtilKt.contexts(place);
        boolean $i$f$filterIsInstance2 = false;
        Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv2, (Function1)isPrivateMemberAccessibleFrom$$inlined$filterIsInstance$2.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        GrTypeDefinition placeTopLevelClass = (GrTypeDefinition)SequencesKt.lastOrNull((Sequence)sequence2);
        return Intrinsics.areEqual((Object)placeTopLevelClass, (Object)memberTopLevelClass);
    }

    private static final boolean isInGroovyDoc(PsiElement place) {
        PsiElement $this$parentOfType_u24default$iv = place;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrDocComment.class, (boolean)true) != null;
    }

    private static final GrTypeDefinition getContextClass(PsiElement place) {
        Sequence<PsiElement> $this$filterIsInstance$iv = PsiTreeUtilKt.contexts(place);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)getContextClass$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (GrTypeDefinition)SequencesKt.firstOrNull((Sequence)sequence);
    }
}

