/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.api;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionReferenceKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ReceiverKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCachingReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyWriteReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.UnknownArgument;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyPropertyWriteReferenceBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCachingReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyPropertyWriteReference;", "element", "(Lcom/intellij/psi/PsiElement;)V", "doResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "getPropertyName", "", "newElementName", "handleElementRename", "intellij.groovy.psi"})
public abstract class GroovyPropertyWriteReferenceBase<T extends PsiElement>
extends GroovyCachingReference<T>
implements GroovyPropertyWriteReference {
    public GroovyPropertyWriteReferenceBase(@NotNull T element) {
        super(element);
    }

    @Override
    @NotNull
    public Collection<GroovyResolveResult> doResolve(boolean incomplete) {
        PsiElement place = this.getElement();
        Argument argument = this.getReceiverArgument();
        if (argument == null) {
            argument = UnknownArgument.INSTANCE;
        }
        Argument receiver = argument;
        String propertyName = this.getPropertyName();
        Argument argument2 = incomplete ? null : this.getArgument();
        ResolveState state = ResolveState.initial();
        GrResolverProcessor<?> propertyProcessor = GrReferenceExpressionReferenceKt.lValueProcessor(propertyName, place, GrReferenceExpressionReferenceKt.resolveKinds(true), argument2);
        ReceiverKt.processReceiver(receiver, propertyProcessor, state, place);
        return propertyProcessor.getResults();
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        String string = this.getPropertyName(newElementName);
        if (string == null) {
            string = newElementName;
        }
        return super.handleElementRename(string);
    }

    private final String getPropertyName(String newElementName) {
        Pair<String, PropertyKind> pair = this.resolve();
        PsiMethod psiMethod = pair instanceof PsiMethod ? (PsiMethod)pair : null;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod resolved = psiMethod;
        String referencedName = this.getPropertyName();
        if (Intrinsics.areEqual((Object)resolved.getName(), (Object)referencedName)) {
            return null;
        }
        if (!PropertyUtilKt.checkKind(resolved, PropertyKind.SETTER)) {
            return null;
        }
        Pair<String, PropertyKind> pair2 = PropertyUtilKt.getPropertyNameAndKind(newElementName);
        if (pair2 == null) {
            return null;
        }
        pair = pair2;
        String newPropertyName = (String)pair.component1();
        PropertyKind propertyKind = (PropertyKind)pair.component2();
        if (propertyKind != PropertyKind.SETTER) {
            return null;
        }
        return newPropertyName;
    }
}

