/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.FunctionalExpressionsKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ReceiverKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMapProperty;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DuplicateVariableProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.JavaResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineASTTransformationPerformer;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineTransformationUtilKt;

public final class ResolveUtil {
    public static final PsiScopeProcessor.Event DECLARATION_SCOPE_PASSED = new PsiScopeProcessor.Event(){};
    public static final Key<String> DOCUMENTATION_DELEGATE_FQN = Key.create((String)"groovy.documentation.delegate.fqn");
    private static final Key<PsiType> COMPARABLE = Key.create((String)"java.lang.Comparable");
    private static final Key<PsiType> SERIALIZABLE = Key.create((String)"java.io.Serializable");
    private static final Key<PsiType> STRING = Key.create((String)"java.lang.String");

    private ResolveUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor, boolean processNonCodeMembers) {
        return ResolveUtilKt.treeWalkUp(place, processor, ResolveUtilKt.initialState(processNonCodeMembers));
    }

    public static boolean treeWalkUp(@NotNull PsiElement place, @NotNull PsiElement originalPlace, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        PsiElement maxScope = null;
        if (ResolveUtilKt.processNonCodeMembers(state)) {
            maxScope = PsiTreeUtil.getParentOfType((PsiElement)place, GrFunctionalExpression.class);
        }
        return PsiTreeUtil.treeWalkUp((PsiElement)place, (PsiElement)maxScope, (scope, lastParent) -> {
            ProgressManager.checkCanceled();
            if (!ResolveUtil.doProcessDeclarations(originalPlace, lastParent, scope, ResolveUtil.substituteProcessor(processor, scope), state)) {
                return false;
            }
            ResolveUtil.issueLevelChangeEvents(processor, scope);
            return true;
        });
    }

    static boolean doProcessDeclarations(@NotNull PsiElement place, @Nullable PsiElement lastParent, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        boolean processNonCodeMembers = ResolveUtilKt.processNonCodeMembers(state);
        if (scope instanceof GrFunctionalExpression && processNonCodeMembers) {
            if (!FunctionalExpressionsKt.processDeclarationsWithCallsite((GrFunctionalExpression)scope, processor, state, lastParent, place)) {
                return false;
            }
        } else {
            if (scope instanceof PsiClass ? !ResolveUtil.processClassDeclarations((PsiClass)scope, processor, state, lastParent, place) : !scope.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (scope instanceof GrTypeDefinition && !ResolveUtil.processStaticImports(processor, place.getContainingFile(), state, place)) {
                return false;
            }
        }
        return !processNonCodeMembers || ResolveUtil.processScopeNonCodeMembers(place, lastParent, processor, scope, state);
    }

    static void issueLevelChangeEvents(PsiScopeProcessor processor, PsiElement run) {
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        if (run instanceof GrFunctionalExpression && "owner".equals(ResolveUtil.getNameHint(processor)) || run instanceof PsiClass && !(run instanceof PsiAnonymousClass) || run instanceof GrMethod && run.getParent() instanceof GroovyFile) {
            processor.handleEvent(DECLARATION_SCOPE_PASSED, (Object)run);
        }
    }

    static PsiScopeProcessor substituteProcessor(PsiScopeProcessor processor, PsiElement scope) {
        if (scope.getLanguage() != GroovyLanguage.INSTANCE && processor.getHint(NameHint.KEY) != null) {
            return new JavaResolverProcessor(processor);
        }
        return processor;
    }

    private static boolean processScopeNonCodeMembers(@NotNull PsiElement place, @Nullable PsiElement lastParent, @NotNull PsiScopeProcessor processor, @NotNull PsiElement scope, @NotNull ResolveState state) {
        PsiClass psiClass;
        if (scope instanceof GrTypeDefinition) {
            if (!ResolveUtil.processNonCodeMembers((PsiType)ResolveUtil.createPsiType((GrTypeDefinition)scope), processor, place, state)) {
                return false;
            }
            PsiClassType categoryType = GdkMethodUtil.getCategoryType((PsiClass)scope);
            if (categoryType != null) {
                if (!ResolveUtil.processNonCodeMembers((PsiType)categoryType, processor, place, state)) {
                    return false;
                }
                if (!GdkMethodUtil.processCategoryMethods(place, processor, state, (PsiClass)scope)) {
                    return false;
                }
            }
        }
        if (scope instanceof GroovyFileBase && ((GroovyFileBase)scope).isScript() && (psiClass = ((GroovyFileBase)scope).getScriptClass()) != null && !ResolveUtil.processNonCodeMembers((PsiType)ResolveUtil.createPsiType(psiClass), processor, place, state)) {
            return false;
        }
        if (scope instanceof GrFunctionalExpression) {
            ResolveState _state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)scope);
            if (!ResolveUtil.processNonCodeMembers((PsiType)TypesUtil.createType("groovy.lang.Closure", scope), processor, place, _state)) {
                return false;
            }
        }
        if (scope instanceof GrStatementOwner) {
            if (!GdkMethodUtil.processMixinToMetaclass((GrStatementOwner)scope, processor, state, lastParent, place)) {
                return false;
            }
            GroovyInlineASTTransformationPerformer performer = GroovyInlineTransformationUtilKt.getHierarchicalInlineTransformationPerformer(scope);
            if (performer != null && !performer.processResolve(processor, state, place)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static PsiClassType createPsiType(@NotNull PsiClass psiClass) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        return factory.createType(psiClass);
    }

    @Nullable
    public static String getNameHint(PsiScopeProcessor processor) {
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (nameHint == null) {
            return null;
        }
        return nameHint.getName(ResolveState.initial());
    }

    public static boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull PsiNamedElement namedElement, @NotNull ResolveState state) {
        String name;
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint == null ? null : nameHint.getName(state);
        if (name == null || name.equals(namedElement.getName())) {
            return processor.execute((PsiElement)namedElement, state);
        }
        return true;
    }

    public static boolean processAllDeclarations(@NotNull PsiType type2, @NotNull PsiScopeProcessor processor, boolean processNonCodeMembers, @NotNull PsiElement place) {
        return ResolveUtil.processAllDeclarations(type2, processor, ResolveUtilKt.initialState(processNonCodeMembers), place);
    }

    public static boolean processAllDeclarations(@NotNull PsiType type2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        return ReceiverKt.processReceiverType(type2, processor, state, place);
    }

    public static boolean processNonCodeMembers(@NotNull PsiType type2, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        return NonCodeMembersContributor.runContributors(type2, processor, place, state);
    }

    private static void collectSuperTypes(PsiType type2, Set<? super String> visited, Project project) {
        PsiType[] superTypes;
        String qName = ResolveUtil.rawCanonicalText(type2);
        if (!(type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() instanceof PsiTypeParameter || visited.add(qName))) {
            return;
        }
        for (PsiType superType : superTypes = type2.getSuperTypes()) {
            ResolveUtil.collectSuperTypes(TypeConversionUtil.erasure((PsiType)superType), visited, project);
        }
        if (type2 instanceof PsiArrayType && superTypes.length == 0) {
            PsiType comparable = ResolveUtil.createTypeFromText(project, COMPARABLE, "java.lang.Comparable");
            PsiType serializable = ResolveUtil.createTypeFromText(project, SERIALIZABLE, "java.io.Serializable");
            ResolveUtil.collectSuperTypes(comparable, visited, project);
            ResolveUtil.collectSuperTypes(serializable, visited, project);
        }
        if ("groovy.lang.GString".equals(qName)) {
            ResolveUtil.collectSuperTypes(ResolveUtil.createTypeFromText(project, STRING, "java.lang.String"), visited, project);
        }
    }

    public static PsiType createTypeFromText(Project project, Key<PsiType> key, String text) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType type2 = (PsiType)project.getUserData(key);
        if (type2 == null) {
            type2 = factory.createTypeFromText(text, null);
            project.putUserData(key, (Object)type2);
        }
        return type2;
    }

    public static Set<String> getAllSuperTypes(@NotNull PsiType base, Project project) {
        HashSet result2;
        Object key;
        Map cache2 = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentHashMap result2 = new ConcurrentHashMap();
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        PsiClass cls = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)base);
        if (cls instanceof PsiTypeParameter) {
            PsiClass superClass = cls.getSuperClass();
            key = cls.getName() + (superClass == null ? "java.lang.Object" : superClass.getName());
        } else {
            key = base instanceof PsiClassType ? TypesUtil.getQualifiedName(base) : base.getCanonicalText();
        }
        HashSet hashSet = result2 = key == null ? null : (HashSet)cache2.get(key);
        if (result2 == null) {
            result2 = new HashSet();
            ResolveUtil.collectSuperTypes(base, result2, project);
            if (key != null) {
                cache2.put(key, result2);
            }
        }
        return result2;
    }

    @NotNull
    private static String rawCanonicalText(@NotNull PsiType type2) {
        String qname;
        if (type2 instanceof PsiClassType && (qname = TypesUtil.getQualifiedName(type2)) != null) {
            return qname;
        }
        return TypeConversionUtil.erasure((PsiType)type2).getCanonicalText();
    }

    public static GroovyPsiElement resolveProperty(GroovyPsiElement place, String name) {
        PropertyResolverProcessor processor = new PropertyResolverProcessor(name, place);
        return (GroovyPsiElement)ResolveUtil.resolveExistingElement(place, processor, GrVariable.class, GrReferenceExpression.class);
    }

    @Nullable
    public static <T> T resolveExistingElement(PsiElement place, ResolverProcessor processor, Class<? extends T> ... classes2) {
        GroovyResolveResult[] candidates;
        ResolveUtil.treeWalkUp(place, processor, true);
        for (GroovyResolveResult candidate : candidates = processor.getCandidates()) {
            PsiElement element = candidate.getElement();
            if (element == place) continue;
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(element)) continue;
                return (T)element;
            }
        }
        return null;
    }

    @NotNull
    public static Pair<GrStatement, GrLabeledStatement> resolveLabelTargets(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        if (element == null) {
            return new Pair(null, null);
        }
        if (labelName == null) {
            do {
                if ((element = element.getContext()) != null && !(element instanceof GrClosableBlock) && !(element instanceof GrMember) && !(element instanceof GroovyFile)) continue;
                return new Pair(null, null);
            } while (!(element instanceof GrLoopStatement) && (!isBreak || !(element instanceof GrSwitchStatement)));
            return new Pair((Object)((GrStatement)element), null);
        }
        GrStatement statement = null;
        do {
            PsiElement last = element;
            if ((element = element.getContext()) == null || element instanceof GrMember || element instanceof GroovyFile) break;
            if (element instanceof GrStatement && !(element instanceof GrClosableBlock)) {
                statement = (GrStatement)element;
            }
            for (PsiElement sibling = element; sibling != null; sibling = sibling.getPrevSibling()) {
                GrLabeledStatement labelStatement = ResolveUtil.findLabelStatementIn(sibling, last, labelName);
                if (labelStatement == null) continue;
                return Pair.create((Object)statement, (Object)labelStatement);
            }
        } while (!(element instanceof GrClosableBlock));
        return new Pair(null, null);
    }

    private static boolean isApplicableLabelStatement(PsiElement element, String labelName) {
        return element instanceof GrLabeledStatement && labelName.equals(((GrLabeledStatement)element).getName());
    }

    @Nullable
    private static GrLabeledStatement findLabelStatementIn(PsiElement element, PsiElement lastChild, String labelName) {
        if (ResolveUtil.isApplicableLabelStatement(element, labelName)) {
            return (GrLabeledStatement)element;
        }
        for (PsiElement child = element.getFirstChild(); child != null && child != lastChild; child = child.getNextSibling()) {
            GrLabeledStatement statement = ResolveUtil.findLabelStatementIn(child, child, labelName);
            if (statement == null) continue;
            return statement;
        }
        return null;
    }

    @Nullable
    public static GrLabeledStatement resolveLabeledStatement(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        return (GrLabeledStatement)ResolveUtil.resolveLabelTargets((String)labelName, (PsiElement)element, (boolean)isBreak).second;
    }

    @Nullable
    public static GrStatement resolveLabelTargetStatement(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        return (GrStatement)ResolveUtil.resolveLabelTargets((String)labelName, (PsiElement)element, (boolean)isBreak).first;
    }

    public static boolean processCategoryMembers(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        PsiElement lastParent = null;
        for (PsiElement run = place; run != null; run = run.getContext()) {
            ProgressManager.checkCanceled();
            if (run instanceof GrStatementOwner && !GdkMethodUtil.processMixinToMetaclass((GrStatementOwner)run, processor, state, lastParent, place)) {
                return false;
            }
            lastParent = run;
        }
        return true;
    }

    public static PsiElement[] mapToElements(GroovyResolveResult[] candidates) {
        return com.intellij.psi.util.PsiUtil.mapElements((ResolveResult[])candidates);
    }

    public static GroovyResolveResult[] filterSameSignatureCandidates(Collection<? extends GroovyResolveResult> candidates) {
        if (candidates.size() == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (candidates.size() == 1) {
            return candidates.toArray(GroovyResolveResult.EMPTY_ARRAY);
        }
        ArrayList<GroovyResolveResult> result2 = new ArrayList<GroovyResolveResult>();
        Iterator<? extends GroovyResolveResult> allIterator = candidates.iterator();
        HashMap<String, List> cache2 = new HashMap<String, List>(candidates.size());
        while (allIterator.hasNext()) {
            PsiSubstitutor currentSubstitutor;
            PsiMethod currentMethod;
            GroovyResolveResult currentResult = allIterator.next();
            if (currentResult instanceof GroovyMethodResult) {
                GroovyMethodResult currentMethodResult = (GroovyMethodResult)currentResult;
                currentMethod = currentMethodResult.getElement();
                currentSubstitutor = currentMethodResult.getContextSubstitutor();
            } else if (currentResult.getElement() instanceof PsiMethod) {
                currentMethod = (PsiMethod)currentResult.getElement();
                currentSubstitutor = currentResult.getSubstitutor();
            } else {
                result2.add(currentResult);
                continue;
            }
            boolean isDominated = false;
            List existingCandidates = cache2.computeIfAbsent(ResolveUtil.getKey(currentMethod), __ -> new SmartList());
            ListIterator iterator2 = existingCandidates.listIterator();
            while (iterator2.hasNext()) {
                PsiSubstitutor otherSubstitutor;
                PsiMethod otherMethod;
                GroovyResolveResult candidateResult = (GroovyResolveResult)iterator2.next();
                if (candidateResult instanceof GroovyMethodResult) {
                    GroovyMethodResult otherMethodResult = (GroovyMethodResult)candidateResult;
                    otherMethod = otherMethodResult.getElement();
                    otherSubstitutor = otherMethodResult.getContextSubstitutor();
                } else {
                    if (!(candidateResult.getElement() instanceof PsiMethod)) continue;
                    otherMethod = (PsiMethod)candidateResult.getElement();
                    otherSubstitutor = candidateResult.getSubstitutor();
                }
                if (ResolveUtil.dominated(currentMethod, currentSubstitutor, otherMethod, otherSubstitutor)) {
                    isDominated = true;
                    break;
                }
                if (!ResolveUtil.dominated(otherMethod, otherSubstitutor, currentMethod, currentSubstitutor)) continue;
                iterator2.remove();
            }
            if (isDominated) continue;
            existingCandidates.add(currentResult);
        }
        for (List resultsByName : cache2.values()) {
            result2.addAll(resultsByName);
        }
        return result2.toArray(GroovyResolveResult.EMPTY_ARRAY);
    }

    private static String getKey(PsiMethod method) {
        int parameters2 = method.getParameters().length;
        String name = method.getName();
        return parameters2 + "_" + name;
    }

    public static boolean dominated(PsiMethod method1, PsiSubstitutor substitutor1, PsiMethod method2, PsiSubstitutor substitutor2) {
        PsiType t2;
        PsiType t1;
        PsiParameter[] params2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        if (params1.length != (params2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i2 = 0; i2 < params2.length; ++i2) {
            PsiType type2;
            PsiType type1;
            PsiType pType2;
            PsiType pType1 = params1[i2].getType();
            if (pType1 instanceof PsiEllipsisType) {
                pType1 = ((PsiEllipsisType)pType1).getComponentType().createArrayType();
            }
            if ((pType2 = params2[i2].getType()) instanceof PsiEllipsisType) {
                pType2 = ((PsiEllipsisType)pType2).getComponentType().createArrayType();
            }
            if ((type1 = TypeConversionUtil.erasure((PsiType)substitutor1.substitute(pType1))).equals(type2 = TypeConversionUtil.erasure((PsiType)substitutor2.substitute(pType2)))) continue;
            return false;
        }
        if (method1 instanceof GrGdkMethod && method2 instanceof GrGdkMethod && !(t1 = substitutor1.substitute(((GrGdkMethod)method1).getReceiverType())).equals(t2 = substitutor2.substitute(((GrGdkMethod)method2).getReceiverType()))) {
            if (t1 instanceof PsiClassType) {
                t1 = TypeConversionUtil.erasure((PsiType)t1);
            }
            if (t2 instanceof PsiClassType) {
                t2 = TypeConversionUtil.erasure((PsiType)t2);
            }
            return t1.isAssignableFrom(t2);
        }
        return !GdkMethodUtil.isMacro(method1);
    }

    public static GroovyResolveResult[] getCallVariants(GroovyPsiElement place) {
        PsiElement parent2 = place.getParent();
        GroovyResolveResult[] variants = GroovyResolveResult.EMPTY_ARRAY;
        if (parent2 instanceof GrCallExpression) {
            variants = ((GrCallExpression)parent2).getCallVariants(place instanceof GrExpression ? (GrExpression)place : null);
        } else if (parent2 instanceof GrConstructorInvocation) {
            PsiClass clazz = ((GrConstructorInvocation)parent2).getDelegatedClass();
            if (clazz != null) {
                PsiMethod[] constructors = clazz.getConstructors();
                variants = ResolveUtil.getConstructorResolveResult(constructors, place);
            }
        } else if (parent2 instanceof GrAnonymousClassDefinition) {
            PsiElement element = ((GrAnonymousClassDefinition)parent2).getBaseClassReferenceGroovy().resolve();
            if (element instanceof PsiClass) {
                PsiMethod[] constructors = ((PsiClass)element).getConstructors();
                variants = ResolveUtil.getConstructorResolveResult(constructors, place);
            }
        } else if (place instanceof GrReferenceExpression) {
            variants = ((GrReferenceExpression)place).getSameNameVariants();
        }
        return variants;
    }

    private static GroovyResolveResult[] getConstructorResolveResult(PsiMethod[] constructors, PsiElement place) {
        GroovyResolveResult[] variants = new GroovyResolveResult[constructors.length];
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            boolean isAccessible = com.intellij.psi.util.PsiUtil.isAccessible((PsiMember)constructors[i2], (PsiElement)place, null);
            variants[i2] = new GroovyResolveResultImpl((PsiElement)constructors[i2], isAccessible);
        }
        return variants;
    }

    public static boolean isKeyOfMap(GrReferenceExpression ref2) {
        if (!(ref2.getParent() instanceof GrIndexProperty) && PsiUtil.isCall(ref2)) {
            return false;
        }
        if (ref2.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            return false;
        }
        return ref2.resolve() instanceof GroovyMapProperty;
    }

    @Deprecated
    @Nullable
    public static GrExpression getSelfOrWithQualifier(GrReferenceExpression ref2) {
        GrClosableBlock closure;
        GrExpression qualifier = ref2.getQualifierExpression();
        if (qualifier != null) {
            return qualifier;
        }
        GrExpression place = ref2;
        while ((closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class, (boolean)true, (Class[])new Class[]{GrMember.class, GroovyFile.class})) != null) {
            GrExpression withQualifier;
            GrExpression expression;
            place = closure;
            PsiElement clParent = closure.getParent();
            if (clParent instanceof GrArgumentList) {
                clParent = clParent.getParent();
            }
            if (!(clParent instanceof GrMethodCall) || !((expression = ((GrMethodCall)clParent).getInvokedExpression()) instanceof GrReferenceExpression) || !GdkMethodUtil.isWithName(((GrReferenceExpression)expression).getReferenceName()) || !(((GrReferenceExpression)expression).resolve() instanceof GrGdkMethod) || (withQualifier = ((GrReferenceExpression)expression).getQualifierExpression()) == null) continue;
            return withQualifier;
        }
        return null;
    }

    public static GroovyResolveResult @NotNull [] getMethodCandidates(@NotNull PsiType thisType, @NlsSafe @Nullable String methodName, @NotNull PsiElement place, PsiType ... argumentTypes) {
        return ResolveUtil.getMethodCandidates(thisType, methodName, place, false, argumentTypes);
    }

    public static GroovyResolveResult @NotNull [] getMethodCandidates(@NotNull PsiType thisType, @NlsSafe @Nullable String methodName, @NotNull PsiElement place, boolean allVariants, PsiType ... argumentTypes) {
        if (methodName == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        thisType = TypesUtil.boxPrimitiveType(thisType, place.getManager(), place.getResolveScope());
        MethodResolverProcessor processor = new MethodResolverProcessor(methodName, place, false, thisType, argumentTypes, PsiType.EMPTY_ARRAY, allVariants);
        ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)place);
        ResolveUtil.processAllDeclarations(thisType, (PsiScopeProcessor)processor, state, place);
        boolean hasApplicableMethods = processor.hasApplicableCandidates();
        Object[] methodCandidates = processor.getCandidates();
        if (hasApplicableMethods && methodCandidates.length == 1) {
            return methodCandidates;
        }
        PropertyResolverProcessor propertyResolver = new PropertyResolverProcessor(methodName, place);
        ResolveUtil.processAllDeclarations(thisType, (PsiScopeProcessor)propertyResolver, state, place);
        GroovyResolveResult[] allPropertyCandidates = propertyResolver.getCandidates();
        ArrayList<GroovyResolveResult> propertyCandidates = new ArrayList<GroovyResolveResult>(allPropertyCandidates.length);
        for (GroovyResolveResult candidate : allPropertyCandidates) {
            PsiType type2;
            PsiElement resolved = candidate.getElement();
            if (!(resolved instanceof GrField) || !ResolveUtil.isApplicableClosureType(type2 = ((GrField)resolved).getTypeGroovy(), argumentTypes, place)) continue;
            propertyCandidates.add(candidate);
        }
        for (GroovyResolveResult candidate : propertyCandidates) {
            PsiClass containingClass;
            PsiElement element = candidate.getElement();
            if (!(element instanceof GrField) || (containingClass = ((PsiField)element).getContainingClass()) == null || !PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)place, (boolean)true)) continue;
            return new GroovyResolveResult[]{candidate};
        }
        ArrayList<GroovyResolveResult> allCandidates = new ArrayList<GroovyResolveResult>();
        if (hasApplicableMethods) {
            ContainerUtil.addAll(allCandidates, (Object[])methodCandidates);
        }
        allCandidates.addAll(propertyCandidates);
        for (PropertyKind kind : Arrays.asList(PropertyKind.GETTER, PropertyKind.BOOLEAN_GETTER)) {
            AccessorProcessor propertyProcessor = new AccessorProcessor(methodName, kind, Collections.emptyList(), place);
            ResolveUtil.processAllDeclarations(thisType, (PsiScopeProcessor)propertyProcessor, state, place);
            List<GroovyResolveResult> candidates = propertyProcessor.getResults();
            ArrayList<GroovyResolveResult> applicable = new ArrayList<GroovyResolveResult>();
            for (GroovyResolveResult candidate : candidates) {
                PsiMethod method = (PsiMethod)candidate.getElement();
                assert (method != null);
                PsiType type3 = PsiUtil.getSmartReturnType(method);
                if (!ResolveUtil.isApplicableClosureType(type3, argumentTypes, place)) continue;
                applicable.add(candidate);
            }
            if (applicable.size() == 1) {
                return applicable.toArray(GroovyResolveResult.EMPTY_ARRAY);
            }
            allCandidates.addAll(applicable);
        }
        if (!allCandidates.isEmpty()) {
            return allCandidates.toArray(GroovyResolveResult.EMPTY_ARRAY);
        }
        if (!hasApplicableMethods) {
            return methodCandidates;
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static boolean isApplicableClosureType(@Nullable PsiType type2, PsiType @Nullable [] argTypes, @NotNull PsiElement place) {
        if (!(type2 instanceof GrClosureType)) {
            if (type2 instanceof GroovyClosureType) {
                throw new RuntimeException();
            }
            return false;
        }
        if (argTypes == null) {
            return true;
        }
        List<GrSignature> signature = ((GrClosureType)type2).getSignatures();
        return GrClosureSignatureUtil.isSignatureApplicable(signature, argTypes, place);
    }

    public static boolean isEnumConstant(PsiReference ref2, String name, String qName) {
        PsiElement resolved = ref2.resolve();
        if (!(resolved instanceof PsiEnumConstant)) {
            return false;
        }
        if (!name.equals(((PsiEnumConstant)resolved).getName())) {
            return false;
        }
        PsiClass aClass = ((PsiEnumConstant)resolved).getContainingClass();
        if (aClass == null) {
            return false;
        }
        return qName.equals(aClass.getQualifiedName());
    }

    public static boolean isScriptField(GrVariable var) {
        PsiElement parent2 = var.getParent();
        return parent2 instanceof GrVariableDeclaration && ResolveUtil.isScriptFieldDeclaration((GrVariableDeclaration)parent2);
    }

    public static boolean isScriptFieldDeclaration(@NotNull GrVariableDeclaration declaration) {
        PsiFile containingFile = declaration.getContainingFile();
        if (!(containingFile instanceof GroovyFile) || !((GroovyFile)containingFile).isScript()) {
            return false;
        }
        GrMember member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)declaration, (Class[])new Class[]{GrTypeDefinition.class, GrMethod.class});
        if (member != null) {
            return false;
        }
        return GrAnnotationUtilKt.hasAnnotation(declaration.getModifierList(), "groovy.transform.Field");
    }

    public static boolean isFieldDeclaration(@NotNull GrVariableDeclaration declaration) {
        return declaration.getParent() instanceof GrTypeDefinitionBody || ResolveUtil.isScriptFieldDeclaration(declaration);
    }

    @Nullable
    public static GrScriptField findScriptField(@NotNull GrVariable var) {
        return (GrScriptField)CachedValuesManager.getCachedValue((PsiElement)var, () -> {
            PsiFile file = var.getContainingFile();
            if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
                PsiClass scriptClass = ((GroovyFile)file).getScriptClass();
                assert (scriptClass != null);
                for (PsiField field : scriptClass.getFields()) {
                    if (!(field instanceof GrScriptField) || ((GrScriptField)field).getOriginalVariable() != var) continue;
                    return CachedValueProvider.Result.create((Object)((GrScriptField)field), (Object[])new Object[]{var});
                }
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{var});
        });
    }

    @Nullable
    public static PsiClass resolveAnnotation(PsiElement insideAnnotation) {
        GrAnnotation annotation = (GrAnnotation)PsiTreeUtil.getParentOfType((PsiElement)insideAnnotation, GrAnnotation.class, (boolean)false);
        if (annotation == null) {
            return null;
        }
        GrCodeReferenceElement reference = annotation.getClassReference();
        GroovyResolveResult result2 = reference.advancedResolve();
        PsiElement element = result2.getElement();
        if (element instanceof PsiClass && ((PsiClass)element).isAnnotationType()) {
            return (PsiClass)element;
        }
        return null;
    }

    public static PsiNamedElement findDuplicate(@NotNull GrVariable variable) {
        PsiElement context;
        if (ResolveUtil.isScriptField(variable)) {
            String name = variable.getName();
            GroovyScriptClass script = (GroovyScriptClass)((GroovyFile)variable.getContainingFile()).getScriptClass();
            assert (script != null);
            List duplicates = ContainerUtil.filter((Object[])script.getFields(), f -> {
                if (!(f instanceof GrScriptField)) {
                    return false;
                }
                if (!name.equals(f.getName())) {
                    return false;
                }
                return ((GrScriptField)f).getOriginalVariable() != variable;
            });
            return duplicates.size() > 0 ? (PsiNamedElement)duplicates.get(0) : null;
        }
        PsiNamedElement duplicate = (PsiNamedElement)PsiTreeUtilKt.treeWalkUpAndGetElement(variable, new DuplicateVariableProcessor(variable));
        PsiElement context1 = variable.getContext();
        if (duplicate == null && variable instanceof GrParameter && context1 != null && ((context = context1.getContext()) instanceof GrClosableBlock || context instanceof GrMethod && !(context.getParent() instanceof GroovyFile) || context instanceof GrTryCatchStatement)) {
            duplicate = (PsiNamedElement)PsiTreeUtilKt.treeWalkUpAndGetElement(context.getParent(), new DuplicateVariableProcessor(variable));
        }
        if (duplicate instanceof GrLightParameter && "args".equals(duplicate.getName())) {
            return null;
        }
        return duplicate;
    }

    public static boolean canBeClassOrPackage(GrReferenceExpression ref2) {
        GrExpression qualifier = (GrExpression)ref2.getQualifier();
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement resolvedQualifier = ((GrReferenceExpression)qualifier).resolve();
            return resolvedQualifier instanceof PsiClass || resolvedQualifier instanceof PsiPackage;
        }
        return qualifier == null;
    }

    @NotNull
    public static List<Pair<PsiParameter, PsiType>> collectExpectedParamsByArg(@NotNull PsiElement place, GroovyResolveResult @NotNull [] variants, GrNamedArgument @NotNull [] namedArguments, GrExpression @NotNull [] expressionArguments, GrClosableBlock @NotNull [] closureArguments, @NotNull GrExpression arg) {
        ArrayList<Pair<PsiParameter, PsiType>> expectedParams = new ArrayList<Pair<PsiParameter, PsiType>>();
        for (GroovyResolveResult variant : variants) {
            if (variant instanceof GroovyMethodResult && ((GroovyMethodResult)variant).getCandidate() != null) {
                ArgumentMapping<PsiCallParameter> mapping2;
                GroovyMethodCandidate candidate = ((GroovyMethodResult)variant).getCandidate();
                if (candidate == null || (mapping2 = candidate.getArgumentMapping()) == null) continue;
                ExpressionArgument argument = new ExpressionArgument(arg);
                PsiCallParameter obj = mapping2.targetParameter(argument);
                PsiParameter targetParameter = obj == null ? null : obj.getPsi();
                PsiType expectedType = mapping2.expectedType(argument);
                ContainerUtil.addIfNotNull(expectedParams, (Object)Pair.create((Object)targetParameter, (Object)expectedType));
                continue;
            }
            Map<GrExpression, Pair<PsiParameter, PsiType>> map2 = GrClosureSignatureUtil.mapArgumentsToParameters(variant, place, true, true, namedArguments, expressionArguments, closureArguments);
            if (map2 == null) continue;
            Pair<PsiParameter, PsiType> pair = map2.get(arg);
            ContainerUtil.addIfNotNull(expectedParams, pair);
        }
        return expectedParams;
    }

    public static boolean shouldProcessClasses(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
    }

    public static boolean shouldProcessMethods(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD);
    }

    public static boolean shouldProcessProperties(ElementClassHint classHint) {
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE) || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD) || classHint.shouldProcess(ElementClassHint.DeclarationKind.ENUM_CONST);
    }

    public static boolean processStaticImports(@NotNull PsiScopeProcessor resolver, @NotNull PsiFile file, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (!ResolveUtil.shouldProcessMethods((ElementClassHint)resolver.getHint(ElementClassHint.KEY))) {
            return true;
        }
        return file.processDeclarations((PsiScopeProcessor)new GrDelegatingScopeProcessorWithHints(resolver, null, ClassHint.RESOLVE_KINDS_METHOD){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState _state) {
                if (_state.get(ClassHint.RESOLVE_CONTEXT) instanceof GrImportStatement) {
                    super.execute(element, _state);
                }
                return true;
            }
        }, state, null, place);
    }

    public static boolean resolvesToClass(@Nullable PsiElement expression) {
        if (!(expression instanceof GrQualifiedReference)) {
            return false;
        }
        return ResolveUtil.isClassReference(expression) || ((GrQualifiedReference)expression).resolve() instanceof PsiClass;
    }

    public static boolean isClassReference(@NotNull PsiElement expression) {
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref2 = (GrReferenceExpression)expression;
        GrExpression qualifier = (GrExpression)ref2.getQualifier();
        if (!"class".equals(ref2.getReferenceName())) {
            return false;
        }
        return qualifier != null && ResolveUtil.getClassReferenceFromExpression(qualifier) != null;
    }

    @Nullable
    public static PsiType getClassReferenceFromExpression(@NotNull PsiElement expression) {
        if (expression instanceof GrReferenceExpression) {
            if (PsiUtil.isThisReference(expression)) {
                return null;
            }
            PsiElement resolved = ((GrReferenceExpression)expression).resolve();
            if (resolved instanceof PsiClass) {
                return TypesUtil.createType((PsiClass)resolved);
            }
        }
        if (expression instanceof GrBuiltinTypeClassExpression) {
            return ((GrBuiltinTypeClassExpression)expression).getPrimitiveType();
        }
        if (expression instanceof GrIndexProperty) {
            if (((GrIndexProperty)expression).getArgumentList().getAllArguments().length != 0) {
                return null;
            }
            PsiType arrayTypeBase = ResolveUtil.getClassReferenceFromExpression(((GrIndexProperty)expression).getInvokedExpression());
            return arrayTypeBase == null ? null : arrayTypeBase.createArrayType();
        }
        return null;
    }

    @Nullable
    public static PsiType unwrapClassType(@Nullable PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiType[] params = ((PsiClassType)type2).getParameters();
        if (params.length != 1) {
            return null;
        }
        return params[0];
    }

    public static boolean isAccessible(@NotNull PsiElement place, @NotNull PsiNamedElement namedElement) {
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(place, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(place, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(place, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(place, (PsiMember)namedElement);
    }

    public static boolean isStaticsOK(@NotNull PsiElement place, @NotNull PsiNamedElement element, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return GrStaticChecker.isStaticsOK((PsiModifierListOwner)element, place, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    public static boolean canResolveToMethod(@NotNull GrReferenceExpression ref2) {
        assert (!ref2.hasMemberPointer());
        return ref2.getParent() instanceof GrMethodCall;
    }

    public static boolean processClassDeclarations(@NotNull PsiClass scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        for (PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
            if (scope.processDeclarations(psiScopeProcessor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }
}

