/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class MethodTypeInferencer
implements Computable<PsiType> {
    private final GrStatementOwner myBlock;

    public MethodTypeInferencer(GrStatementOwner block) {
        this.myBlock = block;
    }

    @Nullable
    public PsiType compute() {
        List<GrStatement> returns = ControlFlowUtils.collectReturns(this.myBlock);
        if (returns.isEmpty()) {
            return PsiType.VOID;
        }
        PsiType result2 = null;
        PsiManager manager = this.myBlock.getManager();
        for (GrStatement returnStatement : returns) {
            GrExpression value2 = null;
            if (returnStatement instanceof GrReturnStatement) {
                value2 = ((GrReturnStatement)returnStatement).getReturnValue();
            } else if (returnStatement instanceof GrExpression) {
                value2 = (GrExpression)returnStatement;
            }
            if (value2 == null) continue;
            result2 = TypesUtil.getLeastUpperBoundNullable(result2, value2.getType(), manager);
        }
        return result2;
    }
}

