/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.caches.InnersCacheKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a$\u0010\r\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u000e\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a$\u0010\u0010\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0011\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0012\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\"\u0010\u0013\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0014\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0015"}, d2={"useCaches", "", "place", "Lcom/intellij/psi/PsiElement;", "collectOuterClasses", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "doProcessInnerClasses", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "doProcessInnersInClassAndInterfaces", "doProcessInterfaces", "doProcessOwnInnerClasses", "doProcessOwnInterfaces", "processInnerInHierarchy", "processInnersInHierarchyNoCache", "processInnersInOuters", "processInnersInOutersNoCache", "intellij.groovy.psi"})
public final class InnersKt {
    public static final boolean processInnerInHierarchy(@NotNull GrTypeDefinition $this$processInnerInHierarchy, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (InnersKt.useCaches(place)) {
            return InnersCacheKt.getInnersHierarchyCache($this$processInnerInHierarchy).processDeclarations(processor, state, place);
        }
        return InnersKt.processInnersInHierarchyNoCache($this$processInnerInHierarchy, processor, state, place);
    }

    public static final boolean processInnersInOuters(@NotNull GrTypeDefinition $this$processInnersInOuters, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (InnersKt.useCaches(place)) {
            return InnersCacheKt.getInnersOutersCache($this$processInnersInOuters).processDeclarations(processor, state, place);
        }
        return InnersKt.processInnersInOutersNoCache($this$processInnersInOuters, processor, state, place);
    }

    public static final boolean processInnersInHierarchyNoCache(@NotNull GrTypeDefinition $this$processInnersInHierarchyNoCache, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (!InnersKt.doProcessInnersInClassAndInterfaces($this$processInnersInHierarchyNoCache, processor, state, place)) {
            return false;
        }
        for (PsiClass superClass = GrClassImplUtil.getSuperClass($this$processInnersInHierarchyNoCache, $this$processInnersInHierarchyNoCache.getExtendsListTypes(false)); superClass != null; superClass = superClass.getSuperClass()) {
            if (!InnersKt.doProcessInnerClasses(superClass, processor, state)) {
                return false;
            }
            if (InnersKt.doProcessInterfaces(superClass, processor, state, place)) continue;
            return false;
        }
        return true;
    }

    private static final boolean doProcessInnersInClassAndInterfaces(GrTypeDefinition $this$doProcessInnersInClassAndInterfaces, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        return InnersKt.doProcessOwnInnerClasses($this$doProcessInnersInClassAndInterfaces, processor, state) && InnersKt.doProcessOwnInterfaces($this$doProcessInnersInClassAndInterfaces, processor, state, place);
    }

    private static final boolean doProcessOwnInterfaces(GrTypeDefinition $this$doProcessOwnInterfaces, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        for (PsiClass anInterface : GrClassImplUtil.getInterfaces($this$doProcessOwnInterfaces, false)) {
            if (anInterface.processDeclarations(processor, state, null, place)) continue;
            return false;
        }
        return true;
    }

    private static final boolean doProcessOwnInnerClasses(GrTypeDefinition $this$doProcessOwnInnerClasses, PsiScopeProcessor processor, ResolveState state) {
        String name = ResolveUtilKt.getName(processor, state);
        if (name == null) {
            for (GrTypeDefinition inner : $this$doProcessOwnInnerClasses.getCodeInnerClasses()) {
                if (processor.execute((PsiElement)inner, state)) continue;
                return false;
            }
        } else {
            for (GrTypeDefinition inner : $this$doProcessOwnInnerClasses.getCodeInnerClasses()) {
                if (!Intrinsics.areEqual((Object)inner.getName(), (Object)name) || processor.execute((PsiElement)inner, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean doProcessInnerClasses(PsiClass $this$doProcessInnerClasses, PsiScopeProcessor processor, ResolveState state) {
        String name = ResolveUtilKt.getName(processor, state);
        if (name == null) {
            for (PsiClass inner : $this$doProcessInnerClasses.getInnerClasses()) {
                if (processor.execute((PsiElement)inner, state)) continue;
                return false;
            }
        } else {
            PsiClass inner = $this$doProcessInnerClasses.findInnerClassByName(name, false);
            if (inner != null && !processor.execute((PsiElement)inner, state)) {
                return false;
            }
        }
        return true;
    }

    private static final boolean doProcessInterfaces(PsiClass $this$doProcessInterfaces, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        for (PsiClass anInterface : $this$doProcessInterfaces.getInterfaces()) {
            if (anInterface.processDeclarations(processor, state, null, place)) continue;
            return false;
        }
        return true;
    }

    public static final boolean processInnersInOutersNoCache(@NotNull GrTypeDefinition $this$processInnersInOutersNoCache, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        List outers = CollectionsKt.reversed((Iterable)InnersKt.collectOuterClasses($this$processInnersInOutersNoCache));
        for (GrTypeDefinition outer : outers) {
            if (InnersKt.doProcessInnersInClassAndInterfaces(outer, processor, state, place)) continue;
            return false;
        }
        return true;
    }

    private static final List<GrTypeDefinition> collectOuterClasses(GrTypeDefinition $this$collectOuterClasses) {
        PsiElement $this$parentsOfType_u24default$iv = $this$collectOuterClasses;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        return SequencesKt.toList((Sequence)SequencesKt.drop((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, GrTypeDefinition.class, (boolean)withSelf$iv), (int)1));
    }

    private static final boolean useCaches(PsiElement place) {
        if (place.getParent() instanceof GrAnnotation) {
            return false;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        PsiFile containingFile = place.getContainingFile();
        if (containingFile.getOriginalFile() != containingFile) {
            return false;
        }
        return Intrinsics.areEqual((Object)containingFile.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING), (Object)true);
    }
}

