/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.beans.Introspector;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0003\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u0001*\u0004\u0018\u00010\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0003H\u0000\u00a8\u0006\u0016"}, d2={"checkBaseName", "", "accessorName", "", "prefixLength", "", "getKindByPrefix", "Lcom/intellij/lang/java/beans/PropertyKind;", "getPropertyNameAndKind", "Lkotlin/Pair;", "checkKind", "Lcom/intellij/psi/PsiMethod;", "kind", "getAccessorName", "propertyName", "getPropertyName", "method", "methodName", "getPropertyNameInner", "isBooleanOrBoxed", "Lcom/intellij/psi/PsiType;", "isPropertyName", "intellij.groovy.psi"})
public final class PropertyUtilKt {
    @Nullable
    public static final Pair<String, PropertyKind> getPropertyNameAndKind(@NotNull String accessorName) {
        PropertyKind propertyKind = PropertyUtilKt.getKindByPrefix(accessorName);
        if (propertyKind == null) {
            return null;
        }
        PropertyKind propertyKind2 = propertyKind;
        String string = PropertyUtilKt.getPropertyNameInner(propertyKind2, accessorName);
        if (string == null) {
            return null;
        }
        String propertyName = string;
        return TuplesKt.to((Object)propertyName, (Object)propertyKind2);
    }

    private static final PropertyKind getKindByPrefix(String accessorName) {
        PropertyKind propertyKind;
        block1: {
            PropertyKind[] propertyKindArray = PropertyKind.values();
            int n = propertyKindArray.length;
            for (int j = 0; j < n; ++j) {
                PropertyKind propertyKind2;
                PropertyKind it = propertyKind2 = propertyKindArray[j];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)accessorName, (String)it.prefix, (boolean)false, (int)2, null)) continue;
                propertyKind = propertyKind2;
                break block1;
            }
            propertyKind = null;
        }
        return propertyKind;
    }

    private static final String getPropertyNameInner(PropertyKind $this$getPropertyNameInner, String accessorName) {
        int prefixLength = $this$getPropertyNameInner.prefix.length();
        if (!PropertyUtilKt.checkBaseName(accessorName, prefixLength)) {
            return null;
        }
        String string = accessorName.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return Introspector.decapitalize(string);
    }

    private static final boolean checkBaseName(String accessorName, int prefixLength) {
        if (accessorName.length() <= prefixLength) {
            return false;
        }
        if (Character.isUpperCase(accessorName.charAt(prefixLength))) {
            return true;
        }
        if (accessorName.length() <= prefixLength + 1) {
            return false;
        }
        return Character.isUpperCase(accessorName.charAt(prefixLength + 1));
    }

    public static final boolean checkKind(@NotNull PsiMethod $this$checkKind, @NotNull PropertyKind kind) {
        int expectedParamCount;
        int n = expectedParamCount = kind == PropertyKind.SETTER ? 1 : 0;
        if ($this$checkKind.getParameterList().getParametersCount() != expectedParamCount) {
            return false;
        }
        if (kind == PropertyKind.GETTER && Intrinsics.areEqual((Object)$this$checkKind.getReturnType(), (Object)PsiType.VOID)) {
            return false;
        }
        return kind != PropertyKind.BOOLEAN_GETTER || PropertyUtilKt.isBooleanOrBoxed($this$checkKind.getReturnType());
    }

    private static final boolean isBooleanOrBoxed(PsiType $this$isBooleanOrBoxed) {
        return Intrinsics.areEqual((Object)$this$isBooleanOrBoxed, (Object)PsiType.BOOLEAN) || Intrinsics.areEqual((Object)PsiPrimitiveType.getUnboxedType((PsiType)$this$isBooleanOrBoxed), (Object)PsiType.BOOLEAN);
    }

    public static final boolean isPropertyName(@NotNull String $this$isPropertyName) {
        return GroovyPropertyUtils.isPropertyName($this$isPropertyName);
    }

    @NotNull
    public static final String getAccessorName(@NotNull PropertyKind $this$getAccessorName, @NotNull String propertyName) {
        String suffix = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? propertyName : StringsKt.capitalize((String)propertyName);
        return $this$getAccessorName.prefix + suffix;
    }

    @Nullable
    public static final String getPropertyName(@NotNull PropertyKind $this$getPropertyName, @NotNull PsiMethod method) {
        String string = PropertyUtilKt.getPropertyName($this$getPropertyName, method.getName());
        if (string == null) {
            return null;
        }
        String propertyName = string;
        return PropertyUtilKt.checkKind(method, $this$getPropertyName) ? propertyName : null;
    }

    @Nullable
    public static final String getPropertyName(@NotNull PropertyKind $this$getPropertyName, @NotNull String methodName) {
        if (!StringsKt.startsWith$default((String)methodName, (String)$this$getPropertyName.prefix, (boolean)false, (int)2, null)) {
            return null;
        }
        return PropertyUtilKt.getPropertyNameInner($this$getPropertyName, methodName);
    }
}

