/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GrInnerClassConstructorUtil {
    public static GrParameter @NotNull [] addEnclosingInstanceParam(@NotNull GrMethod method, @NotNull PsiClass enclosingClass, GrParameter @NotNull [] originalParams, boolean isOptional) {
        PsiClassType enclosingClassType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(enclosingClass, PsiSubstitutor.EMPTY);
        GrLightParameter enclosing = new GrLightParameter("enclosing", (PsiType)enclosingClassType, method);
        if (isOptional) {
            enclosing.setOptional(true);
            enclosing.setInitializerGroovy(GroovyPsiElementFactory.getInstance(method.getProject()).createExpressionFromText("null"));
        }
        return (GrParameter[])ArrayUtil.prepend((Object)enclosing, (Object[])originalParams);
    }

    public static boolean isInnerClassConstructorUsedOutsideOfItParent(@NotNull PsiMethod method, PsiElement place) {
        PsiClass containingClass;
        PsiClass aClass;
        return method instanceof GrMethod && method.isConstructor() && (aClass = method.getContainingClass()) != null && !aClass.hasModifierProperty("static") && (containingClass = aClass.getContainingClass()) != null && PsiUtil.findEnclosingInstanceClassInScope(containingClass, place, true) == null;
    }

    @Nullable
    public static PsiClass enclosingClass(@NotNull PsiElement place, @NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (!aClass.hasModifierProperty("static") && (containingClass = aClass.getContainingClass()) != null && PsiUtil.hasEnclosingInstanceInScope(containingClass, place, true)) {
            return containingClass;
        }
        return null;
    }
}

