/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyClassImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.lang.resolve.CompilationPhaseHint;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public final class GrClassImplUtil {
    private static final Logger LOG = Logger.getInstance(GrClassImplUtil.class);
    private static final Condition<PsiMethod> CONSTRUCTOR_CONDITION = PsiMethod::isConstructor;

    private GrClassImplUtil() {
    }

    public static GrMethod @NotNull [] getCodeConstructors(@NotNull GrTypeDefinition definition) {
        Object[] methods = definition.getCodeMethods();
        List result2 = ContainerUtil.filter((Object[])methods, CONSTRUCTOR_CONDITION);
        return result2.toArray(GrMethod.EMPTY_ARRAY);
    }

    public static PsiMethod @NotNull [] getConstructors(@NotNull GrTypeDefinition definition) {
        Object[] methods = definition.getMethods();
        List result2 = ContainerUtil.filter((Object[])methods, CONSTRUCTOR_CONDITION);
        return result2.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Nullable
    public static PsiClass findInnerClassByName(GrTypeDefinition grType, String name, boolean checkBases) {
        if (!checkBases) {
            for (PsiClass inner : grType.getInnerClasses()) {
                if (!name.equals(inner.getName())) continue;
                return inner;
            }
            return null;
        }
        Map<String, CandidateInfo> innerClasses = CollectClassMembersUtil.getAllInnerClasses(grType, true);
        CandidateInfo info = innerClasses.get(name);
        return info == null ? null : (PsiClass)info.getElement();
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull GrTypeDefinition grType) {
        return GrClassImplUtil.getSuperClass(grType, grType.getExtendsListTypes());
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull GrTypeDefinition grType, PsiClassType @NotNull [] extendsListTypes) {
        if (extendsListTypes.length == 0) {
            return GrClassImplUtil.getBaseClass(grType);
        }
        PsiClass superClass = extendsListTypes[0].resolve();
        return superClass != null ? superClass : GrClassImplUtil.getBaseClass(grType);
    }

    @Nullable
    public static PsiClass getBaseClass(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Enum", grType.getResolveScope());
        }
        return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Object", grType.getResolveScope());
    }

    public static PsiClassType @NotNull [] getSuperTypes(GrTypeDefinition grType, boolean includeSynthetic) {
        Object[] extendsList = grType.getExtendsListTypes(includeSynthetic);
        if (extendsList.length == 0) {
            extendsList = new PsiClassType[]{GrClassImplUtil.createBaseClassType(grType)};
        }
        return (PsiClassType[])ArrayUtil.mergeArrays((Object[])extendsList, (Object[])grType.getImplementsListTypes(includeSynthetic), (ArrayFactory)PsiClassType.ARRAY_FACTORY);
    }

    public static PsiClassType createBaseClassType(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return TypesUtil.createTypeByFQClassName("java.lang.Enum", grType);
        }
        return TypesUtil.getJavaLangObject(grType);
    }

    public static PsiMethod @NotNull [] getAllMethods(GrTypeDefinition grType) {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)grType, () -> {
            ArrayList list = new ArrayList();
            GrClassImplUtil.getAllMethodsInner(grType, list, new HashSet());
            return CachedValueProvider.Result.create((Object)list.toArray(PsiMethod.EMPTY_ARRAY), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, grType});
        });
    }

    @NotNull
    public static List<PsiMethod> getAllMethods(Collection<? extends PsiClass> classes2) {
        ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
        HashSet visited = new HashSet();
        for (PsiClass psiClass : classes2) {
            GrClassImplUtil.getAllMethodsInner(psiClass, allMethods, visited);
        }
        return allMethods;
    }

    private static void getAllMethodsInner(PsiClass clazz, List<? super PsiMethod> allMethods, HashSet<? super PsiClass> visited) {
        PsiClass[] supers;
        if (visited.contains(clazz)) {
            return;
        }
        visited.add((PsiClass)clazz);
        ContainerUtil.addAll(allMethods, (Object[])clazz.getMethods());
        for (PsiClass aSuper : supers = clazz.getSupers()) {
            GrClassImplUtil.getAllMethodsInner(aSuper, allMethods, visited);
        }
    }

    public static PsiClassType[] getReferenceListTypes(@Nullable GrReferenceList list) {
        if (list == null) {
            return PsiClassType.EMPTY_ARRAY;
        }
        return list.getReferencedTypes();
    }

    public static PsiClass @NotNull [] getInterfaces(GrTypeDefinition grType) {
        return GrClassImplUtil.getInterfaces(grType, true);
    }

    public static PsiClass @NotNull [] getInterfaces(GrTypeDefinition grType, boolean includeSynthetic) {
        PsiClassType[] implementsListTypes = grType.getImplementsListTypes(includeSynthetic);
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(implementsListTypes.length);
        for (PsiClassType type2 : implementsListTypes) {
            PsiClass psiClass = type2.resolve();
            if (psiClass == null) continue;
            result2.add(psiClass);
        }
        return result2.toArray(PsiClass.EMPTY_ARRAY);
    }

    public static PsiClass @NotNull [] getSupers(GrTypeDefinition grType, boolean includeSynthetic) {
        PsiClassType[] superTypes = grType.getSuperTypes(includeSynthetic);
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        for (PsiClassType superType : superTypes) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            result2.add(superClass);
        }
        return result2.toArray(PsiClass.EMPTY_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean processDeclarations(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        NameHint nameHint;
        if (ResolveUtilKt.isAnnotationResolve(processor)) {
            return true;
        }
        if (processor.getHint(CompilationPhaseHint.HINT_KEY) != null) {
            return GroovyClassImplUtilKt.processPhase(grType, processor, state);
        }
        if (ResolveUtilKt.shouldProcessTypeParameters(processor)) {
            for (PsiTypeParameter typeParameter : grType.getTypeParameters()) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
                return false;
            }
        }
        String name = (nameHint = (NameHint)processor.getHint(NameHint.KEY)) == null ? null : nameHint.getName(state);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        PsiSubstitutor substitutor2 = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        boolean processInstanceMethods = (ResolveUtil.shouldProcessMethods(classHint) || ResolveUtil.shouldProcessProperties(classHint)) && GrClassImplUtil.shouldProcessInstanceMembers(grType, lastParent);
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)place);
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
            if (name != null) {
                PsiField field;
                fieldInfo = fieldsMap.get(name);
                if (fieldInfo != null ? !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor2, factory, level, (CandidateInfo)fieldInfo) : grType.isTrait() && lastParent != null && (field = GrClassImplUtil.findFieldByName(grType, name, false, true)) != null && field.hasModifierProperty("public") && !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor2, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) {
                    return false;
                }
            } else {
                for (CandidateInfo info : fieldsMap.values()) {
                    if (GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor2, factory, level, info)) continue;
                    return false;
                }
                if (grType.isTrait() && lastParent != null) {
                    void var15_23;
                    fieldInfo = CollectClassMembersUtil.getFields(grType, true);
                    int info = fieldInfo.length;
                    boolean bl = false;
                    while (var15_23 < info) {
                        PsiField field = fieldInfo[var15_23];
                        if (field.hasModifierProperty("public") && !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor2, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) {
                            return false;
                        }
                        ++var15_23;
                    }
                }
            }
        }
        if (ResolveUtil.shouldProcessMethods(classHint)) {
            boolean isPlaceGroovy;
            Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
            boolean bl = isPlaceGroovy = place.getLanguage() == GroovyLanguage.INSTANCE;
            if (name == null) {
                for (List list : methodsMap.values()) {
                    for (CandidateInfo info : list) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor2, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            } else {
                List<CandidateInfo> byName = methodsMap.get(name);
                if (byName != null) {
                    for (CandidateInfo info : byName) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor2, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            }
        }
        if (ResolveUtil.shouldProcessClasses(classHint)) {
            Map<String, CandidateInfo> classes2 = CollectClassMembersUtil.getAllInnerClasses(grType, true);
            if (name == null) {
                for (CandidateInfo info : classes2.values()) {
                    if (processor.execute(info.getElement(), state)) continue;
                    return false;
                }
            } else {
                CandidateInfo info = classes2.get(name);
                if (info != null && !processor.execute(info.getElement(), state)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processField(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean processInstanceMethods, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElementFactory factory, @NotNull LanguageLevel level, CandidateInfo fieldInfo) {
        PsiField field = (PsiField)fieldInfo.getElement();
        if (!GrClassImplUtil.shouldProcessTraitMember(grType, (PsiMember)field, place)) {
            return true;
        }
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)field) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)field)) {
            return true;
        }
        LOG.assertTrue(field.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)field.getContainingClass(), (PsiSubstitutor)fieldInfo.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor2, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)field, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean processMethod(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean processInstanceMethods, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElementFactory factory, @NotNull LanguageLevel level, boolean placeGroovy, @NotNull CandidateInfo info) {
        PsiMethod method = (PsiMethod)info.getElement();
        if (!GrClassImplUtil.shouldProcessTraitMember(grType, (PsiMember)method, place)) {
            return true;
        }
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)method) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)method) || !GrClassImplUtil.isMethodVisible(placeGroovy, method)) {
            return true;
        }
        LOG.assertTrue(method.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)method.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor2, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)method, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean shouldProcessTraitMember(@NotNull GrTypeDefinition grType, @NotNull PsiMember element, @NotNull PsiElement place) {
        return !grType.isTrait() || !element.hasModifierProperty("static") || grType.equals(element.getContainingClass()) && PsiTreeUtil.isAncestor((PsiElement)grType, (PsiElement)place, (boolean)true);
    }

    private static boolean shouldProcessInstanceMembers(@NotNull GrTypeDefinition grType, @Nullable PsiElement lastParent) {
        GrModifierList modifierList;
        return lastParent == null || (modifierList = grType.getModifierList()) == null || !modifierList.hasAnnotation("groovy.lang.Category");
    }

    private static boolean processInstanceMember(boolean shouldProcessInstance, @NotNull PsiMember member) {
        if (shouldProcessInstance) {
            return true;
        }
        if (member instanceof GrReflectedMethod) {
            return ((GrReflectedMethod)member).getBaseMethod().hasModifierProperty("static");
        }
        return member.hasModifierProperty("static");
    }

    public static boolean isSameDeclaration(PsiElement place, PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        if (element instanceof GrScriptField) {
            element = ((GrScriptField)element).getOriginalVariable();
        }
        while (place != null) {
            if (place == element) {
                return true;
            }
            place = place.getParent();
            if (element instanceof GrField && ((GrField)element).getInitializerGroovy() == place) {
                return false;
            }
            if (place instanceof GrClosableBlock) {
                return false;
            }
            if (!(place instanceof GrEnumConstantInitializer)) continue;
            return false;
        }
        return false;
    }

    private static boolean isMethodVisible(boolean isPlaceGroovy, PsiMethod method) {
        return isPlaceGroovy || !(method instanceof GrGdkMethod);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, false)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            return method;
        }
        return null;
    }

    private static PsiMethod[] findMethodsByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSyntheticAccessors) {
        if (!checkBases) {
            ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
            for (PsiMethod method : CollectClassMembersUtil.getMethods(grType, includeSyntheticAccessors)) {
                if (!name.equals(method.getName())) continue;
                result2.add(method);
            }
            return result2.toArray(PsiMethod.EMPTY_ARRAY);
        }
        Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, includeSyntheticAccessors);
        return PsiImplUtil.mapToMethods(methodsMap.get(name));
    }

    public static PsiMethod @NotNull [] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, true);
    }

    public static PsiMethod @NotNull [] findCodeMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, false);
    }

    public static PsiMethod @NotNull [] findMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsByName(grType, name, checkBases, true);
    }

    private static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases, boolean includeSynthetic) {
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, includeSynthetic)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            result2.add(method);
        }
        return result2.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Nullable
    private static MethodSignature getSignatureForInheritor(@NotNull PsiMethod methodFromSuperClass, @NotNull GrTypeDefinition inheritor) {
        PsiClass clazz = methodFromSuperClass.getContainingClass();
        if (clazz == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)clazz, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        return methodFromSuperClass.getSignature(superSubstitutor);
    }

    public static PsiMethod @NotNull [] findCodeMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        return GrClassImplUtil.findMethodsByName(grType, name, checkBases, false);
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(GrTypeDefinition grType, String name, boolean checkBases) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2;
        block3: {
            block2: {
                PsiMethod[] methods;
                result2 = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
                if (checkBases) break block2;
                for (PsiMethod method : methods = grType.findMethodsByName(name, false)) {
                    result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
                }
                break block3;
            }
            Map<String, List<CandidateInfo>> map2 = CollectClassMembersUtil.getAllMethods(grType, true);
            List<CandidateInfo> candidateInfos = map2.get(name);
            if (candidateInfos == null) break block3;
            for (CandidateInfo info : candidateInfos) {
                PsiElement element = info.getElement();
                result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)element), (Object)info.getSubstitutor()));
            }
        }
        return result2;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors(GrTypeDefinition grType) {
        Map<String, List<CandidateInfo>> allMethodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (List<CandidateInfo> infos : allMethodsMap.values()) {
            for (CandidateInfo info : infos) {
                result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
            }
        }
        return result2;
    }

    @Nullable
    public static PsiField findFieldByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSynthetic) {
        if (!checkBases) {
            for (PsiField field : CollectClassMembersUtil.getFields(grType, includeSynthetic)) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            return null;
        }
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        CandidateInfo info = fieldsMap.get(name);
        return info == null ? null : (PsiField)info.getElement();
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType) {
        return GrClassImplUtil.getAllFields(grType, true);
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType, boolean includeSynthetic) {
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        return (PsiField[])ContainerUtil.map2Array(fieldsMap.values(), PsiField.class, entry -> (PsiField)entry.getElement());
    }

    public static boolean isClassEquivalentTo(GrTypeDefinitionImpl definition, PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo((PsiClass)definition, (PsiElement)another);
    }

    @NotNull
    public static Collection<? extends PsiMethod> expandReflectedMethods(@NotNull PsiMethod method) {
        Object[] methods;
        if (method instanceof GrMethod && (methods = ((GrMethod)method).getReflectedMethods()).length > 0) {
            return new SmartList(methods);
        }
        return Collections.singletonList(method);
    }

    @NotNull
    public static Set<MethodSignature> getDuplicatedSignatures(@NotNull PsiClass clazz) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)clazz, () -> {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory();
            MostlySingularMultiMap signatures2 = new MostlySingularMultiMap();
            for (PsiMethod method : clazz.getMethods()) {
                MethodSignature signature = method.getSignature(factory.createRawSubstitutor((PsiTypeParameterListOwner)method));
                signatures2.add((Object)signature, (Object)method);
            }
            HashSet<MethodSignature> result2 = new HashSet<MethodSignature>();
            for (MethodSignature signature : signatures2.keySet()) {
                if (signatures2.valuesForKey((Object)signature) <= 1) continue;
                result2.add(signature);
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{clazz});
        });
    }

    public static GrAccessorMethod findSetter(GrField field) {
        return (GrAccessorMethod)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.doGetSetter(field), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static GrAccessorMethod doGetSetter(GrField field) {
        PsiMethod[] setters;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        for (PsiMethod setter : setters = containingClass.findMethodsByName(GroovyPropertyUtils.getSetterName(field.getName()), false)) {
            if (!(setter instanceof GrAccessorMethod)) continue;
            return (GrAccessorMethod)setter;
        }
        return null;
    }

    public static GrAccessorMethod[] findGetters(GrField field) {
        return (GrAccessorMethod[])CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.doGetGetters(field), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static GrAccessorMethod @NotNull [] doGetGetters(GrField field) {
        PsiMethod[] booleanGetters;
        PsiClass containingClass = field.getContainingClass();
        if (!(containingClass instanceof GrTypeDefinition)) {
            return GrAccessorMethod.EMPTY_ARRAY;
        }
        GrAccessorMethod getter = null;
        GrAccessorMethod booleanGetter = null;
        for (PsiMethod method : containingClass.getMethods()) {
            if (!(method instanceof GrAccessorMethod) || ((GrAccessorMethod)method).isSetter() || ((GrAccessorMethod)method).getProperty() != field) continue;
            getter = (GrAccessorMethod)method;
            break;
        }
        for (PsiMethod method : booleanGetters = containingClass.findMethodsByName(GroovyPropertyUtils.getGetterNameBoolean(field.getName()), false)) {
            if (!(method instanceof GrAccessorMethod)) continue;
            booleanGetter = (GrAccessorMethod)method;
            break;
        }
        if (getter != null && booleanGetter != null) {
            return new GrAccessorMethod[]{getter, booleanGetter};
        }
        if (getter != null) {
            return new GrAccessorMethod[]{getter};
        }
        return GrAccessorMethod.EMPTY_ARRAY;
    }
}

