/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.GrImportUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.resolve.noncode.MixinMemberContributor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

public final class GdkMethodUtil {
    @NonNls
    public static final Set<String> COLLECTION_METHOD_NAMES = Set.of("each", "eachWithIndex", "any", "every", "reverseEach", "collect", "collectAll", "find", "findAll", "retainAll", "removeAll", "split", "groupBy", "groupEntriesBy", "findLastIndexOf", "findIndexValues", "findIndexOf");
    @NlsSafe
    private static final String WITH = "with";
    @NlsSafe
    private static final String IDENTITY = "identity";
    @NlsSafe
    private static final String TAP = "tap";
    @NlsSafe
    public static final String EACH_WITH_INDEX = "eachWithIndex";
    @NlsSafe
    public static final String INJECT = "inject";
    @NlsSafe
    public static final String EACH_PERMUTATION = "eachPermutation";
    @NlsSafe
    public static final String WITH_DEFAULT = "withDefault";
    @NlsSafe
    public static final String SORT = "sort";
    @NlsSafe
    public static final String WITH_STREAM = "withStream";
    @NlsSafe
    public static final String WITH_STREAMS = "withStreams";
    @NlsSafe
    public static final String WITH_OBJECT_STREAMS = "withObjectStreams";
    private static final Map<String, String> AST_TO_EXPR_MAPPER = Map.of("org.codehaus.groovy.ast.expr.ClosureExpression", "groovy.lang.Closure", "org.codehaus.groovy.ast.expr.ListExpression", "java.util.List", "org.codehaus.groovy.ast.expr.MapExpression", "java.util.Map", "org.codehaus.groovy.ast.expr.TupleExpression", "groovy.lang.Tuple", "org.codehaus.groovy.ast.expr.MethodCallExpression", "java.lang.Object");
    private static final String MACRO_ORIGIN_INFO = "Macro method";

    private GdkMethodUtil() {
    }

    public static boolean processCategoryMethods(PsiElement place, PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiClass categoryClass) {
        for (final PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
            DelegatingScopeProcessor delegate = new DelegatingScopeProcessor(psiScopeProcessor){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState delegateState) {
                    if (element instanceof PsiMethod && GdkMethodUtil.isCategoryMethod((PsiMethod)element, null, null, null)) {
                        PsiMethod method = (PsiMethod)element;
                        return psiScopeProcessor.execute((PsiElement)GrGdkMethodImpl.createGdkMethod(method, false, GdkMethodUtil.generateOriginInfo(method)), delegateState);
                    }
                    return true;
                }
            };
            if (categoryClass.processDeclarations((PsiScopeProcessor)delegate, state, null, place)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInWithContext(PsiElement resolveContext) {
        PsiMethod method;
        PsiElement pparent;
        PsiElement parent2;
        return resolveContext instanceof GrExpression && (parent2 = resolveContext.getParent()) instanceof GrReferenceExpression && ((GrReferenceExpression)parent2).getQualifier() == resolveContext && (pparent = parent2.getParent()) instanceof GrMethodCall && (method = ((GrMethodCall)pparent).resolveMethod()) instanceof GrGdkMethod && GdkMethodUtil.isWithName(method.getName());
    }

    public static boolean isWithName(String name) {
        return WITH.equals(name) || IDENTITY.equals(name) || TAP.equals(name);
    }

    @Nullable
    @NonNls
    public static String generateOriginInfo(PsiMethod method) {
        PsiClass cc = method.getContainingClass();
        if (cc == null) {
            return null;
        }
        return "via " + cc.getName();
    }

    public static boolean processMixinToMetaclass(GrStatementOwner run, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        GrStatement[] statements2;
        if (!ResolveUtilKt.shouldProcessMethods(processor)) {
            return true;
        }
        for (GrStatement statement : statements2 = run.getStatements()) {
            if (statement == lastParent) break;
            MixinInfo result2 = GdkMethodUtil.getMixinTypes(statement);
            if (result2 != null) {
                PsiClassType subjectType = result2.subjectType;
                GrReferenceExpression qualifier = result2.ref;
                PsiClass mixin = result2.mixin;
                for (PsiScopeProcessor psiScopeProcessor : MultiProcessor.allProcessors(processor)) {
                    if (mixin.processDeclarations((PsiScopeProcessor)new MixinMemberContributor.MixinProcessor(psiScopeProcessor, (PsiType)subjectType, qualifier), state, null, place)) continue;
                    return false;
                }
                continue;
            }
            Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> closureResult = GdkMethodUtil.getClosureMixins(statement);
            if (closureResult == null) continue;
            PsiClassType subjectType = (PsiClassType)closureResult.first;
            GrReferenceExpression qualifier = (GrReferenceExpression)closureResult.second;
            List methods = (List)closureResult.third;
            MixinMemberContributor.MixinProcessor mixinProcessor = new MixinMemberContributor.MixinProcessor(processor, (PsiType)subjectType, qualifier);
            for (GrMethod method : methods) {
                ResolveUtil.processElement((PsiScopeProcessor)mixinProcessor, (PsiNamedElement)method, state);
            }
        }
        return true;
    }

    @NotNull
    private static GrMethod createMethod(@NotNull CallSignature<?> signature, @NotNull String name, @NotNull GrAssignmentExpression statement, @NotNull PsiClass closure) {
        GrLightMethodBuilder builder = new GrLightMethodBuilder(statement.getManager(), name);
        int i2 = 0;
        for (CallParameter parameter : signature.getParameters()) {
            String parameterName = (String)ObjectUtils.notNull((Object)parameter.getParameterName(), (Object)("p" + i2));
            PsiType type2 = (PsiType)ObjectUtils.notNull((Object)parameter.getType(), () -> TypesUtil.getJavaLangObject(statement));
            builder.addParameter(parameterName, type2, parameter.isOptional());
            ++i2;
        }
        builder.setNavigationElement(statement.getLValue());
        builder.setReturnType(signature.getReturnType());
        builder.setContainingClass(closure);
        return builder;
    }

    private static Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> getClosureMixins(GrStatement statement) {
        if (!(statement instanceof GrAssignmentExpression)) {
            return null;
        }
        return (Trinity)CachedValuesManager.getCachedValue((PsiElement)statement, () -> CachedValueProvider.Result.create(GdkMethodUtil.doGetClosureMixins((GrAssignmentExpression)statement), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static Trinity<PsiClassType, GrReferenceExpression, List<GrMethod>> doGetClosureMixins(@NotNull GrAssignmentExpression assignment) {
        GrExpression lValue = assignment.getLValue();
        if (!(lValue instanceof GrReferenceExpression)) {
            return null;
        }
        String mixedMethodName = ((GrReferenceExpression)lValue).getReferenceName();
        if (mixedMethodName == null) {
            return null;
        }
        GrExpression metaClassExpression = (GrExpression)((GrReferenceExpression)lValue).getQualifier();
        if (!(metaClassExpression instanceof GrReferenceExpression)) {
            return null;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return null;
        }
        PsiElement resolved = ((GrReferenceExpression)metaClassExpression).resolve();
        if (!(resolved instanceof PsiMethod) || !GdkMethodUtil.isMetaClassMethod((PsiMethod)resolved)) {
            return null;
        }
        GrExpression classQualifier = (GrExpression)((GrReferenceExpression)metaClassExpression).getQualifier();
        Pair<PsiClassType, GrReferenceExpression> original = GdkMethodUtil.getPsiClassFromReference(classQualifier);
        if (original == null) {
            return null;
        }
        PsiType type2 = rValue.getType();
        if (!(type2 instanceof GroovyClosureType)) {
            return null;
        }
        PsiClass closure = JavaPsiFacade.getInstance((Project)assignment.getProject()).findClass("groovy.lang.Closure", assignment.getResolveScope());
        if (closure == null) {
            return null;
        }
        ArrayList<GrMethod> methods = new ArrayList<GrMethod>();
        for (CallSignature<?> signature : ((GroovyClosureType)type2).getSignatures()) {
            methods.add(GdkMethodUtil.createMethod(signature, mixedMethodName, assignment, closure));
        }
        return Trinity.create((Object)((PsiClassType)original.first), (Object)((GrReferenceExpression)original.second), methods);
    }

    @Nullable
    private static MixinInfo getMixinTypes(GrStatement statement) {
        if (!(statement instanceof GrMethodCall)) {
            return null;
        }
        return (MixinInfo)CachedValuesManager.getCachedValue((PsiElement)statement, () -> {
            GrMethodCall call = (GrMethodCall)statement;
            Pair<PsiClassType, GrReferenceExpression> original = GdkMethodUtil.getTypeToMixIn(call);
            if (original == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            PsiClass mix = GdkMethodUtil.getTypeToMix(call);
            if (mix == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)new MixinInfo((PsiClassType)original.first, (GrReferenceExpression)original.second, mix), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static PsiClass getTypeToMix(GrMethodCall call) {
        PsiElement resolved;
        if (!GdkMethodUtil.isSingleExpressionArg(call)) {
            return null;
        }
        GrExpression mixinRef = call.getExpressionArguments()[0];
        if (GdkMethodUtil.isClassRef(mixinRef)) {
            mixinRef = (GrExpression)((GrReferenceExpression)mixinRef).getQualifier();
        }
        if (mixinRef instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)mixinRef).resolve()) instanceof PsiClass) {
            return (PsiClass)resolved;
        }
        return null;
    }

    private static boolean isSingleExpressionArg(@NotNull GrMethodCall call) {
        return call.getExpressionArguments().length == 1 && !PsiImplUtil.hasNamedArguments(call.getArgumentList()) && !call.hasClosureArguments();
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getTypeToMixIn(GrMethodCall methodCall) {
        PsiElement resolved;
        GrExpression invoked = methodCall.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpression)) {
            return null;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)invoked;
        if (GrImportUtil.acceptName(referenceExpression, "mixin") && (resolved = referenceExpression.resolve()) instanceof PsiMethod && GdkMethodUtil.isMixinMethod((PsiMethod)resolved)) {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            Pair<PsiClassType, GrReferenceExpression> type2 = GdkMethodUtil.getPsiClassFromReference(qualifier);
            if (type2 != null) {
                return type2;
            }
            if (qualifier != null && GdkMethodUtil.isMetaClass(qualifier.getType())) {
                if (qualifier instanceof GrMethodCall) {
                    qualifier = ((GrMethodCall)qualifier).getInvokedExpression();
                }
                if (qualifier instanceof GrReferenceExpression) {
                    GrExpression qqualifier = ((GrReferenceExpression)qualifier).getQualifierExpression();
                    if (qqualifier != null) {
                        Pair<PsiClassType, GrReferenceExpression> type1 = GdkMethodUtil.getPsiClassFromMetaClassReference(qqualifier);
                        if (type1 != null) {
                            return type1;
                        }
                    } else {
                        PsiType qtype = PsiImplUtil.getQualifierType((GrReferenceExpression)qualifier);
                        if (qtype instanceof PsiClassType && ((PsiClassType)qtype).resolve() != null) {
                            return Pair.create((Object)((PsiClassType)qtype), (Object)((GrReferenceExpression)qualifier));
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isMixinMethod(@NotNull PsiMethod method) {
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        PsiClass containingClass = method.getContainingClass();
        String name = method.getName();
        return "mixin".equals(name) && containingClass != null && "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName());
    }

    private static boolean isMetaClassMethod(@NotNull PsiMethod method) {
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        PsiClass containingClass = method.getContainingClass();
        String name = method.getName();
        return "getMetaClass".equals(name) && containingClass != null && method.getParameterList().isEmpty() ^ "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName());
    }

    private static boolean isMetaClass(PsiType qualifierType) {
        return qualifierType != null && qualifierType.equalsToText("groovy.lang.MetaClass");
    }

    private static boolean isClassRef(GrExpression mixinRef) {
        return mixinRef instanceof GrReferenceExpression && "class".equals(((GrReferenceExpression)mixinRef).getReferenceName());
    }

    @Nullable
    private static Pair<PsiClassType, GrReferenceExpression> getPsiClassFromReference(@Nullable GrExpression ref2) {
        if (ref2 == null) {
            return null;
        }
        PsiType type2 = ResolveUtil.unwrapClassType(ref2.getType());
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        if (GdkMethodUtil.isClassRef(ref2)) {
            ref2 = (GrExpression)((GrReferenceExpression)ref2).getQualifier();
        }
        if (!(ref2 instanceof GrReferenceExpression)) {
            return null;
        }
        return Pair.create((Object)((PsiClassType)type2), (Object)((GrReferenceExpression)ref2));
    }

    private static Pair<PsiClassType, GrReferenceExpression> getPsiClassFromMetaClassReference(@NotNull GrExpression expression) {
        PsiType type2 = expression.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        GrReferenceExpression ref2 = expression instanceof GrReferenceExpression ? (GrReferenceExpression)expression : null;
        return Pair.create((Object)((PsiClassType)type2), (Object)ref2);
    }

    public static boolean isCategoryMethod(@NotNull PsiMethod method, @Nullable PsiType qualifierType, @Nullable PsiElement place, @Nullable PsiSubstitutor substitutor2) {
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return false;
        }
        if (qualifierType == null) {
            return true;
        }
        PsiType selfType = parameters2[0].getType();
        if (selfType instanceof PsiPrimitiveType) {
            return false;
        }
        if (substitutor2 != null) {
            selfType = substitutor2.substitute(selfType);
        }
        if (PsiTypesUtil.classNameEquals((PsiType)selfType, (String)"java.lang.Class") && place instanceof GrReferenceExpression && ((GrReferenceExpression)place).resolve() instanceof PsiClass) {
            return TypesUtil.isAssignableByMethodCallConversion(selfType, TypesUtil.createJavaLangClassType(qualifierType, (PsiElement)method), (PsiElement)method);
        }
        return TypesUtil.isAssignableByMethodCallConversion(selfType, qualifierType, (PsiElement)method);
    }

    @Nullable
    public static PsiClassType getCategoryType(final @NotNull PsiClass categoryAnnotationOwner) {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)categoryAnnotationOwner, (CachedValueProvider)new CachedValueProvider<PsiClassType>(){

            public CachedValueProvider.Result<PsiClassType> compute() {
                return CachedValueProvider.Result.create((Object)this.inferCategoryType(categoryAnnotationOwner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }

            @Nullable
            private PsiClassType inferCategoryType(PsiClass aClass) {
                return (PsiClassType)RecursionManager.doPreventingRecursion((Object)aClass, (boolean)true, (Computable)((NullableComputable)() -> {
                    PsiModifierList modifierList = aClass.getModifierList();
                    if (modifierList == null) {
                        return null;
                    }
                    PsiAnnotation annotation = modifierList.findAnnotation("groovy.lang.Category");
                    if (annotation == null) {
                        return null;
                    }
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue("value");
                    if (!(value2 instanceof GrReferenceExpression)) {
                        return null;
                    }
                    if ("class".equals(((GrReferenceExpression)value2).getReferenceName())) {
                        value2 = (PsiAnnotationMemberValue)((GrReferenceExpression)value2).getQualifier();
                    }
                    if (!(value2 instanceof GrReferenceExpression)) {
                        return null;
                    }
                    PsiElement resolved = ((GrReferenceExpression)value2).resolve();
                    if (!(resolved instanceof PsiClass)) {
                        return null;
                    }
                    String className = ((PsiClass)resolved).getQualifiedName();
                    if (className == null) {
                        className = ((PsiClass)resolved).getName();
                    }
                    if (className == null) {
                        return null;
                    }
                    return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeByFQClassName(className, resolved.getResolveScope());
                }));
            }
        });
    }

    public static boolean isWithOrIdentity(@Nullable PsiElement element) {
        if (element instanceof PsiMethod && GdkMethodUtil.isWithName(((PsiMethod)element).getName())) {
            PsiClass containingClass;
            if (element instanceof GrGdkMethod) {
                element = ((GrGdkMethod)element).getStaticMethod();
            }
            if ((containingClass = ((PsiMethod)element).getContainingClass()) != null && "org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    public static PsiMethod createMacroMethod(@NotNull PsiMethod prototype) {
        GrLightMethodBuilder syntheticMacro = new GrLightMethodBuilder(prototype.getManager(), prototype.getName());
        syntheticMacro.setModifiers(new String[]{"static"});
        PsiParameterList list = prototype.getParameterList();
        for (int i2 = 1; i2 < list.getParametersCount(); ++i2) {
            String name;
            String generatedParameterType;
            PsiParameter actualParameter = list.getParameter(i2);
            if (actualParameter == null) {
                generatedParameterType = "java.lang.Object";
                name = "expression";
            } else {
                PsiType type2 = actualParameter.getType();
                generatedParameterType = !type2.equals(PsiType.NULL) ? AST_TO_EXPR_MAPPER.getOrDefault(type2.getCanonicalText(), "java.lang.Object") : "java.lang.Object";
                name = actualParameter.getName();
            }
            syntheticMacro.addParameter(new GrLightParameter(name, (PsiType)PsiType.getTypeByName((String)generatedParameterType, (Project)prototype.getProject(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)prototype.getProject())), (PsiElement)prototype));
        }
        syntheticMacro.setNavigationElement((PsiElement)prototype);
        syntheticMacro.setOriginInfo(MACRO_ORIGIN_INFO);
        return syntheticMacro;
    }

    public static boolean isMacro(@Nullable PsiMethod method) {
        return method instanceof OriginInfoAwareElement && MACRO_ORIGIN_INFO.equals(((OriginInfoAwareElement)method).getOriginInfo());
    }

    record MixinInfo(PsiClassType subjectType, GrReferenceExpression ref, PsiClass mixin) {
    }
}

