/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesKt;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrWildcardTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return switch (position) {
            case GrTypeConverter.Position.METHOD_PARAMETER, GrTypeConverter.Position.GENERIC_PARAMETER, GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.RETURN_VALUE -> true;
            default -> false;
        };
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType ltype, @NotNull PsiType rtype, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        PsiType lBound = TypesKt.promoteLowerBoundWildcard(ltype, context);
        PsiType rBound = TypesKt.promoteLowerBoundWildcard(rtype, context);
        if (lBound == null || rBound == null) {
            return null;
        }
        if (TypeConversionUtil.isAssignable((PsiType)lBound, (PsiType)rBound)) {
            return ConversionResult.OK;
        }
        return null;
    }
}

