/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrStringConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return position == GrTypeConverter.Position.ASSIGNMENT || position == GrTypeConverter.Position.RETURN_VALUE || position == GrTypeConverter.Position.EXPLICIT_CAST || position == GrTypeConverter.Position.METHOD_PARAMETER;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (!TypesUtil.isClassType(lType, "java.lang.String")) {
            return null;
        }
        if (position == GrTypeConverter.Position.EXPLICIT_CAST || position == GrTypeConverter.Position.METHOD_PARAMETER) {
            return TypesUtil.isClassType(rType, "groovy.lang.GString") ? ConversionResult.OK : null;
        }
        return ConversionResult.OK;
    }

    @Override
    @Nullable
    public Collection<ConstraintFormula> reduceTypeConstraint(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull GrTypeConverter.Position position, @NotNull PsiElement context) {
        if (position == GrTypeConverter.Position.METHOD_PARAMETER && TypesUtil.isClassType(leftType, "java.lang.String") && TypesUtil.isClassType(rightType, "groovy.lang.GString")) {
            return Collections.emptyList();
        }
        return null;
    }
}

