/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;

public class GrNumberConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return true;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (CompileStaticUtil.isCompileStatic(context)) {
            return GrNumberConverter.isCSConvertible(targetType, actualType, position);
        }
        if (position == GrTypeConverter.Position.METHOD_PARAMETER) {
            return GrNumberConverter.methodParameterConvert(targetType, actualType);
        }
        if (TypesUtil.isNumericType(targetType) && TypesUtil.isNumericType(actualType)) {
            return ConversionResult.OK;
        }
        return null;
    }

    private static ConversionResult methodParameterConvert(PsiType targetType, PsiType actualType) {
        if (TypesUtil.isClassType(actualType, "java.math.BigDecimal")) {
            return TypeConversionUtil.isFloatOrDoubleType((PsiType)targetType) ? ConversionResult.OK : null;
        }
        return null;
    }

    @Nullable
    private static ConversionResult isCSConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position currentPosition) {
        if (currentPosition == GrTypeConverter.Position.METHOD_PARAMETER) {
            return null;
        }
        if (TypesUtil.isClassType(actualType, "java.math.BigDecimal")) {
            return TypeConversionUtil.isFloatOrDoubleType((PsiType)targetType) ? ConversionResult.OK : null;
        }
        if (TypesUtil.isClassType(targetType, "java.math.BigDecimal")) {
            return TypesUtil.isNumericType(actualType) || PsiType.NULL.equals((Object)actualType) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        if (TypesUtil.isClassType(targetType, "java.math.BigInteger")) {
            return TypesUtil.isIntegralNumberType(actualType) || PsiType.NULL.equals((Object)actualType) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        if (TypesUtil.isClassType(actualType, "java.math.BigInteger")) {
            return TypesUtil.isClassType(targetType, "java.math.BigInteger", "java.math.BigDecimal") ? ConversionResult.OK : null;
        }
        if (TypesUtil.isNumericType(targetType) && TypesUtil.isNumericType(actualType)) {
            return ConversionResult.OK;
        }
        return null;
    }
}

