/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;

public class GrNullVoidConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return switch (position) {
            case GrTypeConverter.Position.RETURN_VALUE, GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.METHOD_PARAMETER -> true;
            default -> false;
        };
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        PsiClassType objectType = TypesUtil.getJavaLangObject(context);
        boolean isCompileStatic2 = CompileStaticUtil.isCompileStatic(context);
        if (position == GrTypeConverter.Position.RETURN_VALUE && targetType.equals(objectType) && PsiType.VOID.equals((Object)actualType)) {
            return ConversionResult.OK;
        }
        if (PsiType.VOID.equals((Object)actualType)) {
            switch (position) {
                case RETURN_VALUE: {
                    return ConversionResult.WARNING;
                }
                case ASSIGNMENT: {
                    if (targetType.equals(PsiType.BOOLEAN)) {
                        return null;
                    }
                    if (targetType.equals(PsiType.getJavaLangString((PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope()))) {
                        return ConversionResult.WARNING;
                    }
                    return isCompileStatic2 ? ConversionResult.ERROR : ConversionResult.WARNING;
                }
            }
        } else if (actualType == PsiType.NULL) {
            if (position == GrTypeConverter.Position.RETURN_VALUE) {
                if (targetType instanceof PsiPrimitiveType) {
                    return ConversionResult.WARNING;
                }
            } else {
                return targetType instanceof PsiPrimitiveType ? ConversionResult.ERROR : ConversionResult.OK;
            }
        }
        return null;
    }
}

