/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;

public class GrContainerConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (CompileStaticUtil.isCompileStatic(context)) {
            return null;
        }
        if (lType instanceof PsiArrayType) {
            PsiType lComponentType = ((PsiArrayType)lType).getComponentType();
            PsiType rComponentType = ClosureParameterEnhancer.findTypeForIteration(rType, (PsiElement)context);
            if (rComponentType != null && TypesUtil.isAssignable(lComponentType, rComponentType, context)) {
                return ConversionResult.OK;
            }
        }
        return null;
    }
}

