/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrClassConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return switch (position) {
            case GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.RETURN_VALUE -> true;
            default -> false;
        };
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (!PsiTypesUtil.classNameEquals((PsiType)targetType, (String)"java.lang.Class")) {
            return null;
        }
        if (PsiTypesUtil.classNameEquals((PsiType)actualType, (String)"java.lang.Class")) {
            return null;
        }
        if (actualType == PsiType.NULL) {
            return ConversionResult.OK;
        }
        GrLiteral literal = GrClassConverter.getLiteral(context);
        Object value2 = literal == null ? null : literal.getValue();
        String fqn = value2 == null ? null : value2.toString();
        PsiClass psiClass = fqn == null ? null : JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqn, context.getResolveScope());
        return psiClass == null ? ConversionResult.WARNING : ConversionResult.OK;
    }
}

