/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrCharConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        GrExpression rValue;
        if (!PsiType.CHAR.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(lType))) {
            return null;
        }
        if (PsiType.CHAR.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(rType))) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isNumericType(rType)) {
            if (rType instanceof PsiPrimitiveType || TypesUtil.unboxPrimitiveTypeWrapper(rType) instanceof PsiPrimitiveType) {
                return PsiType.CHAR.equals((Object)lType) ? ConversionResult.OK : ConversionResult.ERROR;
            }
            return ConversionResult.ERROR;
        }
        if (context instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)context;
            rValue = assignmentExpression.getRValue();
        } else if (context instanceof GrVariable) {
            GrVariable assignmentExpression = (GrVariable)context;
            rValue = assignmentExpression.getInitializerGroovy();
        } else {
            rValue = null;
        }
        if (rValue instanceof GrListOrMap && ((GrListOrMap)rValue).isEmpty()) {
            return ConversionResult.WARNING;
        }
        if (PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(rType))) {
            return switch (position) {
                case GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.RETURN_VALUE -> ConversionResult.WARNING;
                default -> null;
            };
        }
        if (position == GrTypeConverter.Position.RETURN_VALUE) {
            return null;
        }
        if (!TypesUtil.isClassType(rType, "java.lang.String")) {
            return null;
        }
        return GrCharConverter.checkSingleSymbolLiteral(context) ? ConversionResult.OK : ConversionResult.ERROR;
    }

    public static boolean checkSingleSymbolLiteral(GroovyPsiElement context) {
        GrLiteral literal = GrCharConverter.getLiteral(context);
        Object value2 = literal == null ? null : literal.getValue();
        return value2 != null && value2.toString().length() == 1;
    }
}

