/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrBooleanTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        return position != GrTypeConverter.Position.EXPLICIT_CAST && position != GrTypeConverter.Position.GENERIC_PARAMETER;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (!PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(targetType))) {
            return null;
        }
        return switch (position) {
            case GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.RETURN_VALUE -> ConversionResult.OK;
            default -> null;
        };
    }
}

