/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public abstract class GrVariableStubBase<V extends GrVariable>
extends StubBase<V>
implements NamedStub<V> {
    @Nullable
    private final StringRef myNameRef;
    private final String @NotNull [] myAnnotations;
    @Nullable
    private final String myTypeText;
    private SoftReference<GrTypeElement> myTypeElement;

    protected GrVariableStubBase(StubElement parent2, IStubElementType elementType, @Nullable StringRef ref2, String @NotNull [] annotations2, @Nullable String text) {
        super(parent2, elementType);
        this.myNameRef = ref2;
        this.myAnnotations = annotations2;
        this.myTypeText = text;
    }

    @Nullable
    public String getName() {
        return StringRef.toString((StringRef)this.myNameRef);
    }

    public String @NotNull [] getAnnotations() {
        return this.myAnnotations;
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    @Nullable
    public GrTypeElement getTypeElement() {
        String typeText = this.getTypeText();
        if (typeText == null) {
            return null;
        }
        GrTypeElement typeElement = (GrTypeElement)SoftReference.dereference(this.myTypeElement);
        if (typeElement == null) {
            typeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(typeText, this.getPsi());
            this.myTypeElement = new SoftReference((Object)typeElement);
        }
        return typeElement;
    }
}

